/*******************************************************************************
 * Copyright (c) 2010-2018, Zoltan Ujhelyi, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This file was generated from EMFPatternLanguage.xtext
 *******************************************************************************/
package org.eclipse.viatra.query.patternlanguage.emf.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.viatra.query.patternlanguage.emf.services.EMFPatternLanguageGrammarAccess;
import org.eclipse.viatra.query.patternlanguage.emf.vql.AggregatedValue;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Annotation;
import org.eclipse.viatra.query.patternlanguage.emf.vql.AnnotationParameter;
import org.eclipse.viatra.query.patternlanguage.emf.vql.BoolValue;
import org.eclipse.viatra.query.patternlanguage.emf.vql.CheckConstraint;
import org.eclipse.viatra.query.patternlanguage.emf.vql.ClassType;
import org.eclipse.viatra.query.patternlanguage.emf.vql.CompareConstraint;
import org.eclipse.viatra.query.patternlanguage.emf.vql.EClassifierConstraint;
import org.eclipse.viatra.query.patternlanguage.emf.vql.EnumValue;
import org.eclipse.viatra.query.patternlanguage.emf.vql.FunctionEvaluationValue;
import org.eclipse.viatra.query.patternlanguage.emf.vql.JavaType;
import org.eclipse.viatra.query.patternlanguage.emf.vql.ListValue;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Modifiers;
import org.eclipse.viatra.query.patternlanguage.emf.vql.NumberValue;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PackageImport;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PathExpressionConstraint;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternBody;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternCall;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternCompositionConstraint;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternImport;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternLanguagePackage;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternModel;
import org.eclipse.viatra.query.patternlanguage.emf.vql.ReferenceType;
import org.eclipse.viatra.query.patternlanguage.emf.vql.StringValue;
import org.eclipse.viatra.query.patternlanguage.emf.vql.TypeCheckConstraint;
import org.eclipse.viatra.query.patternlanguage.emf.vql.VQLImportSection;
import org.eclipse.viatra.query.patternlanguage.emf.vql.VariableReference;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmInnerTypeReference;
import org.eclipse.xtext.common.types.JvmLowerBound;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBasicForLoopExpression;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XDoWhileExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XIfExpression;
import org.eclipse.xtext.xbase.XInstanceOfExpression;
import org.eclipse.xtext.xbase.XListLiteral;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XNullLiteral;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XPostfixOperation;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XSetLiteral;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XSynchronizedExpression;
import org.eclipse.xtext.xbase.XThrowExpression;
import org.eclipse.xtext.xbase.XTryCatchFinallyExpression;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XWhileExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.serializer.XbaseSemanticSequencer;
import org.eclipse.xtext.xtype.XFunctionTypeRef;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;
import org.eclipse.xtext.xtype.XtypePackage;

@SuppressWarnings("all")
public abstract class AbstractEMFPatternLanguageSemanticSequencer extends XbaseSemanticSequencer {

	@Inject
	private EMFPatternLanguageGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == TypesPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case TypesPackage.JVM_FORMAL_PARAMETER:
				if (rule == grammarAccess.getFullJvmFormalParameterRule()) {
					sequence_FullJvmFormalParameter(context, (JvmFormalParameter) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getJvmFormalParameterRule()) {
					sequence_JvmFormalParameter(context, (JvmFormalParameter) semanticObject); 
					return; 
				}
				else break;
			case TypesPackage.JVM_GENERIC_ARRAY_TYPE_REFERENCE:
				sequence_JvmTypeReference(context, (JvmGenericArrayTypeReference) semanticObject); 
				return; 
			case TypesPackage.JVM_INNER_TYPE_REFERENCE:
				sequence_JvmParameterizedTypeReference(context, (JvmInnerTypeReference) semanticObject); 
				return; 
			case TypesPackage.JVM_LOWER_BOUND:
				if (rule == grammarAccess.getJvmLowerBoundAndedRule()) {
					sequence_JvmLowerBoundAnded(context, (JvmLowerBound) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getJvmLowerBoundRule()) {
					sequence_JvmLowerBound(context, (JvmLowerBound) semanticObject); 
					return; 
				}
				else break;
			case TypesPackage.JVM_PARAMETERIZED_TYPE_REFERENCE:
				if (action == grammarAccess.getJvmParameterizedTypeReferenceAccess().getJvmInnerTypeReferenceOuterAction_1_4_0_0_0()) {
					sequence_JvmParameterizedTypeReference_JvmInnerTypeReference_1_4_0_0_0(context, (JvmParameterizedTypeReference) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getJvmTypeReferenceRule()
						|| action == grammarAccess.getJvmTypeReferenceAccess().getJvmGenericArrayTypeReferenceComponentTypeAction_0_1_0_0()
						|| rule == grammarAccess.getJvmParameterizedTypeReferenceRule()
						|| rule == grammarAccess.getJvmArgumentTypeReferenceRule()) {
					sequence_JvmParameterizedTypeReference(context, (JvmParameterizedTypeReference) semanticObject); 
					return; 
				}
				else break;
			case TypesPackage.JVM_TYPE_PARAMETER:
				sequence_JvmTypeParameter(context, (JvmTypeParameter) semanticObject); 
				return; 
			case TypesPackage.JVM_UPPER_BOUND:
				if (rule == grammarAccess.getJvmUpperBoundAndedRule()) {
					sequence_JvmUpperBoundAnded(context, (JvmUpperBound) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getJvmUpperBoundRule()) {
					sequence_JvmUpperBound(context, (JvmUpperBound) semanticObject); 
					return; 
				}
				else break;
			case TypesPackage.JVM_WILDCARD_TYPE_REFERENCE:
				sequence_JvmWildcardTypeReference(context, (JvmWildcardTypeReference) semanticObject); 
				return; 
			}
		else if (epackage == PatternLanguagePackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case PatternLanguagePackage.AGGREGATED_VALUE:
				sequence_AggregatedValue(context, (AggregatedValue) semanticObject); 
				return; 
			case PatternLanguagePackage.ANNOTATION:
				sequence_Annotation(context, (Annotation) semanticObject); 
				return; 
			case PatternLanguagePackage.ANNOTATION_PARAMETER:
				sequence_AnnotationParameter(context, (AnnotationParameter) semanticObject); 
				return; 
			case PatternLanguagePackage.BOOL_VALUE:
				sequence_BoolValue(context, (BoolValue) semanticObject); 
				return; 
			case PatternLanguagePackage.CHECK_CONSTRAINT:
				sequence_CheckConstraint(context, (CheckConstraint) semanticObject); 
				return; 
			case PatternLanguagePackage.CLASS_TYPE:
				sequence_Type(context, (ClassType) semanticObject); 
				return; 
			case PatternLanguagePackage.COMPARE_CONSTRAINT:
				sequence_CompareConstraint(context, (CompareConstraint) semanticObject); 
				return; 
			case PatternLanguagePackage.ECLASSIFIER_CONSTRAINT:
				sequence_EClassifierConstraint(context, (EClassifierConstraint) semanticObject); 
				return; 
			case PatternLanguagePackage.ENUM_VALUE:
				sequence_EnumValue(context, (EnumValue) semanticObject); 
				return; 
			case PatternLanguagePackage.FUNCTION_EVALUATION_VALUE:
				sequence_FunctionEvaluationValue(context, (FunctionEvaluationValue) semanticObject); 
				return; 
			case PatternLanguagePackage.JAVA_TYPE:
				sequence_JavaType(context, (JavaType) semanticObject); 
				return; 
			case PatternLanguagePackage.LIST_VALUE:
				sequence_ListValue(context, (ListValue) semanticObject); 
				return; 
			case PatternLanguagePackage.MODIFIERS:
				sequence_Modifiers(context, (Modifiers) semanticObject); 
				return; 
			case PatternLanguagePackage.NUMBER_VALUE:
				sequence_NumberValue(context, (NumberValue) semanticObject); 
				return; 
			case PatternLanguagePackage.PACKAGE_IMPORT:
				sequence_PackageImport(context, (PackageImport) semanticObject); 
				return; 
			case PatternLanguagePackage.PARAMETER:
				sequence_Parameter(context, (org.eclipse.viatra.query.patternlanguage.emf.vql.Parameter) semanticObject); 
				return; 
			case PatternLanguagePackage.PATH_EXPRESSION_CONSTRAINT:
				sequence_PathExpressionConstraint(context, (PathExpressionConstraint) semanticObject); 
				return; 
			case PatternLanguagePackage.PATTERN:
				sequence_Pattern(context, (Pattern) semanticObject); 
				return; 
			case PatternLanguagePackage.PATTERN_BODY:
				sequence_PatternBody(context, (PatternBody) semanticObject); 
				return; 
			case PatternLanguagePackage.PATTERN_CALL:
				sequence_PatternCall(context, (PatternCall) semanticObject); 
				return; 
			case PatternLanguagePackage.PATTERN_COMPOSITION_CONSTRAINT:
				sequence_PatternCompositionConstraint(context, (PatternCompositionConstraint) semanticObject); 
				return; 
			case PatternLanguagePackage.PATTERN_IMPORT:
				sequence_PatternImport(context, (PatternImport) semanticObject); 
				return; 
			case PatternLanguagePackage.PATTERN_MODEL:
				sequence_PatternModel(context, (PatternModel) semanticObject); 
				return; 
			case PatternLanguagePackage.REFERENCE_TYPE:
				sequence_RefType(context, (ReferenceType) semanticObject); 
				return; 
			case PatternLanguagePackage.STRING_VALUE:
				sequence_StringValue(context, (StringValue) semanticObject); 
				return; 
			case PatternLanguagePackage.TYPE_CHECK_CONSTRAINT:
				sequence_TypeCheckConstraint(context, (TypeCheckConstraint) semanticObject); 
				return; 
			case PatternLanguagePackage.VQL_IMPORT_SECTION:
				sequence_VQLImportSection(context, (VQLImportSection) semanticObject); 
				return; 
			case PatternLanguagePackage.VARIABLE_REFERENCE:
				sequence_VariableReference(context, (VariableReference) semanticObject); 
				return; 
			}
		else if (epackage == XbasePackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case XbasePackage.XASSIGNMENT:
				sequence_XAssignment_XMemberFeatureCall(context, (XAssignment) semanticObject); 
				return; 
			case XbasePackage.XBASIC_FOR_LOOP_EXPRESSION:
				sequence_XBasicForLoopExpression(context, (XBasicForLoopExpression) semanticObject); 
				return; 
			case XbasePackage.XBINARY_OPERATION:
				sequence_XAdditiveExpression_XAndExpression_XAssignment_XEqualityExpression_XMultiplicativeExpression_XOrExpression_XOtherOperatorExpression_XRelationalExpression(context, (XBinaryOperation) semanticObject); 
				return; 
			case XbasePackage.XBLOCK_EXPRESSION:
				if (rule == grammarAccess.getXExpressionRule()
						|| rule == grammarAccess.getXAssignmentRule()
						|| action == grammarAccess.getXAssignmentAccess().getXBinaryOperationLeftOperandAction_1_1_0_0_0()
						|| rule == grammarAccess.getXOrExpressionRule()
						|| action == grammarAccess.getXOrExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXAndExpressionRule()
						|| action == grammarAccess.getXAndExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXEqualityExpressionRule()
						|| action == grammarAccess.getXEqualityExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXRelationalExpressionRule()
						|| action == grammarAccess.getXRelationalExpressionAccess().getXInstanceOfExpressionExpressionAction_1_0_0_0_0()
						|| action == grammarAccess.getXRelationalExpressionAccess().getXBinaryOperationLeftOperandAction_1_1_0_0_0()
						|| rule == grammarAccess.getXOtherOperatorExpressionRule()
						|| action == grammarAccess.getXOtherOperatorExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXAdditiveExpressionRule()
						|| action == grammarAccess.getXAdditiveExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXMultiplicativeExpressionRule()
						|| action == grammarAccess.getXMultiplicativeExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXUnaryOperationRule()
						|| rule == grammarAccess.getXCastedExpressionRule()
						|| action == grammarAccess.getXCastedExpressionAccess().getXCastedExpressionTargetAction_1_0_0_0()
						|| rule == grammarAccess.getXPostfixOperationRule()
						|| action == grammarAccess.getXPostfixOperationAccess().getXPostfixOperationOperandAction_1_0_0()
						|| rule == grammarAccess.getXMemberFeatureCallRule()
						|| action == grammarAccess.getXMemberFeatureCallAccess().getXAssignmentAssignableAction_1_0_0_0_0()
						|| action == grammarAccess.getXMemberFeatureCallAccess().getXMemberFeatureCallMemberCallTargetAction_1_1_0_0_0()
						|| rule == grammarAccess.getXPrimaryExpressionRule()
						|| rule == grammarAccess.getXParenthesizedExpressionRule()
						|| rule == grammarAccess.getXBlockExpressionRule()
						|| rule == grammarAccess.getXExpressionOrVarDeclarationRule()) {
					sequence_XBlockExpression(context, (XBlockExpression) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getXExpressionInClosureRule()) {
					sequence_XExpressionInClosure(context, (XBlockExpression) semanticObject); 
					return; 
				}
				else break;
			case XbasePackage.XBOOLEAN_LITERAL:
				sequence_XBooleanLiteral(context, (XBooleanLiteral) semanticObject); 
				return; 
			case XbasePackage.XCASE_PART:
				sequence_XCasePart(context, (XCasePart) semanticObject); 
				return; 
			case XbasePackage.XCASTED_EXPRESSION:
				sequence_XCastedExpression(context, (XCastedExpression) semanticObject); 
				return; 
			case XbasePackage.XCATCH_CLAUSE:
				sequence_XCatchClause(context, (XCatchClause) semanticObject); 
				return; 
			case XbasePackage.XCLOSURE:
				if (rule == grammarAccess.getXExpressionRule()
						|| rule == grammarAccess.getXAssignmentRule()
						|| action == grammarAccess.getXAssignmentAccess().getXBinaryOperationLeftOperandAction_1_1_0_0_0()
						|| rule == grammarAccess.getXOrExpressionRule()
						|| action == grammarAccess.getXOrExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXAndExpressionRule()
						|| action == grammarAccess.getXAndExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXEqualityExpressionRule()
						|| action == grammarAccess.getXEqualityExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXRelationalExpressionRule()
						|| action == grammarAccess.getXRelationalExpressionAccess().getXInstanceOfExpressionExpressionAction_1_0_0_0_0()
						|| action == grammarAccess.getXRelationalExpressionAccess().getXBinaryOperationLeftOperandAction_1_1_0_0_0()
						|| rule == grammarAccess.getXOtherOperatorExpressionRule()
						|| action == grammarAccess.getXOtherOperatorExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXAdditiveExpressionRule()
						|| action == grammarAccess.getXAdditiveExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXMultiplicativeExpressionRule()
						|| action == grammarAccess.getXMultiplicativeExpressionAccess().getXBinaryOperationLeftOperandAction_1_0_0_0()
						|| rule == grammarAccess.getXUnaryOperationRule()
						|| rule == grammarAccess.getXCastedExpressionRule()
						|| action == grammarAccess.getXCastedExpressionAccess().getXCastedExpressionTargetAction_1_0_0_0()
						|| rule == grammarAccess.getXPostfixOperationRule()
						|| action == grammarAccess.getXPostfixOperationAccess().getXPostfixOperationOperandAction_1_0_0()
						|| rule == grammarAccess.getXMemberFeatureCallRule()
						|| action == grammarAccess.getXMemberFeatureCallAccess().getXAssignmentAssignableAction_1_0_0_0_0()
						|| action == grammarAccess.getXMemberFeatureCallAccess().getXMemberFeatureCallMemberCallTargetAction_1_1_0_0_0()
						|| rule == grammarAccess.getXPrimaryExpressionRule()
						|| rule == grammarAccess.getXLiteralRule()
						|| rule == grammarAccess.getXClosureRule()
						|| rule == grammarAccess.getXParenthesizedExpressionRule()
						|| rule == grammarAccess.getXExpressionOrVarDeclarationRule()) {
					sequence_XClosure(context, (XClosure) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getXShortClosureRule()) {
					sequence_XShortClosure(context, (XClosure) semanticObject); 
					return; 
				}
				else break;
			case XbasePackage.XCONSTRUCTOR_CALL:
				sequence_XConstructorCall(context, (XConstructorCall) semanticObject); 
				return; 
			case XbasePackage.XDO_WHILE_EXPRESSION:
				sequence_XDoWhileExpression(context, (XDoWhileExpression) semanticObject); 
				return; 
			case XbasePackage.XFEATURE_CALL:
				sequence_XFeatureCall(context, (XFeatureCall) semanticObject); 
				return; 
			case XbasePackage.XFOR_LOOP_EXPRESSION:
				sequence_XForLoopExpression(context, (XForLoopExpression) semanticObject); 
				return; 
			case XbasePackage.XIF_EXPRESSION:
				sequence_XIfExpression(context, (XIfExpression) semanticObject); 
				return; 
			case XbasePackage.XINSTANCE_OF_EXPRESSION:
				sequence_XRelationalExpression(context, (XInstanceOfExpression) semanticObject); 
				return; 
			case XbasePackage.XLIST_LITERAL:
				sequence_XListLiteral(context, (XListLiteral) semanticObject); 
				return; 
			case XbasePackage.XMEMBER_FEATURE_CALL:
				sequence_XMemberFeatureCall(context, (XMemberFeatureCall) semanticObject); 
				return; 
			case XbasePackage.XNULL_LITERAL:
				sequence_XNullLiteral(context, (XNullLiteral) semanticObject); 
				return; 
			case XbasePackage.XNUMBER_LITERAL:
				sequence_XNumberLiteral(context, (XNumberLiteral) semanticObject); 
				return; 
			case XbasePackage.XPOSTFIX_OPERATION:
				sequence_XPostfixOperation(context, (XPostfixOperation) semanticObject); 
				return; 
			case XbasePackage.XRETURN_EXPRESSION:
				sequence_XReturnExpression(context, (XReturnExpression) semanticObject); 
				return; 
			case XbasePackage.XSET_LITERAL:
				sequence_XSetLiteral(context, (XSetLiteral) semanticObject); 
				return; 
			case XbasePackage.XSTRING_LITERAL:
				sequence_XStringLiteral(context, (XStringLiteral) semanticObject); 
				return; 
			case XbasePackage.XSWITCH_EXPRESSION:
				sequence_XSwitchExpression(context, (XSwitchExpression) semanticObject); 
				return; 
			case XbasePackage.XSYNCHRONIZED_EXPRESSION:
				sequence_XSynchronizedExpression(context, (XSynchronizedExpression) semanticObject); 
				return; 
			case XbasePackage.XTHROW_EXPRESSION:
				sequence_XThrowExpression(context, (XThrowExpression) semanticObject); 
				return; 
			case XbasePackage.XTRY_CATCH_FINALLY_EXPRESSION:
				sequence_XTryCatchFinallyExpression(context, (XTryCatchFinallyExpression) semanticObject); 
				return; 
			case XbasePackage.XTYPE_LITERAL:
				sequence_XTypeLiteral(context, (XTypeLiteral) semanticObject); 
				return; 
			case XbasePackage.XUNARY_OPERATION:
				sequence_XUnaryOperation(context, (XUnaryOperation) semanticObject); 
				return; 
			case XbasePackage.XVARIABLE_DECLARATION:
				sequence_XVariableDeclaration(context, (XVariableDeclaration) semanticObject); 
				return; 
			case XbasePackage.XWHILE_EXPRESSION:
				sequence_XWhileExpression(context, (XWhileExpression) semanticObject); 
				return; 
			}
		else if (epackage == XtypePackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case XtypePackage.XFUNCTION_TYPE_REF:
				sequence_XFunctionTypeRef(context, (XFunctionTypeRef) semanticObject); 
				return; 
			case XtypePackage.XIMPORT_DECLARATION:
				sequence_XImportDeclaration(context, (XImportDeclaration) semanticObject); 
				return; 
			case XtypePackage.XIMPORT_SECTION:
				sequence_XImportSection(context, (XImportSection) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Contexts:
	 *     ValueReference returns AggregatedValue
	 *     AnnotationValueReference returns AggregatedValue
	 *     ComputationValue returns AggregatedValue
	 *     AggregatedValue returns AggregatedValue
	 *
	 * Constraint:
	 *     (aggregator=[JvmDeclaredType|ValidID] (call=PatternCall | call=EClassifierConstraint | call=PathExpressionConstraint))
	 */
	protected void sequence_AggregatedValue(ISerializationContext context, AggregatedValue semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AnnotationParameter returns AnnotationParameter
	 *
	 * Constraint:
	 *     (name=ID value=AnnotationValueReference)
	 */
	protected void sequence_AnnotationParameter(ISerializationContext context, AnnotationParameter semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, PatternLanguagePackage.Literals.ANNOTATION_PARAMETER__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PatternLanguagePackage.Literals.ANNOTATION_PARAMETER__NAME));
			if (transientValues.isValueTransient(semanticObject, PatternLanguagePackage.Literals.ANNOTATION_PARAMETER__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PatternLanguagePackage.Literals.ANNOTATION_PARAMETER__VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getAnnotationParameterAccess().getNameIDTerminalRuleCall_0_0(), semanticObject.getName());
		feeder.accept(grammarAccess.getAnnotationParameterAccess().getValueAnnotationValueReferenceParserRuleCall_2_0(), semanticObject.getValue());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Annotation returns Annotation
	 *
	 * Constraint:
	 *     (name=ID (parameters+=AnnotationParameter parameters+=AnnotationParameter*)?)
	 */
	protected void sequence_Annotation(ISerializationContext context, Annotation semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ValueReference returns BoolValue
	 *     AnnotationValueReference returns BoolValue
	 *     LiteralValueReference returns BoolValue
	 *     BoolValue returns BoolValue
	 *
	 * Constraint:
	 *     value=XBooleanLiteral
	 */
	protected void sequence_BoolValue(ISerializationContext context, BoolValue semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, PatternLanguagePackage.Literals.BOOL_VALUE__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PatternLanguagePackage.Literals.BOOL_VALUE__VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getBoolValueAccess().getValueXBooleanLiteralParserRuleCall_0(), semanticObject.getValue());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Constraint returns CheckConstraint
	 *     CheckConstraint returns CheckConstraint
	 *
	 * Constraint:
	 *     expression=XExpression
	 */
	protected void sequence_CheckConstraint(ISerializationContext context, CheckConstraint semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, PatternLanguagePackage.Literals.CHECK_CONSTRAINT__EXPRESSION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PatternLanguagePackage.Literals.CHECK_CONSTRAINT__EXPRESSION));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getCheckConstraintAccess().getExpressionXExpressionParserRuleCall_2_0(), semanticObject.getExpression());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Constraint returns CompareConstraint
	 *     CompareConstraint returns CompareConstraint
	 *
	 * Constraint:
	 *     (leftOperand=ValueReference feature=CompareFeature rightOperand=ValueReference)
	 */
	protected void sequence_CompareConstraint(ISerializationContext context, CompareConstraint semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, PatternLanguagePackage.Literals.COMPARE_CONSTRAINT__LEFT_OPERAND) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PatternLanguagePackage.Literals.COMPARE_CONSTRAINT__LEFT_OPERAND));
			if (transientValues.isValueTransient(semanticObject, PatternLanguagePackage.Literals.COMPARE_CONSTRAINT__FEATURE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PatternLanguagePackage.Literals.COMPARE_CONSTRAINT__FEATURE));
			if (transientValues.isValueTransient(semanticObject, PatternLanguagePackage.Literals.COMPARE_CONSTRAINT__RIGHT_OPERAND) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PatternLanguagePackage.Literals.COMPARE_CONSTRAINT__RIGHT_OPERAND));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getCompareConstraintAccess().getLeftOperandValueReferenceParserRuleCall_0_0(), semanticObject.getLeftOperand());
		feeder.accept(grammarAccess.getCompareConstraintAccess().getFeatureCompareFeatureEnumRuleCall_1_0(), semanticObject.getFeature());
		feeder.accept(grammarAccess.getCompareConstraintAccess().getRightOperandValueReferenceParserRuleCall_2_0(), semanticObject.getRightOperand());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Constraint returns EClassifierConstraint
	 *     EClassifierConstraint returns EClassifierConstraint
	 *
	 * Constraint:
	 *     (type=Type var=VariableReference)
	 */
	protected void sequence_EClassifierConstraint(ISerializationContext context, EClassifierConstraint semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, PatternLanguagePackage.Literals.UNARY_TYPE_CONSTRAINT__TYPE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PatternLanguagePackage.Literals.UNARY_TYPE_CONSTRAINT__TYPE));
			if (transientValues.isValueTransient(semanticObject, PatternLanguagePackage.Literals.UNARY_TYPE_CONSTRAINT__VAR) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PatternLanguagePackage.Literals.UNARY_TYPE_CONSTRAINT__VAR));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getEClassifierConstraintAccess().getTypeTypeParserRuleCall_0_0(), semanticObject.getType());
		feeder.accept(grammarAccess.getEClassifierConstraintAccess().getVarVariableReferenceParserRuleCall_2_0(), semanticObject.getVar());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     ValueReference returns EnumValue
	 *     AnnotationValueReference returns EnumValue
	 *     LiteralValueReference returns EnumValue
	 *     EnumValue returns EnumValue
	 *
	 * Constraint:
	 *     (enumeration=[EEnum|ID]? literal=[EEnumLiteral|ID])
	 */
	protected void sequence_EnumValue(ISerializationContext context, EnumValue semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ValueReference returns FunctionEvaluationValue
	 *     AnnotationValueReference returns FunctionEvaluationValue
	 *     ComputationValue returns FunctionEvaluationValue
	 *     FunctionEvaluationValue returns FunctionEvaluationValue
	 *
	 * Constraint:
	 *     expression=XExpression
	 */
	protected void sequence_FunctionEvaluationValue(ISerializationContext context, FunctionEvaluationValue semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, PatternLanguagePackage.Literals.FUNCTION_EVALUATION_VALUE__EXPRESSION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PatternLanguagePackage.Literals.FUNCTION_EVALUATION_VALUE__EXPRESSION));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getFunctionEvaluationValueAccess().getExpressionXExpressionParserRuleCall_2_0(), semanticObject.getExpression());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     JavaType returns JavaType
	 *
	 * Constraint:
	 *     classRef=[JvmDeclaredType|QualifiedName]
	 */
	protected void sequence_JavaType(ISerializationContext context, JavaType semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, PatternLanguagePackage.Literals.JAVA_TYPE__CLASS_REF) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PatternLanguagePackage.Literals.JAVA_TYPE__CLASS_REF));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getJavaTypeAccess().getClassRefJvmDeclaredTypeQualifiedNameParserRuleCall_2_0_1(), semanticObject.eGet(PatternLanguagePackage.Literals.JAVA_TYPE__CLASS_REF, false));
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     AnnotationValueReference returns ListValue
	 *     ListValue returns ListValue
	 *
	 * Constraint:
	 *     (values+=ValueReference values+=ValueReference*)
	 */
	protected void sequence_ListValue(ISerializationContext context, ListValue semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Modifiers returns Modifiers
	 *
	 * Constraint:
	 *     (private?='private' | execution=ExecutionTypeModifier)*
	 */
	protected void sequence_Modifiers(ISerializationContext context, Modifiers semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ValueReference returns NumberValue
	 *     AnnotationValueReference returns NumberValue
	 *     LiteralValueReference returns NumberValue
	 *     NumberValue returns NumberValue
	 *
	 * Constraint:
	 *     (negative?='-'? value=XNumberLiteral)
	 */
	protected void sequence_NumberValue(ISerializationContext context, NumberValue semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     PackageImport returns PackageImport
	 *
	 * Constraint:
	 *     (ePackage=[EPackage|STRING] alias=ID?)
	 */
	protected void sequence_PackageImport(ISerializationContext context, PackageImport semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Parameter returns Parameter
	 *
	 * Constraint:
	 *     (direction=ParameterDirectionModifier? name=ID (type=Type | type=JavaType)?)
	 */
	protected void sequence_Parameter(ISerializationContext context, org.eclipse.viatra.query.patternlanguage.emf.vql.Parameter semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Constraint returns PathExpressionConstraint
	 *     PathExpressionConstraint returns PathExpressionConstraint
	 *
	 * Constraint:
	 *     (sourceType=Type edgeTypes+=RefType* transitive=ClosureType? src=VariableReference dst=ValueReference)
	 */
	protected void sequence_PathExpressionConstraint(ISerializationContext context, PathExpressionConstraint semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     PatternBody returns PatternBody
	 *
	 * Constraint:
	 *     (name=ID? constraints+=Constraint*)
	 */
	protected void sequence_PatternBody(ISerializationContext context, PatternBody semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     PatternCall returns PatternCall
	 *
	 * Constraint:
	 *     (patternRef=[Pattern|QualifiedName] transitive=ClosureType? (parameters+=ValueReference parameters+=ValueReference*)?)
	 */
	protected void sequence_PatternCall(ISerializationContext context, PatternCall semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Constraint returns PatternCompositionConstraint
	 *     PatternCompositionConstraint returns PatternCompositionConstraint
	 *
	 * Constraint:
	 *     ((negative?='neg'? call=PatternCall) | (negative?='neg' (call=EClassifierConstraint | call=PathExpressionConstraint)))
	 */
	protected void sequence_PatternCompositionConstraint(ISerializationContext context, PatternCompositionConstraint semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     PatternImport returns PatternImport
	 *
	 * Constraint:
	 *     pattern=[Pattern|QualifiedName]
	 */
	protected void sequence_PatternImport(ISerializationContext context, PatternImport semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, PatternLanguagePackage.Literals.PATTERN_IMPORT__PATTERN) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PatternLanguagePackage.Literals.PATTERN_IMPORT__PATTERN));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getPatternImportAccess().getPatternPatternQualifiedNameParserRuleCall_2_0_1(), semanticObject.eGet(PatternLanguagePackage.Literals.PATTERN_IMPORT__PATTERN, false));
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     PatternModel returns PatternModel
	 *
	 * Constraint:
	 *     (packageName=QualifiedName? importPackages=VQLImportSection patterns+=Pattern*)
	 */
	protected void sequence_PatternModel(ISerializationContext context, PatternModel semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Pattern returns Pattern
	 *
	 * Constraint:
	 *     (
	 *         annotations+=Annotation* 
	 *         modifiers=Modifiers 
	 *         name=ID 
	 *         (parameters+=Parameter parameters+=Parameter*)? 
	 *         bodies+=PatternBody 
	 *         bodies+=PatternBody*
	 *     )
	 */
	protected void sequence_Pattern(ISerializationContext context, Pattern semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     RefType returns ReferenceType
	 *
	 * Constraint:
	 *     refname=[EStructuralFeature|ID]
	 */
	protected void sequence_RefType(ISerializationContext context, ReferenceType semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, PatternLanguagePackage.Literals.REFERENCE_TYPE__REFNAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PatternLanguagePackage.Literals.REFERENCE_TYPE__REFNAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getRefTypeAccess().getRefnameEStructuralFeatureIDTerminalRuleCall_1_0_1(), semanticObject.eGet(PatternLanguagePackage.Literals.REFERENCE_TYPE__REFNAME, false));
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     ValueReference returns StringValue
	 *     AnnotationValueReference returns StringValue
	 *     LiteralValueReference returns StringValue
	 *     StringValue returns StringValue
	 *
	 * Constraint:
	 *     value=STRING
	 */
	protected void sequence_StringValue(ISerializationContext context, StringValue semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, PatternLanguagePackage.Literals.STRING_VALUE__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PatternLanguagePackage.Literals.STRING_VALUE__VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getStringValueAccess().getValueSTRINGTerminalRuleCall_1_0(), semanticObject.getValue());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Constraint returns TypeCheckConstraint
	 *     TypeCheckConstraint returns TypeCheckConstraint
	 *
	 * Constraint:
	 *     (type=JavaType var=VariableReference)
	 */
	protected void sequence_TypeCheckConstraint(ISerializationContext context, TypeCheckConstraint semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, PatternLanguagePackage.Literals.UNARY_TYPE_CONSTRAINT__TYPE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PatternLanguagePackage.Literals.UNARY_TYPE_CONSTRAINT__TYPE));
			if (transientValues.isValueTransient(semanticObject, PatternLanguagePackage.Literals.UNARY_TYPE_CONSTRAINT__VAR) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, PatternLanguagePackage.Literals.UNARY_TYPE_CONSTRAINT__VAR));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getTypeCheckConstraintAccess().getTypeJavaTypeParserRuleCall_0_0(), semanticObject.getType());
		feeder.accept(grammarAccess.getTypeCheckConstraintAccess().getVarVariableReferenceParserRuleCall_2_0(), semanticObject.getVar());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Type returns ClassType
	 *
	 * Constraint:
	 *     (metamodel=[PackageImport|ID]? classname=[EClassifier|ID])
	 */
	protected void sequence_Type(ISerializationContext context, ClassType semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     VQLImportSection returns VQLImportSection
	 *
	 * Constraint:
	 *     (packageImport+=PackageImport | patternImport+=PatternImport | importDeclarations+=XImportDeclaration)*
	 */
	protected void sequence_VQLImportSection(ISerializationContext context, VQLImportSection semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     VariableReference returns VariableReference
	 *     ValueReference returns VariableReference
	 *     AnnotationValueReference returns VariableReference
	 *
	 * Constraint:
	 *     ((aggregator?='#'? var=ID) | aggregator?='#')
	 */
	protected void sequence_VariableReference(ISerializationContext context, VariableReference semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     XBooleanLiteral returns XBooleanLiteral
	 *     XExpression returns XBooleanLiteral
	 *     XAssignment returns XBooleanLiteral
	 *     XAssignment.XBinaryOperation_1_1_0_0_0 returns XBooleanLiteral
	 *     XOrExpression returns XBooleanLiteral
	 *     XOrExpression.XBinaryOperation_1_0_0_0 returns XBooleanLiteral
	 *     XAndExpression returns XBooleanLiteral
	 *     XAndExpression.XBinaryOperation_1_0_0_0 returns XBooleanLiteral
	 *     XEqualityExpression returns XBooleanLiteral
	 *     XEqualityExpression.XBinaryOperation_1_0_0_0 returns XBooleanLiteral
	 *     XRelationalExpression returns XBooleanLiteral
	 *     XRelationalExpression.XInstanceOfExpression_1_0_0_0_0 returns XBooleanLiteral
	 *     XRelationalExpression.XBinaryOperation_1_1_0_0_0 returns XBooleanLiteral
	 *     XOtherOperatorExpression returns XBooleanLiteral
	 *     XOtherOperatorExpression.XBinaryOperation_1_0_0_0 returns XBooleanLiteral
	 *     XAdditiveExpression returns XBooleanLiteral
	 *     XAdditiveExpression.XBinaryOperation_1_0_0_0 returns XBooleanLiteral
	 *     XMultiplicativeExpression returns XBooleanLiteral
	 *     XMultiplicativeExpression.XBinaryOperation_1_0_0_0 returns XBooleanLiteral
	 *     XUnaryOperation returns XBooleanLiteral
	 *     XCastedExpression returns XBooleanLiteral
	 *     XCastedExpression.XCastedExpression_1_0_0_0 returns XBooleanLiteral
	 *     XPostfixOperation returns XBooleanLiteral
	 *     XPostfixOperation.XPostfixOperation_1_0_0 returns XBooleanLiteral
	 *     XMemberFeatureCall returns XBooleanLiteral
	 *     XMemberFeatureCall.XAssignment_1_0_0_0_0 returns XBooleanLiteral
	 *     XMemberFeatureCall.XMemberFeatureCall_1_1_0_0_0 returns XBooleanLiteral
	 *     XPrimaryExpression returns XBooleanLiteral
	 *     XLiteral returns XBooleanLiteral
	 *     XParenthesizedExpression returns XBooleanLiteral
	 *     XExpressionOrVarDeclaration returns XBooleanLiteral
	 *
	 * Constraint:
	 *     (isTrue?='true' | isTrue?='TRUE')?
	 */
	protected void sequence_XBooleanLiteral(ISerializationContext context, XBooleanLiteral semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     XImportDeclaration returns XImportDeclaration
	 *
	 * Constraint:
	 *     (
	 *         (static?='static' extension?='extension'? importedType=[JvmDeclaredType|QualifiedName]) | 
	 *         importedType=[JvmDeclaredType|QualifiedName] | 
	 *         importedNamespace=QualifiedNameWithWildcard
	 *     )
	 */
	protected void sequence_XImportDeclaration(ISerializationContext context, XImportDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     XNumberLiteral returns XNumberLiteral
	 *     XExpression returns XNumberLiteral
	 *     XAssignment returns XNumberLiteral
	 *     XAssignment.XBinaryOperation_1_1_0_0_0 returns XNumberLiteral
	 *     XOrExpression returns XNumberLiteral
	 *     XOrExpression.XBinaryOperation_1_0_0_0 returns XNumberLiteral
	 *     XAndExpression returns XNumberLiteral
	 *     XAndExpression.XBinaryOperation_1_0_0_0 returns XNumberLiteral
	 *     XEqualityExpression returns XNumberLiteral
	 *     XEqualityExpression.XBinaryOperation_1_0_0_0 returns XNumberLiteral
	 *     XRelationalExpression returns XNumberLiteral
	 *     XRelationalExpression.XInstanceOfExpression_1_0_0_0_0 returns XNumberLiteral
	 *     XRelationalExpression.XBinaryOperation_1_1_0_0_0 returns XNumberLiteral
	 *     XOtherOperatorExpression returns XNumberLiteral
	 *     XOtherOperatorExpression.XBinaryOperation_1_0_0_0 returns XNumberLiteral
	 *     XAdditiveExpression returns XNumberLiteral
	 *     XAdditiveExpression.XBinaryOperation_1_0_0_0 returns XNumberLiteral
	 *     XMultiplicativeExpression returns XNumberLiteral
	 *     XMultiplicativeExpression.XBinaryOperation_1_0_0_0 returns XNumberLiteral
	 *     XUnaryOperation returns XNumberLiteral
	 *     XCastedExpression returns XNumberLiteral
	 *     XCastedExpression.XCastedExpression_1_0_0_0 returns XNumberLiteral
	 *     XPostfixOperation returns XNumberLiteral
	 *     XPostfixOperation.XPostfixOperation_1_0_0 returns XNumberLiteral
	 *     XMemberFeatureCall returns XNumberLiteral
	 *     XMemberFeatureCall.XAssignment_1_0_0_0_0 returns XNumberLiteral
	 *     XMemberFeatureCall.XMemberFeatureCall_1_1_0_0_0 returns XNumberLiteral
	 *     XPrimaryExpression returns XNumberLiteral
	 *     XLiteral returns XNumberLiteral
	 *     XParenthesizedExpression returns XNumberLiteral
	 *     XExpressionOrVarDeclaration returns XNumberLiteral
	 *
	 * Constraint:
	 *     value=Number
	 */
	protected void sequence_XNumberLiteral(ISerializationContext context, XNumberLiteral semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, XbasePackage.Literals.XNUMBER_LITERAL__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XbasePackage.Literals.XNUMBER_LITERAL__VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getXNumberLiteralAccess().getValueNumberParserRuleCall_1_0(), semanticObject.getValue());
		feeder.finish();
	}
	
	
}
