/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.tmf.ui.views.FormatTimeUtils;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class Utils {
    public static final String ELLIPSIS = "\u2026";

    private Utils() {
    }

    static Rectangle clone(Rectangle source) {
        return new Rectangle(source.x, source.y, source.width, source.height);
    }

    public static void init(Rectangle rect) {
        rect.x = 0;
        rect.y = 0;
        rect.width = 0;
        rect.height = 0;
    }

    public static void init(Rectangle rect, int x, int y, int width, int height) {
        rect.x = x;
        rect.y = y;
        rect.width = width;
        rect.height = height;
    }

    public static void init(Rectangle rect, Rectangle source) {
        rect.x = source.x;
        rect.y = source.y;
        rect.width = source.width;
        rect.height = source.height;
    }

    public static void deflate(Rectangle rect, int x, int y) {
        rect.x += x;
        rect.y += y;
        rect.width -= x + x;
        rect.height -= y + y;
    }

    public static void inflate(Rectangle rect, int x, int y) {
        rect.x -= x;
        rect.y -= y;
        rect.width += x + x;
        rect.height += y + y;
    }

    static void dispose(Color col) {
        if (col != null) {
            col.dispose();
        }
    }

    public static Color mixColors(Device display, Color c1, Color c2, int w1, int w2) {
        return new Color(display, (w1 * c1.getRed() + w2 * c2.getRed()) / (w1 + w2), (w1 * c1.getGreen() + w2 * c2.getGreen()) / (w1 + w2), (w1 * c1.getBlue() + w2 * c2.getBlue()) / (w1 + w2));
    }

    public static Color getSysColor(int id) {
        Color col = Display.getCurrent().getSystemColor(id);
        return new Color(col.getDevice(), col.getRGB());
    }

    public static Color mixColors(Color col1, Color col2, int w1, int w2) {
        return Utils.mixColors((Device)Display.getCurrent(), col1, col2, w1, w2);
    }

    public static Color getDistinctColor(RGB rgb) {
        int luminanceThreshold = 160;
        double redCoefficient = 0.2126;
        double greenCoefficient = 0.7152;
        double blueCoefficient = 0.0722;
        int luminance = (int)(0.2126 * (double)rgb.red + 0.7152 * (double)rgb.green + 0.0722 * (double)rgb.blue);
        return Display.getDefault().getSystemColor(luminance > 160 ? 2 : 1);
    }

    public static int drawText(GC gc, String text, Rectangle rect, boolean transp) {
        Point size = gc.stringExtent(text);
        gc.drawText(text, rect.x, rect.y, transp);
        return size.x;
    }

    public static int drawText(GC gc, String text, int x, int y, boolean transp) {
        Point size = gc.stringExtent(text);
        gc.drawText(text, x, y, transp);
        return size.x;
    }

    public static int drawText(GC gc, String text, int x, int y, int width, int height, boolean isCentered, boolean isTransparent) {
        String stringToDisplay;
        int len;
        if (width < 1 || text.isEmpty()) {
            return 0;
        }
        boolean isCenteredWidth = isCentered;
        int realX = x;
        int realY = y;
        Point textExtent = gc.textExtent(text);
        if (textExtent.x <= width) {
            len = text.length();
            stringToDisplay = text;
        } else {
            isCenteredWidth = false;
            int prevLen = 0;
            len = 1;
            while (len <= text.length()) {
                textExtent = gc.textExtent(String.valueOf(text.substring(0, len)) + ELLIPSIS);
                if (textExtent.x > width) {
                    len = prevLen;
                    break;
                }
                prevLen = len++;
            }
            stringToDisplay = String.valueOf(text.substring(0, len)) + ELLIPSIS;
        }
        if (len <= 0) {
            return 0;
        }
        if (isCenteredWidth) {
            realX += (width - textExtent.x) / 2;
        }
        if (isCentered) {
            realY += (height - textExtent.y) / 2 - 1;
        }
        gc.drawText(stringToDisplay, realX, realY, isTransparent);
        return len;
    }

    public static int loadIntOption(String opt, int def, int min, int max) {
        return def;
    }

    public static void saveIntOption(String opt, int val) {
    }

    static ITimeEvent getFirstEvent(ITimeGraphEntry entry) {
        if (entry == null || !entry.hasTimeEvents()) {
            return null;
        }
        Iterator<? extends ITimeEvent> iterator = entry.getTimeEventsIterator();
        if (iterator != null && iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static ITimeEvent findEvent(ITimeGraphEntry entry, long time, int n) {
        if (entry == null || !entry.hasTimeEvents()) {
            return null;
        }
        Iterator<@NonNull ? extends ITimeEvent> iterator = entry.getTimeEventsIterator();
        if (iterator == null) {
            return null;
        }
        ITimeEvent nextEvent = null;
        ITimeEvent currEvent = null;
        ITimeEvent prevEvent = null;
        while (iterator.hasNext()) {
            nextEvent = iterator.next();
            long nextStartTime = nextEvent.getTime();
            if (nextStartTime > time) break;
            if (currEvent != null && currEvent.getTime() == nextStartTime && (nextStartTime == time || currEvent.getDuration() == nextEvent.getDuration())) continue;
            prevEvent = currEvent;
            currEvent = nextEvent;
        }
        if (n == -1) {
            if (currEvent != null && currEvent.getTime() + currEvent.getDuration() >= time) {
                return prevEvent;
            }
            return currEvent;
        }
        if (n == 0) {
            if (currEvent != null && currEvent.getTime() + currEvent.getDuration() >= time) {
                return currEvent;
            }
            return null;
        }
        if (n == 1) {
            if (nextEvent != null && nextEvent.getTime() > time) {
                return nextEvent;
            }
            return null;
        }
        if (n == 2) {
            return currEvent;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static long nextChange(ITimeGraphEntry entry, long time) {
        if (entry == null || !entry.hasTimeEvents()) {
            return 0x7FFFFFFFFFFFFFFFL;
        }
        iterator = entry.getTimeEventsIterator();
        if (iterator != null) ** GOTO lbl13
        return 0x7FFFFFFFFFFFFFFFL;
lbl-1000:
        // 1 sources

        {
            event = iterator.next();
            start = event.getTime();
            if (start > time) {
                return start;
            }
            end = start + event.getDuration();
            if (end <= time) continue;
            return end;
lbl13:
            // 2 sources

            ** while (iterator.hasNext())
        }
lbl14:
        // 1 sources

        return 0x7FFFFFFFFFFFFFFFL;
    }

    public static long prevChange(ITimeGraphEntry entry, long time) {
        if (entry == null || !entry.hasTimeEvents()) {
            return Long.MIN_VALUE;
        }
        Iterator<@NonNull ? extends ITimeEvent> iterator = entry.getTimeEventsIterator();
        if (iterator == null) {
            return Long.MIN_VALUE;
        }
        long prevEnd = Long.MIN_VALUE;
        while (iterator.hasNext()) {
            ITimeEvent event = iterator.next();
            long start = event.getTime();
            if (start >= time) {
                return prevEnd;
            }
            long end = start + event.getDuration();
            if (end >= time) {
                return start;
            }
            prevEnd = end;
        }
        return prevEnd;
    }

    public static String fixMethodSignature(String origSig) {
        String sig = origSig;
        int pos = sig.indexOf(40);
        if (pos >= 0) {
            String ret = sig.substring(0, pos);
            sig = sig.substring(pos);
            sig = String.valueOf(sig) + " " + ret;
        }
        return sig;
    }

    public static String restoreMethodSignature(String ppSig) {
        String ret = "";
        String sig = ppSig;
        int pos = sig.indexOf(40);
        if (pos >= 0) {
            ret = sig.substring(0, pos);
            sig = sig.substring(pos + 1);
        }
        if ((pos = sig.indexOf(41)) >= 0) {
            sig = sig.substring(0, pos);
        }
        String[] args = sig.split(",");
        StringBuffer result = new StringBuffer("(");
        int i = 0;
        while (i < args.length) {
            String arg = args[i].trim();
            if (arg.length() == 0 && args.length == 1) break;
            result.append(Utils.getTypeSignature(arg));
            ++i;
        }
        result.append(")").append(Utils.getTypeSignature(ret));
        return result.toString();
    }

    public static String getTypeSignature(String typeStr) {
        int dim = 0;
        String type = typeStr;
        int j = 0;
        while (j < type.length()) {
            if (type.charAt(j) == '[') {
                ++dim;
            }
            ++j;
        }
        int pos = type.indexOf(91);
        if (pos >= 0) {
            type = type.substring(0, pos);
        }
        StringBuffer sig = new StringBuffer("");
        int j2 = 0;
        while (j2 < dim) {
            sig.append("[");
            ++j2;
        }
        if (type.equals("boolean")) {
            sig.append('Z');
        } else if (type.equals("byte")) {
            sig.append('B');
        } else if (type.equals("char")) {
            sig.append('C');
        } else if (type.equals("short")) {
            sig.append('S');
        } else if (type.equals("int")) {
            sig.append('I');
        } else if (type.equals("long")) {
            sig.append('J');
        } else if (type.equals("float")) {
            sig.append('F');
        } else if (type.equals("double")) {
            sig.append('D');
        } else if (type.equals("void")) {
            sig.append('V');
        } else {
            sig.append('L').append(type.replace('.', '/')).append(';');
        }
        return sig.toString();
    }

    public static int compare(double d1, double d2) {
        if (d1 > d2) {
            return 1;
        }
        if (d1 < d2) {
            return 1;
        }
        return 0;
    }

    public static int compare(String s1, String s2) {
        if (s1 != null && s2 != null) {
            return s1.compareToIgnoreCase(s2);
        }
        if (s1 != null) {
            return 1;
        }
        if (s2 != null) {
            return -1;
        }
        return 0;
    }

    public static double distance2(int x1, int y1, int x2, int y2) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        int d2 = dx * dx + dy * dy;
        return d2;
    }

    public static double distance(int px, int py, int x1, int y1, int x2, int y2) {
        double length2 = Utils.distance2(x1, y1, x2, y2);
        if (length2 == 0.0) {
            return Math.sqrt(Utils.distance2(px, py, x1, y1));
        }
        double r = (double)((px - x1) * (x2 - x1) + (py - y1) * (y2 - y1)) / length2;
        if (r <= 0.0) {
            return Math.sqrt(Utils.distance2(px, py, x1, y1));
        }
        if (r >= 1.0) {
            return Math.sqrt(Utils.distance2(px, py, x2, y2));
        }
        int x = (int)((double)x1 + r * (double)(x2 - x1));
        int y = (int)((double)y1 + r * (double)(y2 - y1));
        return Math.sqrt(Utils.distance2(px, py, x, y));
    }

    public static @NonNull Iterable<@NonNull TimeGraphEntry> flatten(TimeGraphEntry root) {
        Iterable transform = Iterables.transform(root.getChildren(), Utils::flatten);
        return Iterables.concat(Collections.singleton(root), (Iterable)Iterables.concat((Iterable)transform));
    }

    public static enum Resolution {
        SECONDS(FormatTimeUtils.Resolution.SECONDS),
        MILLISEC(FormatTimeUtils.Resolution.MILLISEC),
        MICROSEC(FormatTimeUtils.Resolution.MICROSEC),
        NANOSEC(FormatTimeUtils.Resolution.NANOSEC);

        private final FormatTimeUtils.Resolution res;

        private Resolution(FormatTimeUtils.Resolution res) {
            this.res = res;
        }

        public FormatTimeUtils.Resolution convert() {
            return this.res;
        }
    }

    public static enum TimeFormat {
        RELATIVE(FormatTimeUtils.TimeFormat.RELATIVE),
        CALENDAR(FormatTimeUtils.TimeFormat.CALENDAR),
        NUMBER(FormatTimeUtils.TimeFormat.NUMBER),
        CYCLES(FormatTimeUtils.TimeFormat.CYCLES),
        PERCENTAGE(FormatTimeUtils.TimeFormat.PERCENTAGE);

        private final FormatTimeUtils.TimeFormat tf;

        private TimeFormat(FormatTimeUtils.TimeFormat tf) {
            this.tf = tf;
        }

        public FormatTimeUtils.TimeFormat convert() {
            return this.tf;
        }
    }
}

