/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.symbols;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProviderPreferencePage;
import org.eclipse.tracecompass.tmf.ui.symbols.Messages;
import org.eclipse.tracecompass.tmf.ui.symbols.TmfSymbolProviderUpdatedSignal;
import org.eclipse.ui.PlatformUI;

@Deprecated
public class SymbolProviderConfigDialog
extends TitleAreaDialog
implements IPreferencePageContainer {
    private ISymbolProviderPreferencePage[] fPreferencePages;
    private CTabItem[] fPageTabs;
    private CTabFolder fTabFolder;
    private IRunnableWithProgress configJob = monitor -> {
        this.getContents().getDisplay().syncExec(() -> {
            int i = 0;
            while (i < this.fPreferencePages.length) {
                ISymbolProviderPreferencePage page = this.fPreferencePages[i];
                page.saveConfiguration();
                ++i;
            }
        });
        monitor.beginTask(Messages.SymbolProviderConfigDialog_loadingConfigurations, this.fPreferencePages.length * 100);
        try {
            int i = 0;
            while (i < this.fPreferencePages.length) {
                ISymbolProviderPreferencePage page = this.fPreferencePages[i];
                page.getSymbolProvider().loadConfiguration(monitor);
                monitor.worked(100);
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    };

    public SymbolProviderConfigDialog(Shell parentShell, ISymbolProviderPreferencePage ... pages) {
        super(parentShell);
        this.fPreferencePages = pages;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.SymbolProviderConfigDialog_title);
        this.setTitle(Messages.SymbolProviderConfigDialog_title);
        this.setMessage(Messages.SymbolProviderConfigDialog_message);
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        if (this.fPreferencePages.length == 1) {
            this.attachPreference(composite, this.fPreferencePages[0]);
            this.updateMessage(0);
        } else {
            this.fTabFolder = new CTabFolder(composite, 0);
            this.fTabFolder.setLayoutData((Object)new GridData(1808));
            this.fPageTabs = new CTabItem[this.fPreferencePages.length];
            int i = 0;
            while (i < this.fPreferencePages.length) {
                ISymbolProviderPreferencePage page = this.fPreferencePages[i];
                this.fPageTabs[i] = new CTabItem(this.fTabFolder, 0);
                this.fPageTabs[i].setText(page.getTitle());
                Composite child = new Composite((Composite)this.fTabFolder, 0);
                child.setLayout((Layout)new GridLayout());
                child.setLayoutData((Object)new GridData(16384, 128, true, true));
                this.fPageTabs[i].setControl((Control)child);
                this.attachPreference(child, page);
                this.updateMessage(i);
                ++i;
            }
            this.fTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SymbolProviderConfigDialog.this.updateMessage(SymbolProviderConfigDialog.this.fTabFolder.indexOf((CTabItem)e.item));
                }
            });
        }
        return composite;
    }

    protected boolean isResizable() {
        return true;
    }

    public boolean isHelpAvailable() {
        return false;
    }

    private void attachPreference(Composite composite, ISymbolProviderPreferencePage page) {
        page.setContainer(this);
        page.createControl(composite);
        page.getControl().setLayoutData((Object)new GridData(1808));
    }

    public IPreferenceStore getPreferenceStore() {
        return null;
    }

    public void updateTitle() {
    }

    public void updateButtons() {
    }

    protected void okPressed() {
        boolean cancel = false;
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, false, this.configJob);
        }
        catch (InvocationTargetException e) {
            this.setMessage(e.getMessage(), 3);
            cancel = true;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!cancel) {
            super.okPressed();
        }
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfSymbolProviderUpdatedSignal((Object)this));
    }

    public void updateMessage() {
        if (this.fTabFolder == null) {
            this.updateMessage(0);
            return;
        }
        int curSelectionIndex = this.fTabFolder.getSelectionIndex();
        if (curSelectionIndex >= 0) {
            this.updateMessage(curSelectionIndex);
        }
    }

    private void updateMessage(int pageIndex) {
        ISymbolProviderPreferencePage currentPage = this.fPreferencePages[pageIndex];
        String message = currentPage.getMessage();
        String errorMessage = currentPage.getErrorMessage();
        int messageType = 0;
        if (errorMessage != null) {
            message = errorMessage;
            messageType = 3;
        }
        this.setMessage(message, messageType);
        if (this.fPreferencePages.length > 1) {
            if (messageType == 3) {
                this.fPageTabs[pageIndex].setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
            } else {
                this.fPageTabs[pageIndex].setImage(null);
            }
        }
    }
}

