/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.util;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public final class SymbolHelper {
    private SymbolHelper() {
    }

    public static void drawSquare(GC gc, Color color, int symbolSize, int centerX, int centerY) {
        Color oldColor = gc.getBackground();
        gc.setBackground(color);
        int[] pts = new int[]{centerX - symbolSize, centerY - symbolSize, centerX + symbolSize, centerY - symbolSize, centerX + symbolSize, centerY + symbolSize, centerX - symbolSize, centerY + symbolSize};
        gc.fillPolygon(pts);
        gc.setBackground(oldColor);
    }

    public static void drawTriangle(GC gc, Color color, int symbolSize, int centerX, int centerY) {
        Color oldColor = gc.getBackground();
        gc.setBackground(color);
        int[] pts = new int[]{centerX - symbolSize, centerY + symbolSize / 3, centerX, centerY - symbolSize, centerX + symbolSize, centerY + symbolSize / 3};
        gc.fillPolygon(pts);
        gc.setBackground(oldColor);
    }

    public static void drawInvertedTriangle(GC gc, Color color, int symbolSize, int centerX, int centerY) {
        Color oldColor = gc.getBackground();
        gc.setBackground(color);
        int[] pts = new int[]{centerX - symbolSize, centerY - symbolSize / 3, centerX, centerY + symbolSize, centerX + symbolSize, centerY - symbolSize / 3};
        gc.fillPolygon(pts);
        gc.setBackground(oldColor);
    }

    public static void drawPlus(GC gc, Color color, int symbolSize, int centerX, int centerY) {
        int prevLs = gc.getLineStyle();
        int prevLw = gc.getLineWidth();
        Color oldColor = gc.getForeground();
        gc.setForeground(color);
        gc.drawLine(centerX - symbolSize, centerY, centerX + symbolSize, centerY);
        gc.drawLine(centerX, centerY - symbolSize, centerX, centerY + symbolSize);
        gc.setLineStyle(prevLs);
        gc.setLineWidth(prevLw);
        gc.setBackground(oldColor);
    }

    public static void drawCross(GC gc, Color color, int symbolSize, int centerX, int centerY) {
        int prevLs = gc.getLineStyle();
        int prevLw = gc.getLineWidth();
        Color oldColor = gc.getForeground();
        gc.setForeground(color);
        gc.drawLine(centerX - symbolSize, centerY - symbolSize, centerX + symbolSize, centerY + symbolSize);
        gc.drawLine(centerX - symbolSize, centerY + symbolSize, centerX + symbolSize, centerY - symbolSize);
        gc.setLineStyle(prevLs);
        gc.setLineWidth(prevLw);
        gc.setForeground(oldColor);
    }

    public static void drawDiamond(GC gc, Color color, int symbolSize, int centerX, int centerY) {
        Color oldColor = gc.getBackground();
        gc.setBackground(color);
        int[] pts = new int[]{centerX - symbolSize, centerY, centerX, centerY - symbolSize, centerX + symbolSize, centerY, centerX, centerY + symbolSize};
        gc.fillPolygon(pts);
        gc.setBackground(oldColor);
    }

    public static void drawCircle(GC gc, Color color, int symbolSize, int centerX, int centerY) {
        Color oldColor = gc.getBackground();
        gc.setBackground(color);
        gc.fillOval(centerX - symbolSize, centerY - symbolSize, symbolSize * 2, symbolSize * 2);
        gc.setBackground(oldColor);
    }
}

