/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core.backend.historytree;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.IntegerRangeCondition;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;
import org.eclipse.tracecompass.internal.statesystem.core.Activator;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTConfig;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTInterval;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTNode;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HistoryTreeFactory;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.IHistoryTree;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.ParentNode;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;

public class HistoryTreeBackend
implements IStateHistoryBackend {
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(HistoryTreeBackend.class);
    private final @NonNull String fSsid;
    private final @NonNull IHistoryTree fSht;
    private volatile boolean fFinishedBuilding = false;

    protected boolean isFinishedBuilding() {
        return this.fFinishedBuilding;
    }

    protected void setFinishedBuilding(boolean isFinishedBuilding) {
        this.fFinishedBuilding = isFinishedBuilding;
    }

    public HistoryTreeBackend(@NonNull String ssid, File newStateFile, int providerVersion, long startTime, int blockSize, int maxChildren) throws IOException {
        this.fSsid = ssid;
        HTConfig conf = new HTConfig(newStateFile, blockSize, maxChildren, providerVersion, startTime);
        this.fSht = this.initializeSHT(conf);
    }

    public HistoryTreeBackend(@NonNull String ssid, File newStateFile, int providerVersion, long startTime) throws IOException {
        this(ssid, newStateFile, providerVersion, startTime, 65536, 50);
    }

    public HistoryTreeBackend(@NonNull String ssid, @NonNull File existingStateFile, int providerVersion) throws IOException {
        this.fSsid = ssid;
        this.fSht = this.initializeSHT(existingStateFile, providerVersion);
        this.fFinishedBuilding = true;
    }

    @VisibleForTesting
    protected @NonNull IHistoryTree initializeSHT(@NonNull HTConfig conf) throws IOException {
        TraceCompassLogUtils.traceObjectCreation((Logger)LOGGER, (Level)Level.FINER, (Object)this);
        return HistoryTreeFactory.createHistoryTree(conf);
    }

    @VisibleForTesting
    protected @NonNull IHistoryTree initializeSHT(@NonNull File existingStateFile, int providerVersion) throws IOException {
        return HistoryTreeFactory.createFromFile(existingStateFile.toPath(), providerVersion);
    }

    protected final @NonNull IHistoryTree getSHT() {
        return this.fSht;
    }

    @Override
    public String getSSID() {
        return this.fSsid;
    }

    @Override
    public long getStartTime() {
        return this.getSHT().getTreeStart();
    }

    @Override
    public long getEndTime() {
        return this.getSHT().getTreeEnd();
    }

    @Override
    public void insertPastState(long stateStartTime, long stateEndTime, int quark, Object value) throws TimeRangeException {
        HTInterval interval = new HTInterval(stateStartTime, stateEndTime, quark, value);
        this.getSHT().insertInterval(interval);
    }

    @Override
    public void finishedBuilding(long endTime) {
        this.getSHT().closeTree(endTime);
        this.fFinishedBuilding = true;
    }

    @Override
    public FileInputStream supplyAttributeTreeReader() {
        return this.getSHT().supplyATReader();
    }

    @Override
    public File supplyAttributeTreeWriterFile() {
        return this.getSHT().supplyATWriterFile();
    }

    @Override
    public long supplyAttributeTreeWriterFilePosition() {
        return this.getSHT().supplyATWriterFilePos();
    }

    @Override
    public void removeFiles() {
        this.getSHT().deleteFile();
    }

    @Override
    public void dispose() {
        if (this.fFinishedBuilding) {
            TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.FINE, (String)"HistoryTreeBackend:ClosingFile", (Object[])new Object[]{"size", this.getSHT().getFileSize()});
            TraceCompassLogUtils.traceObjectDestruction((Logger)LOGGER, (Level)Level.FINER, (Object)this);
            this.getSHT().closeFile();
        } else {
            this.getSHT().deleteFile();
        }
    }

    @Override
    public void doQuery(List<ITmfStateInterval> stateInfo, long t) throws TimeRangeException, StateSystemDisposedException {
        this.checkValidTime(t);
        LinkedList<Integer> queue = new LinkedList<Integer>();
        queue.add(this.getSHT().getRootNode().getSequenceNumber());
        try {
            while (!queue.isEmpty()) {
                int sequenceNumber = (Integer)queue.pop();
                HTNode currentNode = this.getSHT().readNode(sequenceNumber);
                if (currentNode.getNodeType() == HTNode.NodeType.CORE) {
                    queue.addAll(((ParentNode)currentNode).selectNextChildren(t));
                }
                currentNode.writeInfoFromNode(stateInfo, t);
            }
        }
        catch (ClosedChannelException e) {
            throw new StateSystemDisposedException(e);
        }
    }

    @Override
    public ITmfStateInterval doSingularQuery(long t, int attributeQuark) throws TimeRangeException, StateSystemDisposedException {
        try {
            return this.getRelevantInterval(t, attributeQuark);
        }
        catch (ClosedChannelException e) {
            throw new StateSystemDisposedException(e);
        }
    }

    private void checkValidTime(long t) {
        long startTime = this.getStartTime();
        long endTime = this.getEndTime();
        if (t < startTime || t > endTime) {
            throw new TimeRangeException(String.format("%s Time:%d, Start:%d, End:%d", this.fSsid, t, startTime, endTime));
        }
    }

    private HTInterval getRelevantInterval(long t, int key) throws TimeRangeException, ClosedChannelException {
        this.checkValidTime(t);
        LinkedList<Integer> queue = new LinkedList<Integer>();
        queue.add(this.getSHT().getRootNode().getSequenceNumber());
        HTInterval interval = null;
        while (interval == null && !queue.isEmpty()) {
            int sequenceNumber = (Integer)queue.pop();
            HTNode currentNode = this.getSHT().readNode(sequenceNumber);
            if (currentNode.getNodeType() == HTNode.NodeType.CORE) {
                queue.addAll(((ParentNode)currentNode).selectNextChildren(t, key));
            }
            interval = currentNode.getRelevantInterval(key, t);
        }
        return interval;
    }

    @Override
    public Iterable<@NonNull ITmfStateInterval> query2D(final IntegerRangeCondition quarks, final TimeRangeCondition times) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (final TraceCompassLogUtils.FlowScopeLog log = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINER, "HistoryTreeBackend:query2D:init", new Object[]{"ssid", this.getSSID(), "quarks", quarks, "timeCondition", times}).build();){
            return () -> new Iterator<ITmfStateInterval>(){
                private final Deque<Integer> seqNumberQueue;
                private Iterator<@NonNull HTInterval> intervalQueue;
                {
                    this.seqNumberQueue = new LinkedList<Integer>(Collections.singleton(HistoryTreeBackend.this.getSHT().getRootNode().getSequenceNumber()));
                    this.intervalQueue = Collections.emptyIterator();
                }

                @Override
                public boolean hasNext() {
                    Throwable throwable;
                    while (!this.intervalQueue.hasNext() && !this.seqNumberQueue.isEmpty()) {
                        try {
                            HTNode currentNode = HistoryTreeBackend.this.getSHT().readNode(this.seqNumberQueue);
                            TimeRangeCondition subTimes = times.subCondition(currentNode.getNodeStart(), currentNode.getNodeEnd());
                            if (!quarks.intersects(currentNode.getMinQuark(), currentNode.getMaxQuark()) || subTimes == null) continue;
                            if (currentNode.getNodeType() == HTNode.NodeType.CORE) {
                                ((ParentNode)currentNode).queueNextChildren2D(quarks, subTimes, this.seqNumberQueue);
                            }
                            this.intervalQueue = currentNode.iterable2D(quarks, subTimes).iterator();
                        }
                        catch (ClosedChannelException e) {
                            throwable = null;
                            Object var3_5 = null;
                            try {
                                TraceCompassLogUtils.FlowScopeLog closedChannelLog = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINER, "HistoryTreeBackend:query2D:channelClosed", new Object[0]).setParentScope(log).build();
                                if (closedChannelLog != null) {
                                    closedChannelLog.close();
                                }
                                return false;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                    }
                    boolean hasNext = this.intervalQueue.hasNext();
                    if (!hasNext) {
                        throwable = null;
                        Object var3_7 = null;
                        try {
                            TraceCompassLogUtils.FlowScopeLog noNext = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINER, "HistoryTreeBackend:query2D:iteratorEnd", new Object[0]).setParentScope(log).build();
                            if (noNext != null) {
                                noNext.close();
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    return this.intervalQueue.hasNext();
                }

                @Override
                public ITmfStateInterval next() {
                    return this.intervalQueue.next();
                }
            };
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public long getFileSize() {
        return this.getSHT().getFileSize();
    }

    public int getAverageNodeUsage() {
        long total = 0L;
        try {
            int seq = 0;
            while (seq < this.getSHT().getNodeCount()) {
                HTNode node = this.getSHT().readNode(seq);
                total += node.getNodeUsagePercent();
                ++seq;
            }
        }
        catch (ClosedChannelException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        long ret = total / (long)this.getSHT().getNodeCount();
        if (ret < 0L || ret > 100L) {
            throw new IllegalStateException("Average node usage is not a percentage: " + ret);
        }
        return (int)ret;
    }
}

