/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.density;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.density.AbstractSegmentStoreDensityViewer;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.density.BaseMouseProvider;
import org.swtchart.IAxis;
import org.swtchart.ICustomPaintListener;
import org.swtchart.IPlotArea;
import org.swtchart.Range;

public class MouseDragZoomProvider
extends BaseMouseProvider
implements MouseListener,
MouseMoveListener,
ICustomPaintListener {
    private double fStartCoordinate;
    private double fEndCoordinate;
    private boolean fIsUpdate;

    public MouseDragZoomProvider(AbstractSegmentStoreDensityViewer densityViewer) {
        super(densityViewer);
        this.register();
    }

    @Override
    public final void register() {
        this.getChart().getPlotArea().addMouseListener((MouseListener)this);
        this.getChart().getPlotArea().addMouseMoveListener((MouseMoveListener)this);
        ((IPlotArea)this.getChart().getPlotArea()).addCustomPaintListener((ICustomPaintListener)this);
    }

    @Override
    public final void deregister() {
        if (!this.getChart().isDisposed()) {
            this.getChart().getPlotArea().removeMouseListener((MouseListener)this);
            this.getChart().getPlotArea().removeMouseMoveListener((MouseMoveListener)this);
            ((IPlotArea)this.getChart().getPlotArea()).removeCustomPaintListener((ICustomPaintListener)this);
        }
    }

    public void mouseDoubleClick(@Nullable MouseEvent e) {
    }

    public void mouseDown(@Nullable MouseEvent e) {
        if (e != null && e.button == 3) {
            IAxis xAxis = this.getChart().getAxisSet().getXAxis(0);
            this.fEndCoordinate = this.fStartCoordinate = xAxis.getDataCoordinate(e.x);
            this.fIsUpdate = true;
        }
    }

    public void mouseUp(@Nullable MouseEvent e) {
        if (this.fIsUpdate && this.fStartCoordinate != this.fEndCoordinate) {
            if (this.fStartCoordinate > this.fEndCoordinate) {
                double tmp = this.fStartCoordinate;
                this.fStartCoordinate = this.fEndCoordinate;
                this.fEndCoordinate = tmp;
            }
            this.getDensityViewer().zoom(new Range(this.fStartCoordinate, this.fEndCoordinate));
        }
        if (this.fIsUpdate) {
            this.getChart().redraw();
        }
        this.fIsUpdate = false;
    }

    public void mouseMove(@Nullable MouseEvent e) {
        if (e != null && this.fIsUpdate) {
            IAxis xAxis = this.getChart().getAxisSet().getXAxis(0);
            this.fEndCoordinate = xAxis.getDataCoordinate(e.x);
            this.getChart().redraw();
        }
    }

    public void paintControl(@Nullable PaintEvent e) {
        if (e != null && this.fIsUpdate && this.fStartCoordinate != this.fEndCoordinate) {
            IAxis xAxis = this.getChart().getAxisSet().getXAxis(0);
            int startX = xAxis.getPixelCoordinate(this.fStartCoordinate);
            int endX = xAxis.getPixelCoordinate(this.fEndCoordinate);
            e.gc.setBackground(this.getChart().getDisplay().getSystemColor(34));
            if (this.fStartCoordinate < this.fEndCoordinate) {
                e.gc.fillRectangle(startX, 0, endX - startX, e.height);
            } else {
                e.gc.fillRectangle(endX, 0, startX - endX, e.height);
            }
            e.gc.drawLine(startX, 0, startX, e.height);
            e.gc.drawLine(endX, 0, endX, e.height);
        }
    }

    public boolean drawBehindSeries() {
        return true;
    }
}

