/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pmf.ui.properties.validators;

import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.xwt.IValidationRule;
import org.eclipse.xwt.validation.AbstractValidationRule;

public class IntegerValidator
extends AbstractValidationRule {
    public IValidationRule.Phase getPhase() {
        return IValidationRule.Phase.BeforeSet;
    }

    public IValidationRule.Direction getBindingMode() {
        return IValidationRule.Direction.TargetToSource;
    }

    public IStatus validate(Object value) {
        if (value == null || value.equals("")) {
            return ValidationStatus.ok();
        }
        try {
            Integer.parseInt(value.toString().trim());
        }
        catch (NumberFormatException e) {
            return ValidationStatus.error((String)("'" + value.toString() + "' is not a validate int number."));
        }
        return ValidationStatus.ok();
    }

    public IStatus validateBack(Object value) {
        return this.validate(value);
    }
}

