/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pmf.pim.tests.initialize;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import model.ModelFactory;
import model.Nationality;
import model.Person;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.core.domain.RuntimePlatformResourceSet;
import org.eclipse.egf.model.domain.DomainViewpoint;
import org.eclipse.egf.model.domain.EMFDomain;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fcore.FactoryComponent;
import org.eclipse.egf.model.fcore.ViewpointContainer;
import org.eclipse.egf.producer.manager.FactoryComponentManagerFactory;
import org.eclipse.egf.producer.manager.IActivityManager;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pmf.pim.Application;
import org.eclipse.pmf.pim.DataElement;
import org.eclipse.pmf.pim.DataForm;
import org.eclipse.pmf.pim.DataItem;
import org.eclipse.pmf.pim.ElementalDataForm;
import org.eclipse.pmf.pim.PMFFactory;
import org.eclipse.pmf.pim.data.DataType;
import org.eclipse.pmf.pim.tests.AbstractProjectTest;
import org.eclipse.pmf.pim.tests.Activator;
import org.eclipse.pmf.pim.tests.initialize.ResourceFileCreationTest;
import org.eclipse.pmf.pim.ui.Button;
import org.eclipse.pmf.pim.ui.Control;
import org.eclipse.pmf.pim.ui.UiFactory;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xwt.XWT;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XWTGenerationTest
extends AbstractProjectTest {
    private Bundle _bundle;

    public void testStyleWithUIControl() throws Exception {
        XWTGenerationTest.assertNotNull((Object)((Object)Activator.getDefault()));
        this._bundle = Activator.getDefault().getBundle();
        XWTGenerationTest.assertNotNull((Object)this._bundle);
        RuntimePlatformResourceSet resourceSet = new RuntimePlatformResourceSet();
        this.modelImport("tests.fcore");
        this.modelImport("tests.ctx");
        this.modelImport("styleUI.pmf");
        URI uri = URI.createURI((String)"platform:/plugin/org.eclipse.pmf.pim.tests/src/org/eclipse/pmf/pim/tests/initialize/tests.fcore");
        IFile modelFile1 = this.project.getFile("model/tests.fcore");
        XWTGenerationTest.assertTrue((boolean)modelFile1.exists());
        IFile modelFile2 = this.project.getFile("model/styleUI.pmf");
        XWTGenerationTest.assertTrue((boolean)modelFile2.exists());
        IFile modelFile = this.project.getFile("model/tests.ctx");
        XWTGenerationTest.assertTrue((boolean)modelFile.exists());
        Resource resource = resourceSet.getResource(uri, true);
        EObject eObject = (EObject)resource.getContents().get(0);
        XWTGenerationTest.assertTrue((String)NLS.bind((String)"We Expected to find a ''FactoryComponent'' however we found ''{0}''", (Object)eObject.eClass().getName()), (boolean)(eObject instanceof Activity));
        FactoryComponent PMFtoXWT_FC = (FactoryComponent)eObject;
        ViewpointContainer vc1 = PMFtoXWT_FC.getViewpointContainer();
        DomainViewpoint dv1 = (DomainViewpoint)vc1.getViewpoints().get(0);
        EMFDomain emfDomainModel = (EMFDomain)dv1.getDomains().get(0);
        URI uriPMF = URI.createURI((String)"platform:/plugin/org.eclipse.pmf.pim.tests/src/org/eclipse/pmf/pim/tests/initialize/tests.ctx");
        emfDomainModel.setUri(uriPMF);
        emfDomainModel.setHelperImplementation("org.eclipse.egf.domain.emf.EMFDomainHelper");
        EMFDomain emfDomainCodegen = (EMFDomain)dv1.getDomains().get(1);
        URI uriCodeGen = URI.createURI((String)"platform:/plugin/org.eclipse.pmf.pim.tests/src/org/eclipse/pmf/pim/tests/initialize/styleUI.pmf");
        emfDomainCodegen.setUri(uriCodeGen);
        emfDomainCodegen.setHelperImplementation("org.eclipse.egf.domain.emf.EMFDomainHelper");
        IActivityManager manager = FactoryComponentManagerFactory.createProductionManager((Bundle)this._bundle, (FactoryComponent)PMFtoXWT_FC);
        try {
            try {
                manager.initializeContext();
                manager.invoke((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                try {
                    manager.dispose();
                }
                catch (Exception e2) {
                    return;
                }
                return;
            }
        }
        finally {
            try {
                manager.dispose();
            }
            catch (Exception e) {
                return;
            }
        }
        IWorkspaceRoot rootP = ResourcesPlugin.getWorkspace().getRoot();
        IProject projectP = rootP.getProject("testpersonproject");
        URL url1 = projectP.getFile("src/testpersonproject/model/PersonPersonView.xwt").getLocationURI().toURL();
        IFile modelFile3 = projectP.getFile("src/testpersonproject/model/PersonPersonView.xwt");
        IFile modelFile4 = projectP.getFile("src/META-INF/MANIFEST.MF");
        Person person = ModelFactory.eINSTANCE.createPerson();
        person.setEmail("nvhoa@gmail.com");
        person.setNationality(Nationality.FR);
        person.setBirthday(new Date());
        person.setMarried(true);
        this.runTest(url1, (Object)person, new Runnable(){

            @Override
            public void run() {
                this.checkDatabinding();
            }

            public void checkDatabinding() {
                Object element = XWT.findElementByName((Object)XWTGenerationTest.this.root, (String)"text email");
                XWTGenerationTest.assertTrue((boolean)(element instanceof Text));
                Text text = (Text)element;
                XWTGenerationTest.assertEquals((String)text.getText(), (String)"nvhoa@gmail.com");
            }
        });
        this.runTest(url1, new Runnable(){

            @Override
            public void run() {
                this.checkStyleTextField();
                this.checkComboGeneration();
                this.checkHelpGeneration();
            }

            public void checkStyleTextField() {
                Object element = XWT.findElementByName((Object)XWTGenerationTest.this.root, (String)"text email");
                XWTGenerationTest.assertTrue((boolean)(element instanceof Text));
                Text text = (Text)element;
                XWTGenerationTest.assertEquals((Object)text.getForeground().getRGB(), (Object)new RGB(53, 153, 255));
                XWTGenerationTest.assertEquals((Object)text.getBackground().getRGB(), (Object)new RGB(255, 153, 53));
                XWTGenerationTest.assertEquals((String)text.getFont().getFontData()[0].getName(), (String)"Arial");
                XWTGenerationTest.assertEquals((int)text.getFont().getFontData()[0].getHeight(), (int)12);
            }

            public void checkHelpGeneration() {
                Object element = XWT.findElementByName((Object)XWTGenerationTest.this.root, (String)"helpLink");
                XWTGenerationTest.assertTrue((boolean)(element instanceof Link));
                Object autoNamedHelp = XWT.findElementByName((Object)XWTGenerationTest.this.root, (String)"nationality_help");
                XWTGenerationTest.assertTrue((boolean)(autoNamedHelp instanceof Label));
            }

            public void checkComboGeneration() {
                Object element = XWT.findElementByName((Object)XWTGenerationTest.this.root, (String)"nationality selector");
                XWTGenerationTest.assertTrue((boolean)(element instanceof ComboViewer));
                ComboViewer comboViewer = (ComboViewer)element;
                XWTGenerationTest.assertEquals((Object)comboViewer.getCombo().getBackground().getRGB(), (Object)new RGB(255, 255, 255));
                XWTGenerationTest.assertEquals((Object)comboViewer.getCombo().getForeground().getRGB(), (Object)new RGB(0, 0, 0));
                XWTGenerationTest.assertEquals((String)comboViewer.getCombo().getFont().getFontData()[0].getName(), (String)"Lucida Grande");
                XWTGenerationTest.assertEquals((int)comboViewer.getCombo().getFont().getFontData()[0].getHeight(), (int)11);
                String[] items = comboViewer.getCombo().getItems();
                XWTGenerationTest.assertTrue((items.length == 2 ? 1 : 0) != 0);
                Object input = comboViewer.getInput();
                XWTGenerationTest.assertTrue((boolean)(input instanceof WritableList));
                WritableList list = (WritableList)input;
                XWTGenerationTest.assertTrue((boolean)list.contains((Object)Nationality.US));
                XWTGenerationTest.assertTrue((boolean)list.contains((Object)Nationality.FR));
            }
        });
    }

    public void testimportModel() throws Exception {
        XWTGenerationTest.assertNotNull((Object)((Object)Activator.getDefault()));
        this._bundle = Activator.getDefault().getBundle();
        XWTGenerationTest.assertNotNull((Object)this._bundle);
        RuntimePlatformResourceSet resourceSet = new RuntimePlatformResourceSet();
        this.modelImport("tests.fcore");
        this.modelImport("tests.ctx");
        this.modelImport("styleUI.pmf");
        URI uri = URI.createURI((String)"platform:/plugin/org.eclipse.pmf.pim.tests/src/org/eclipse/pmf/pim/tests/initialize/tests.fcore");
        URI uriCodeGen = URI.createURI((String)"platform:/plugin/org.eclipse.pmf.pim.tests/src/org/eclipse/pmf/pim/tests/initialize/styleUI.pmf");
        ResourceSetImpl resourceSet2 = new ResourceSetImpl();
        Resource resource2 = resourceSet.getResource(uriCodeGen, true);
        Application application = (Application)resource2.getContents().get(0);
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbench serviceLocator = PlatformUI.getWorkbench();
    }

    public void testDateDataType() throws Exception {
        XWTGenerationTest.assertNotNull((Object)((Object)Activator.getDefault()));
        this._bundle = Activator.getDefault().getBundle();
        XWTGenerationTest.assertNotNull((Object)this._bundle);
        RuntimePlatformResourceSet resourceSet = new RuntimePlatformResourceSet();
        URI uri = URI.createURI((String)"platform:/plugin/org.eclipse.pmf.pim.tests/src/org/eclipse/pmf/pim/tests/initialize/tests.fcore");
        Resource resource = resourceSet.getResource(uri, true);
        EObject eObject = (EObject)resource.getContents().get(0);
        XWTGenerationTest.assertTrue((String)NLS.bind((String)"We Expected to find a ''FactoryComponent'' however we found ''{0}''", (Object)eObject.eClass().getName()), (boolean)(eObject instanceof Activity));
        FactoryComponent PMFtoXWT_FC = (FactoryComponent)eObject;
        ViewpointContainer vc1 = PMFtoXWT_FC.getViewpointContainer();
        DomainViewpoint dv1 = (DomainViewpoint)vc1.getViewpoints().get(0);
        EMFDomain emfDomainModel = (EMFDomain)dv1.getDomains().get(0);
        URI uriPMF = URI.createURI((String)"platform:/plugin/org.eclipse.pmf.pim.tests/src/org/eclipse/pmf/pim/tests/initialize/tests.ctx");
        emfDomainModel.setUri(uriPMF);
        emfDomainModel.setHelperImplementation("org.eclipse.egf.domain.emf.EMFDomainHelper");
        EMFDomain emfDomainCodegen = (EMFDomain)dv1.getDomains().get(1);
        URI uriCodeGen = URI.createURI((String)"platform:/plugin/org.eclipse.pmf.pim.tests/src/org/eclipse/pmf/pim/tests/initialize/DateTest.pmf");
        emfDomainCodegen.setUri(uriCodeGen);
        emfDomainCodegen.setHelperImplementation("org.eclipse.egf.domain.emf.EMFDomainHelper");
        IActivityManager manager = FactoryComponentManagerFactory.createProductionManager((Bundle)this._bundle, (FactoryComponent)PMFtoXWT_FC);
        try {
            try {
                manager.initializeContext();
                manager.invoke((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                try {
                    manager.dispose();
                }
                catch (Exception e2) {
                    return;
                }
                return;
            }
        }
        finally {
            try {
                manager.dispose();
            }
            catch (Exception e) {
                return;
            }
        }
        IWorkspaceRoot rootP = ResourcesPlugin.getWorkspace().getRoot();
        IProject projectP = rootP.getProject("testpersonproject");
        URL url1 = projectP.getFile("src/testpersonproject/model/PersonPersonView.xwt").getLocationURI().toURL();
        IFile modelFile3 = projectP.getFile("src/testpersonproject/model/PersonPersonView.xwt");
        IFile modelFile4 = projectP.getFile("src/META-INF/MANIFEST.MF");
        Person person = ModelFactory.eINSTANCE.createPerson();
        Date date = new Date("6/3/1984");
        person.setBirthday(date);
        this.runTest(url1, (Object)person, new Runnable(){

            @Override
            public void run() {
                this.checkDateChooserDatabinding();
            }

            public void checkDateChooserDatabinding() {
                Object element = XWT.findElementByName((Object)XWTGenerationTest.this.root, (String)"birthday");
                XWTGenerationTest.assertTrue((boolean)(element instanceof DateTime));
                DateTime text = (DateTime)element;
                XWTGenerationTest.assertEquals((Object)text.getDay(), (Object)"6");
                XWTGenerationTest.assertEquals((Object)text.getMonth(), (Object)"3");
                XWTGenerationTest.assertEquals((Object)text.getYear(), (Object)"1984");
            }
        });
    }

    public void testDocumentationPropertiesView() throws Exception {
        XWTGenerationTest.assertNotNull((Object)((Object)Activator.getDefault()));
        this._bundle = Activator.getDefault().getBundle();
        XWTGenerationTest.assertNotNull((Object)this._bundle);
        RuntimePlatformResourceSet resourceSet = new RuntimePlatformResourceSet();
        URI uri = URI.createURI((String)"platform:/plugin/org.eclipse.pmf.ui.tools.properties/egf/Properties.fcore");
        Resource resource = resourceSet.getResource(uri, true);
        EObject eObject = (EObject)resource.getContents().get(0);
        XWTGenerationTest.assertTrue((String)NLS.bind((String)"We Expected to find a ''FactoryComponent'' however we found ''{0}''", (Object)eObject.eClass().getName()), (boolean)(eObject instanceof Activity));
        FactoryComponent PMFtoXWT_FC = (FactoryComponent)eObject;
        ViewpointContainer vc1 = PMFtoXWT_FC.getViewpointContainer();
        DomainViewpoint dv1 = (DomainViewpoint)vc1.getViewpoints().get(1);
        EMFDomain emfDomainModel = (EMFDomain)dv1.getDomains().get(1);
        URI uriPMF = URI.createURI((String)"platform:/plugin/org.eclipse.pmf.ui.tools.properties/model/CodeGen.ctx");
        emfDomainModel.setUri(uriPMF);
        emfDomainModel.setHelperImplementation("org.eclipse.egf.domain.emf.EMFDomainHelper");
        EMFDomain emfDomainCodegen = (EMFDomain)dv1.getDomains().get(0);
        URI uriCodeGen = URI.createURI((String)"platform:/plugin/org.eclipse.pmf.ui.tools.properties/model/PMFPropertiesApplication.pmf");
        emfDomainCodegen.setUri(uriCodeGen);
        emfDomainCodegen.setHelperImplementation("org.eclipse.egf.domain.emf.EMFDomainHelper");
        IActivityManager manager = FactoryComponentManagerFactory.createProductionManager((Bundle)this._bundle, (FactoryComponent)PMFtoXWT_FC);
        try {
            try {
                manager.initializeContext();
                manager.invoke((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                try {
                    manager.dispose();
                }
                catch (Exception e2) {
                    return;
                }
                return;
            }
        }
        finally {
            try {
                manager.dispose();
            }
            catch (Exception e) {
                return;
            }
        }
        IWorkspaceRoot rootP = ResourcesPlugin.getWorkspace().getRoot();
        IProject projectP = rootP.getProject("org.eclipse.pmf.ui.properties");
        IFile DocumentationFile = projectP.getFile("src/org/eclipse/pmf/ui/properties/views/DocumentationTabContentView.xwt");
        XWTGenerationTest.assertTrue((boolean)DocumentationFile.exists());
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document docPersonView = dBuilder.parse(DocumentationFile.getLocation().toFile());
        docPersonView.getDocumentElement().normalize();
        Node composite = docPersonView.getElementsByTagName("r:RichTextEditor").item(0);
        if (composite.getNodeType() == 1) {
            Element element = (Element)composite;
            XWTGenerationTest.assertEquals((String)element.getAttribute("x:name"), (String)"description");
        }
    }

    public void testStyleWithoutUIControl() throws Exception {
        XWTGenerationTest.assertNotNull((Object)((Object)Activator.getDefault()));
        this._bundle = Activator.getDefault().getBundle();
        XWTGenerationTest.assertNotNull((Object)this._bundle);
        RuntimePlatformResourceSet resourceSet = new RuntimePlatformResourceSet();
        this.modelImport("tests.fcore");
        this.modelImport("tests.ctx");
        this.modelImport("styleNonUI.pmf");
        URI uri = URI.createURI((String)"platform:/plugin/org.eclipse.pmf.pim.tests/src/org/eclipse/pmf/pim/tests/initialize/tests.fcore");
        IFile modelFile1 = this.project.getFile("model/tests.fcore");
        XWTGenerationTest.assertTrue((boolean)modelFile1.exists());
        IFile modelFile2 = this.project.getFile("model/styleNonUI.pmf");
        XWTGenerationTest.assertTrue((boolean)modelFile2.exists());
        IFile modelFile = this.project.getFile("model/tests.ctx");
        XWTGenerationTest.assertTrue((boolean)modelFile.exists());
        Resource resource = resourceSet.getResource(uri, true);
        EObject eObject = (EObject)resource.getContents().get(0);
        XWTGenerationTest.assertTrue((String)NLS.bind((String)"We Expected to find a ''FactoryComponent'' however we found ''{0}''", (Object)eObject.eClass().getName()), (boolean)(eObject instanceof Activity));
        FactoryComponent PMFtoXWT_FC = (FactoryComponent)eObject;
        ViewpointContainer vc1 = PMFtoXWT_FC.getViewpointContainer();
        DomainViewpoint dv1 = (DomainViewpoint)vc1.getViewpoints().get(0);
        EMFDomain emfDomainModel = (EMFDomain)dv1.getDomains().get(0);
        URI uriPMF = URI.createURI((String)"platform:/plugin/org.eclipse.pmf.pim.tests/src/org/eclipse/pmf/pim/tests/initialize/tests.ctx");
        emfDomainModel.setUri(uriPMF);
        emfDomainModel.setHelperImplementation("org.eclipse.egf.domain.emf.EMFDomainHelper");
        EMFDomain emfDomainCodegen = (EMFDomain)dv1.getDomains().get(1);
        URI uriCodeGen = URI.createURI((String)"platform:/plugin/org.eclipse.pmf.pim.tests/src/org/eclipse/pmf/pim/tests/initialize/styleNonUI.pmf");
        emfDomainCodegen.setUri(uriCodeGen);
        emfDomainCodegen.setHelperImplementation("org.eclipse.egf.domain.emf.EMFDomainHelper");
        IActivityManager manager = FactoryComponentManagerFactory.createProductionManager((Bundle)this._bundle, (FactoryComponent)PMFtoXWT_FC);
        try {
            try {
                manager.initializeContext();
                manager.invoke((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                try {
                    manager.dispose();
                }
                catch (Exception e2) {
                    return;
                }
                return;
            }
        }
        finally {
            try {
                manager.dispose();
            }
            catch (Exception e) {
                return;
            }
        }
        IWorkspaceRoot rootP = ResourcesPlugin.getWorkspace().getRoot();
        IProject projectP = rootP.getProject("testpersonproject");
        URL url1 = projectP.getFile("src/testpersonproject/model/PersonPersonView.xwt").getLocationURI().toURL();
        IFile modelFile3 = projectP.getFile("src/testpersonproject/model/PersonPersonView.xwt");
        IFile modelFile4 = projectP.getFile("src/META-INF/MANIFEST.MF");
        this.runTest(url1, new Runnable(){

            @Override
            public void run() {
                this.checkStringtoDefaultTextField();
                this.checkEnumerationtoComboViewer();
            }

            public void checkStringtoDefaultTextField() {
                Object element = XWT.findElementByName((Object)XWTGenerationTest.this.root, (String)"email");
                XWTGenerationTest.assertTrue((boolean)(element instanceof Text));
                Text text = (Text)element;
                XWTGenerationTest.assertEquals((Object)text.getBackground().getRGB(), (Object)new RGB(255, 255, 255));
                XWTGenerationTest.assertEquals((Object)text.getForeground().getRGB(), (Object)new RGB(0, 0, 0));
                XWTGenerationTest.assertEquals((String)text.getFont().getFontData()[0].getName(), (String)"Lucida Grande");
                XWTGenerationTest.assertEquals((int)text.getFont().getFontData()[0].getHeight(), (int)11);
            }

            public void checkEnumerationtoComboViewer() {
                Object element = XWT.findElementByName((Object)XWTGenerationTest.this.root, (String)"nationality");
                XWTGenerationTest.assertTrue((boolean)(element instanceof ComboViewer));
                ComboViewer comboViewer = (ComboViewer)element;
                XWTGenerationTest.assertEquals((Object)comboViewer.getCombo().getBackground().getRGB(), (Object)new RGB(255, 255, 255));
                XWTGenerationTest.assertEquals((Object)comboViewer.getCombo().getForeground().getRGB(), (Object)new RGB(0, 0, 0));
                XWTGenerationTest.assertEquals((String)comboViewer.getCombo().getFont().getFontData()[0].getName(), (String)"Lucida Grande");
                XWTGenerationTest.assertEquals((int)comboViewer.getCombo().getFont().getFontData()[0].getHeight(), (int)11);
                String[] items = comboViewer.getCombo().getItems();
                XWTGenerationTest.assertTrue((items.length == 2 ? 1 : 0) != 0);
                Object input = comboViewer.getInput();
                XWTGenerationTest.assertTrue((boolean)(input instanceof WritableList));
                WritableList list = (WritableList)input;
                XWTGenerationTest.assertTrue((boolean)list.contains((Object)Nationality.US));
                XWTGenerationTest.assertTrue((boolean)list.contains((Object)Nationality.FR));
            }

            public void checkBooleantoBooleanButton() {
                Object element = XWT.findElementByName((Object)XWTGenerationTest.this.root, (String)"married");
                XWTGenerationTest.assertTrue((boolean)(element instanceof org.eclipse.swt.widgets.Button));
                org.eclipse.swt.widgets.Button button = (org.eclipse.swt.widgets.Button)element;
                XWTGenerationTest.assertEquals((Object)button.getBackground().getRGB(), (Object)new RGB(255, 255, 255));
                XWTGenerationTest.assertEquals((int)button.getStyle(), (int)32);
                XWTGenerationTest.assertEquals((Object)button.getForeground().getRGB(), (Object)new RGB(0, 0, 0));
                XWTGenerationTest.assertEquals((String)button.getFont().getFontData()[0].getName(), (String)"Lucida Grande");
                XWTGenerationTest.assertEquals((int)button.getFont().getFontData()[0].getHeight(), (int)11);
            }
        });
    }

    public void testNamespace() throws Exception {
        XWTGenerationTest.assertNotNull((Object)((Object)Activator.getDefault()));
        this._bundle = Activator.getDefault().getBundle();
        XWTGenerationTest.assertNotNull((Object)this._bundle);
        RuntimePlatformResourceSet resourceSet = new RuntimePlatformResourceSet();
        URI uri = URI.createURI((String)"platform:/plugin/org.eclipse.pmf.pim.tests/src/org/eclipse/pmf/pim/tests/initialize/tests.fcore");
        Resource resource = resourceSet.getResource(uri, true);
        EObject eObject = (EObject)resource.getContents().get(0);
        XWTGenerationTest.assertTrue((String)NLS.bind((String)"We Expected to find a ''FactoryComponent'' however we found ''{0}''", (Object)eObject.eClass().getName()), (boolean)(eObject instanceof Activity));
        FactoryComponent PMFtoXWT_FC = (FactoryComponent)eObject;
        ViewpointContainer vc1 = PMFtoXWT_FC.getViewpointContainer();
        DomainViewpoint dv1 = (DomainViewpoint)vc1.getViewpoints().get(0);
        EMFDomain emfDomainModel = (EMFDomain)dv1.getDomains().get(0);
        URI uriPMF = URI.createURI((String)"platform:/plugin/org.eclipse.pmf.pim.tests/src/org/eclipse/pmf/pim/tests/initialize/tests.ctx");
        emfDomainModel.setUri(uriPMF);
        emfDomainModel.setHelperImplementation("org.eclipse.egf.domain.emf.EMFDomainHelper");
        EMFDomain emfDomainCodegen = (EMFDomain)dv1.getDomains().get(1);
        URI uriCodeGen = URI.createURI((String)"platform:/plugin/org.eclipse.pmf.pim.tests/src/org/eclipse/pmf/pim/tests/initialize/styleUI.pmf");
        emfDomainCodegen.setUri(uriCodeGen);
        emfDomainCodegen.setHelperImplementation("org.eclipse.egf.domain.emf.EMFDomainHelper");
        IActivityManager manager = FactoryComponentManagerFactory.createProductionManager((Bundle)this._bundle, (FactoryComponent)PMFtoXWT_FC);
        try {
            try {
                manager.initializeContext();
                manager.invoke((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                try {
                    manager.dispose();
                }
                catch (Exception e2) {
                    return;
                }
                return;
            }
        }
        finally {
            try {
                manager.dispose();
            }
            catch (Exception e) {
                return;
            }
        }
        IWorkspaceRoot rootP = ResourcesPlugin.getWorkspace().getRoot();
        IProject projectP = rootP.getProject("testpersonproject");
        URL urlPersonView = projectP.getFile("src/testpersonproject/model/PersonPersonView.xwt").getLocationURI().toURL();
        IFile PersonVewFile = projectP.getFile("src/testpersonproject/model/PersonPersonView.xwt");
        XWTGenerationTest.assertTrue((boolean)PersonVewFile.exists());
        IFile CompanyViewFile = projectP.getFile("src/testpersonproject/model/CompanyCompanyView.xwt");
        XWTGenerationTest.assertTrue((boolean)CompanyViewFile.exists());
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document docPersonView = dBuilder.parse(PersonVewFile.getLocation().toFile());
        docPersonView.getDocumentElement().normalize();
        Node composite = docPersonView.getElementsByTagName("Composite").item(0);
        if (composite.getNodeType() == 1) {
            Element element = (Element)composite;
            XWTGenerationTest.assertEquals((String)element.getAttribute("xmlns"), (String)"http://www.eclipse.org/xwt/presentation");
            XWTGenerationTest.assertEquals((String)element.getAttribute("xmlns:x"), (String)"http://www.eclipse.org/xwt");
            XWTGenerationTest.assertEquals((String)element.getAttribute("xmlns:m"), (String)"clr-namespace:testpersonproject.model");
            XWTGenerationTest.assertEquals((String)element.getAttribute("xmlns:e"), (String)"clr-namespace:org.eclipse.pmf.pim.tests.initialize");
            XWTGenerationTest.assertEquals((String)element.getAttribute("xmlns:n"), (String)"clr-namespace:model");
            XWTGenerationTest.assertEquals((String)element.getAttribute("x:Class"), (String)"testpersonproject.model.PersonPersonView");
            XWTGenerationTest.assertEquals((int)element.getAttributes().getLength(), (int)8);
        }
        Document docCompanyView = dBuilder.parse(CompanyViewFile.getLocation().toFile());
        docCompanyView.getDocumentElement().normalize();
        Node composite2 = docCompanyView.getElementsByTagName("Composite").item(0);
        if (composite2.getNodeType() == 1) {
            Element element = (Element)composite2;
            XWTGenerationTest.assertEquals((String)element.getAttribute("xmlns"), (String)"http://www.eclipse.org/xwt/presentation");
            XWTGenerationTest.assertEquals((String)element.getAttribute("xmlns:x"), (String)"http://www.eclipse.org/xwt");
            XWTGenerationTest.assertEquals((String)element.getAttribute("xmlns:m"), (String)"clr-namespace:testpersonproject.model");
            XWTGenerationTest.assertEquals((int)element.getAttributes().getLength(), (int)5);
        }
    }

    public void testDataInheritance_Hyperlink() throws Exception {
        Element element;
        XWTGenerationTest.assertNotNull((Object)((Object)Activator.getDefault()));
        this._bundle = Activator.getDefault().getBundle();
        XWTGenerationTest.assertNotNull((Object)this._bundle);
        RuntimePlatformResourceSet resourceSet = new RuntimePlatformResourceSet();
        URI uri = URI.createURI((String)"platform:/plugin/org.eclipse.pmf.pim.tests/src/org/eclipse/pmf/pim/tests/initialize/tests.fcore");
        Resource resource = resourceSet.getResource(uri, true);
        EObject eObject = (EObject)resource.getContents().get(0);
        XWTGenerationTest.assertTrue((String)NLS.bind((String)"We Expected to find a ''FactoryComponent'' however we found ''{0}''", (Object)eObject.eClass().getName()), (boolean)(eObject instanceof Activity));
        FactoryComponent PMFtoXWT_FC = (FactoryComponent)eObject;
        ViewpointContainer vc1 = PMFtoXWT_FC.getViewpointContainer();
        DomainViewpoint dv1 = (DomainViewpoint)vc1.getViewpoints().get(0);
        EMFDomain emfDomainModel = (EMFDomain)dv1.getDomains().get(0);
        URI uriPMF = URI.createURI((String)"platform:/plugin/org.eclipse.pmf.pim.tests/src/org/eclipse/pmf/pim/tests/initialize/tests.ctx");
        emfDomainModel.setUri(uriPMF);
        emfDomainModel.setHelperImplementation("org.eclipse.egf.domain.emf.EMFDomainHelper");
        EMFDomain emfDomainCodegen = (EMFDomain)dv1.getDomains().get(1);
        URI uriCodeGen = URI.createURI((String)"platform:/plugin/org.eclipse.pmf.pim.tests/src/org/eclipse/pmf/pim/tests/initialize/styleUI.pmf");
        emfDomainCodegen.setUri(uriCodeGen);
        emfDomainCodegen.setHelperImplementation("org.eclipse.egf.domain.emf.EMFDomainHelper");
        IActivityManager manager = FactoryComponentManagerFactory.createProductionManager((Bundle)this._bundle, (FactoryComponent)PMFtoXWT_FC);
        try {
            try {
                manager.initializeContext();
                manager.invoke((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                try {
                    manager.dispose();
                }
                catch (Exception e2) {
                    return;
                }
                return;
            }
        }
        finally {
            try {
                manager.dispose();
            }
            catch (Exception e) {
                return;
            }
        }
        IWorkspaceRoot rootP = ResourcesPlugin.getWorkspace().getRoot();
        IProject projectP = rootP.getProject("testpersonproject");
        URL urlPersonView = projectP.getFile("src/testpersonproject/model/PersonPersonView.xwt").getLocationURI().toURL();
        IFile PersonVewFile = projectP.getFile("src/testpersonproject/model/PersonPersonView.xwt");
        XWTGenerationTest.assertTrue((boolean)PersonVewFile.exists());
        IFile CompanyViewFile = projectP.getFile("src/testpersonproject/model/CompanyCompanyView.xwt");
        XWTGenerationTest.assertTrue((boolean)CompanyViewFile.exists());
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document docPersonView = dBuilder.parse(PersonVewFile.getLocation().toFile());
        docPersonView.getDocumentElement().normalize();
        Node composite = docPersonView.getElementsByTagName("Link").item(0);
        if (composite.getNodeType() == 1) {
            element = (Element)composite;
            XWTGenerationTest.assertEquals((String)element.getAttribute("text"), (String)"www.soyatec.org");
        }
        if ((composite = docPersonView.getElementsByTagName("Composite").item(0)).getNodeType() == 1) {
            element = (Element)composite;
            XWTGenerationTest.assertEquals((String)element.getAttribute("xmlns"), (String)"http://www.eclipse.org/xwt/presentation");
            XWTGenerationTest.assertEquals((String)element.getAttribute("xmlns:x"), (String)"http://www.eclipse.org/xwt");
            XWTGenerationTest.assertEquals((String)element.getAttribute("xmlns:m"), (String)"clr-namespace:testpersonproject.model");
            XWTGenerationTest.assertEquals((String)element.getAttribute("xmlns:e"), (String)"clr-namespace:org.eclipse.pmf.pim.tests.initialize");
            XWTGenerationTest.assertEquals((String)element.getAttribute("xmlns:n"), (String)"clr-namespace:model");
            XWTGenerationTest.assertEquals((String)element.getAttribute("x:Class"), (String)"testpersonproject.model.PersonPersonView");
            XWTGenerationTest.assertEquals((int)element.getAttributes().getLength(), (int)8);
        }
        Document docCompanyView = dBuilder.parse(CompanyViewFile.getLocation().toFile());
        docCompanyView.getDocumentElement().normalize();
        Node composite2 = docCompanyView.getElementsByTagName("Composite").item(0);
        if (composite2.getNodeType() == 1) {
            Element element2 = (Element)composite2;
            XWTGenerationTest.assertEquals((String)element2.getAttribute("xmlns"), (String)"http://www.eclipse.org/xwt/presentation");
            XWTGenerationTest.assertEquals((String)element2.getAttribute("xmlns:x"), (String)"http://www.eclipse.org/xwt");
            XWTGenerationTest.assertEquals((String)element2.getAttribute("xmlns:m"), (String)"clr-namespace:testpersonproject.model");
            XWTGenerationTest.assertEquals((int)element2.getAttributes().getLength(), (int)5);
        }
    }

    public void testLabelInitialization() throws Exception {
        XWTGenerationTest.assertNotNull((Object)((Object)Activator.getDefault()));
        this._bundle = Activator.getDefault().getBundle();
        XWTGenerationTest.assertNotNull((Object)this._bundle);
        URI uriGen = URI.createURI((String)"platform:/plugin/org.eclipse.pmf.pim.tests/src/org/eclipse/pmf/pim/tests/initialize/examples-validators.genmodel", (boolean)true);
        try {
            Application rootObject = PMFFactory.eINSTANCE.createApplication();
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.getResource(uriGen, true);
            rootObject.importModel(resource);
            rootObject.setName("testpersonproject");
            for (DataType dataType : rootObject.getTypes()) {
                DataForm dataForm = rootObject.getDataFormFolder(dataType).getDefaultDataForm();
                for (DataElement dataElement : ((ElementalDataForm)dataForm).getChildren()) {
                    Control label;
                    if (!(dataElement instanceof DataItem) || !((label = ((DataItem)dataElement).getLabel()) instanceof org.eclipse.pmf.pim.ui.Label)) continue;
                    XWTGenerationTest.assertTrue((((org.eclipse.pmf.pim.ui.Label)label).getText() != null ? 1 : 0) != 0);
                    XWTGenerationTest.assertTrue((boolean)((org.eclipse.pmf.pim.ui.Label)label).getName().contains("_label"));
                }
            }
            this.modelImport("TestLabelInitialisation.pmf");
            IFile modelFile1 = this.project.getFile("model/TestLabelInitialisation.pmf");
            ResourceSetImpl resourceSet1 = new ResourceSetImpl();
            Resource resource1 = resourceSet1.getResource(URI.createURI((String)modelFile1.getLocationURI().toString()), true);
            resource1.getContents().add((Object)rootObject);
            resource1.save(Collections.EMPTY_MAP);
        }
        catch (IOException ex) {
            EcorePlugin.INSTANCE.log((Object)ex);
        }
    }

    public void testEventManagement() throws Exception {
        XWTGenerationTest.assertNotNull((Object)((Object)Activator.getDefault()));
        this._bundle = Activator.getDefault().getBundle();
        XWTGenerationTest.assertNotNull((Object)this._bundle);
        RuntimePlatformResourceSet resourceSet = new RuntimePlatformResourceSet();
        this.modelImport("tests.fcore");
        this.modelImport("tests.ctx");
        this.modelImport("testHelpElement.pmf");
        URI uri = URI.createURI((String)"platform:/plugin/org.eclipse.pmf.pim.tests/src/org/eclipse/pmf/pim/tests/initialize/tests.fcore");
        URI uriCodeGen = URI.createURI((String)"platform:/plugin/org.eclipse.pmf.pim.tests/src/org/eclipse/pmf/pim/tests/initialize/testHelpElement.pmf");
        ResourceSetImpl resourceSet2 = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(uriCodeGen, true);
        Application application = (Application)resource.getContents().get(0);
        XWTGenerationTest.assertEquals((int)application.getLibraries().size(), (int)1);
        Button button = UiFactory.eINSTANCE.createButton();
        XWTGenerationTest.assertEquals((int)application.getUIEvents(button.eClass()).size(), (int)4);
    }

    private static String getValue(String tag, Element element) {
        NodeList nodes = element.getElementsByTagName(tag).item(0).getChildNodes();
        Node node = nodes.item(0);
        return node.getNodeValue();
    }

    public void modelImport(String fileName) {
        try {
            InputStream ecore = ResourceFileCreationTest.class.getResourceAsStream(fileName);
            if (ecore == null) {
                throw new RuntimeException("Need to remove the ecore from Windows->Preferences->Java->Compiler->Building->Filtered Resources");
            }
            int size = ecore.available();
            this.copyFile(this.project, ecore, new Path("model").append(fileName));
            IFile modelFile = this.project.getFile("model/" + fileName);
            XWTGenerationTest.assertTrue((boolean)modelFile.exists());
            XWTGenerationTest.assertFalse((boolean)modelFile.isLinked());
            XWTGenerationTest.assertTrue((boolean)modelFile.isAccessible());
            XWTGenerationTest.assertEquals((int)size, (int)modelFile.getContents().available());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

