/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.oclinecore;

import org.eclipse.emf.codegen.ecore.genmodel.GenParameter;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.AS2CGVisitor;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstraint;
import org.eclipse.ocl.examples.codegen.cgmodel.CGModelFactory;
import org.eclipse.ocl.examples.codegen.cgmodel.CGNamedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGParameter;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.oclinecore.OCLinEcoreCodeGenerator;
import org.eclipse.ocl.examples.codegen.oclinecore.OCLinEcoreGlobalContext;
import org.eclipse.ocl.examples.codegen.oclinecore.OCLinEcoreLocalContext;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;

public final class OCLinEcoreAS2CGVisitor
extends AS2CGVisitor {
    protected final @NonNull OCLinEcoreGlobalContext globalContext;

    public OCLinEcoreAS2CGVisitor(@NonNull CodeGenAnalyzer analyzer, @NonNull OCLinEcoreGlobalContext globalContext) {
        super(analyzer);
        this.globalContext = globalContext;
        EnvironmentFactoryInternal environmentFactory = analyzer.getCodeGenerator().getEnvironmentFactory();
        this.createSeverityOperations(environmentFactory);
    }

    private void createSeverityOperations(@NonNull EnvironmentFactoryInternal environmentFactory) {
    }

    @Override
    protected void addParameter(@NonNull VariableDeclaration aParameter, @NonNull CGParameter cgParameter) {
        GenParameter genParameter;
        Parameter representedParameter;
        super.addParameter(aParameter, cgParameter);
        Parameter parameter = representedParameter = aParameter instanceof Variable ? ((Variable)aParameter).getRepresentedParameter() : null;
        if (representedParameter != null && (genParameter = this.genModelHelper.getGenParameter(representedParameter)) != null) {
            String name = (String)ClassUtil.nonNullState((Object)genParameter.getName());
            cgParameter.setValueName(name);
        }
    }

    @Override
    public @NonNull CGParameter getParameter(@NonNull Variable aParameter, @Nullable String name) {
        CGParameter cgParameter = super.getParameter(aParameter, name);
        if ("self".equals(aParameter.getName())) {
            cgParameter.setValueName("this");
        }
        return cgParameter;
    }

    @Override
    public @Nullable CGConstraint visitConstraint(@NonNull Constraint element) {
        CGConstraint cgConstraint = CGModelFactory.eINSTANCE.createCGConstraint();
        this.setAst((CGNamedElement)cgConstraint, (NamedElement)element);
        LanguageExpression specification = element.getOwnedSpecification();
        if (specification != null) {
            try {
                String containerName;
                ExpressionInOCL oldQuery = this.environmentFactory.parseSpecification(specification);
                String constraintName = PivotUtil.getName((NamedElement)element);
                EObject eContainer = element.eContainer();
                if (eContainer instanceof NamedElement && (containerName = ((NamedElement)eContainer).getName()) != null) {
                    constraintName = String.valueOf(containerName) + "::" + constraintName;
                }
                ExpressionInOCL asSynthesizedQuery = ((OCLinEcoreCodeGenerator)this.codeGenerator).rewriteQuery(oldQuery, constraintName);
                OCLExpression asSynthesizedExpression = asSynthesizedQuery.getOwnedBody();
                OCLinEcoreLocalContext localContext = (OCLinEcoreLocalContext)this.globalContext.getLocalContext(cgConstraint);
                Variable contextVariable = asSynthesizedQuery.getOwnedContext();
                if (contextVariable != null) {
                    CGParameter cgParameter = this.getParameter(contextVariable, null);
                    cgConstraint.getParameters().add(cgParameter);
                }
                for (Variable parameterVariable : asSynthesizedQuery.getOwnedParameters()) {
                    String contextName;
                    String diagnosticsName = localContext != null ? localContext.getDiagnosticsName() : null;
                    String string = contextName = localContext != null ? localContext.getContextName() : null;
                    CGParameter cgParameter = diagnosticsName != null && diagnosticsName.equals(parameterVariable.getName()) ? this.getParameter(parameterVariable, diagnosticsName) : (contextName != null && contextName.equals(parameterVariable.getName()) ? this.getParameter(parameterVariable, contextName) : this.getParameter(parameterVariable, null));
                    cgConstraint.getParameters().add(cgParameter);
                }
                cgConstraint.setBody(this.doVisit(CGValuedElement.class, (Element)asSynthesizedExpression));
            }
            catch (ParserException e) {
                throw new WrappedException((Exception)((Object)e));
            }
        }
        return cgConstraint;
    }
}

