/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.cse;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGParameter;
import org.eclipse.ocl.examples.codegen.cse.AbstractPlace;
import org.eclipse.ocl.examples.codegen.cse.GlobalPlace;
import org.eclipse.ocl.examples.codegen.cse.InnerStackPlace;
import org.eclipse.ocl.examples.codegen.cse.LocalPlace;
import org.eclipse.ocl.pivot.utilities.TracingOption;

public abstract class StackPlace
extends LocalPlace {
    protected final @NonNull CGElement stackElement;
    private Set<InnerStackPlace> stackPlaces = null;

    public static @NonNull StackPlace createStackPlace(@NonNull Map<CGElement, AbstractPlace> element2place, @NonNull CGParameter cgParameter) {
        AbstractPlace abstractPlace = element2place.get(cgParameter.getParent());
        if (abstractPlace instanceof StackPlace) {
            return (StackPlace)abstractPlace;
        }
        throw new IllegalStateException("No StackPlace");
    }

    protected StackPlace(@NonNull GlobalPlace globalPlace, @NonNull CGElement stackElement) {
        super(globalPlace);
        this.stackElement = stackElement;
    }

    void addStackPlace(@NonNull InnerStackPlace stackPlace) {
        if (this.stackPlaces == null) {
            this.stackPlaces = new HashSet<InnerStackPlace>();
        }
        this.stackPlaces.add(stackPlace);
    }

    public @NonNull CGElement getStackElement() {
        return this.stackElement;
    }

    @Override
    public @NonNull StackPlace getStackPlace() {
        return this;
    }

    @Override
    public void printHierarchy(@NonNull Appendable appendable, @NonNull String indentation) {
        TracingOption.println((Appendable)appendable, (String)(String.valueOf(indentation) + this));
        super.printHierarchy(appendable, String.valueOf(indentation) + "  ");
        if (this.stackPlaces != null) {
            for (StackPlace stackPlace : this.stackPlaces) {
                stackPlace.printHierarchy(appendable, String.valueOf(indentation) + "  ");
            }
        }
    }

    @Override
    public void prune() {
        if (this.stackPlaces != null) {
            for (StackPlace stackPlace : this.stackPlaces) {
                stackPlace.prune();
            }
        }
        super.prune();
    }

    @Override
    public void pullUp() {
        if (this.stackPlaces != null) {
            for (StackPlace stackPlace : this.stackPlaces) {
                stackPlace.pullUp();
            }
        }
        super.pullUp();
    }

    @Override
    public void pushUp() {
        if (this.stackPlaces != null) {
            for (StackPlace stackPlace : this.stackPlaces) {
                stackPlace.pushUp();
            }
        }
        super.pushUp();
    }

    @Override
    public void rewrite() {
        if (this.stackPlaces != null) {
            for (StackPlace stackPlace : this.stackPlaces) {
                stackPlace.rewrite();
            }
        }
        super.rewrite();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + ": " + String.valueOf(this.stackElement);
    }
}

