/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java.types;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.generator.CodeGenerator;
import org.eclipse.ocl.examples.codegen.generator.TypeDescriptor;
import org.eclipse.ocl.examples.codegen.java.JavaStream;
import org.eclipse.ocl.examples.codegen.java.types.AbstractDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.EcoreDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.MapDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.UnboxedDescriptor;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.MapTypeId;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class UnboxedMapDescriptor
extends AbstractDescriptor
implements EcoreDescriptor,
UnboxedDescriptor,
MapDescriptor {
    protected final @NonNull StandardLibrary standardLibrary;
    protected final @NonNull Type keyType;
    protected final @NonNull Type valueType;

    public UnboxedMapDescriptor(@NonNull MapTypeId mapTypeId, @NonNull StandardLibrary standardLibrary, @NonNull Type keyType, @NonNull Type valueType) {
        super((ElementId)mapTypeId);
        this.standardLibrary = standardLibrary;
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    public void append(@NonNull JavaStream javaStream, @Nullable Boolean isRequired) {
        javaStream.appendClassReference(List.class, true, Object.class);
    }

    @Override
    public void appendElement(@NonNull JavaStream javaStream, boolean reClass) {
        javaStream.appendClassReference(this.getJavaClass());
    }

    @Override
    public @NonNull String getClassName() {
        return (String)ClassUtil.nonNullModel((Object)this.keyType.getName());
    }

    @Override
    public @NonNull EcoreDescriptor getEcoreDescriptor(@NonNull CodeGenerator codeGenerator, @Nullable Class<?> instanceClass) {
        return this;
    }

    @Override
    public @NonNull MapTypeId getElementId() {
        return (MapTypeId)this.elementId;
    }

    @Override
    public @NonNull Class<?> getJavaClass() {
        return Object.class;
    }

    @Override
    public @NonNull UnboxedDescriptor getUnboxedDescriptor(@NonNull CodeGenerator codeGenerator) {
        return this;
    }

    @Override
    public @Nullable Class<?> hasJavaClass() {
        return null;
    }

    @Override
    public final boolean isAssignableFrom(@NonNull TypeDescriptor typeDescriptor) {
        if (!(typeDescriptor instanceof UnboxedMapDescriptor)) {
            return false;
        }
        Type thatType = ((UnboxedMapDescriptor)typeDescriptor).keyType;
        return thatType.conformsTo(this.standardLibrary, this.keyType);
    }

    @Override
    public @NonNull String toString() {
        return this.elementId + " => Map<Object/*" + this.keyType.getName() + ",Object/*" + this.valueType.getName() + "*/>";
    }

    @Override
    public void append(@NonNull JavaStream javaStream, boolean reClass) {
    }
}

