/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.equinox.ui.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.libra.framework.core.IOSGIExecutionEnvironment;
import org.eclipse.libra.framework.core.TargetDefinitionUtil;
import org.eclipse.libra.framework.equinox.IEquinoxFrameworkInstance;
import org.eclipse.libra.framework.ui.Messages;
import org.eclipse.libra.framework.ui.Trace;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.wizards.target.EditTargetDefinitionWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class JavaProfileEditorSection
extends ServerEditorSection {
    protected Section section;
    protected IEquinoxFrameworkInstance frameworkInstance;
    protected PropertyChangeListener listener;
    private Combo javaProfileCombo;
    protected boolean updating = false;

    protected void addChangeListeners() {
        this.listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (JavaProfileEditorSection.this.updating) {
                    return;
                }
                JavaProfileEditorSection.this.updating = true;
                if ("JAVA_PROFILE".equals(event.getPropertyName())) {
                    JavaProfileEditorSection.this.validate();
                }
                JavaProfileEditorSection.this.updating = false;
            }
        };
        this.server.addPropertyChangeListener(this.listener);
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        this.section = toolkit.createSection(parent, 458);
        this.section.setText(Messages.javaProfileSection);
        this.section.setDescription(Messages.javaProfileSectionDescription);
        this.section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)this.section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(784));
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)composite, "org.eclipse.libra.framework.ui.teig0000");
        whs.setHelp((Control)this.section, "org.eclipse.libra.framework.ui.teig0000");
        toolkit.paintBordersFor(composite);
        this.section.setClient((Control)composite);
        Label label = this.createLabel(toolkit, composite, Messages.javaProfileSection);
        GridData data = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        String[] envList = IOSGIExecutionEnvironment.getExecutionEnvironmentIds();
        this.javaProfileCombo = SWTFactory.createCombo((Composite)composite, (int)2060, (int)1, (String[])envList);
        this.javaProfileCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaProfileEditorSection.this.frameworkInstance.setJavaProfile(JavaProfileEditorSection.this.javaProfileCombo.getText());
            }
        });
        this.initialize();
    }

    protected Label createLabel(FormToolkit toolkit, Composite parent, String text) {
        Label label = toolkit.createLabel(parent, text);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        return label;
    }

    public void dispose() {
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        if (this.server != null) {
            this.frameworkInstance = (IEquinoxFrameworkInstance)this.server.loadAdapter(IEquinoxFrameworkInstance.class, null);
            this.addChangeListeners();
        }
        this.initialize();
    }

    protected void initialize() {
        if (this.frameworkInstance == null) {
            return;
        }
        this.updating = true;
        this.server.getRuntime();
        String id = this.frameworkInstance.getJavaPofile();
        if (this.javaProfileCombo != null) {
            String[] envList = IOSGIExecutionEnvironment.getExecutionEnvironmentIds();
            int i = 0;
            String[] stringArray = envList;
            int n = envList.length;
            int n2 = 0;
            while (n2 < n) {
                String e = stringArray[n2];
                if (id.equals(e)) {
                    this.javaProfileCombo.select(i);
                    break;
                }
                ++i;
                ++n2;
            }
        }
        this.updating = false;
        this.validate();
    }

    protected void validate() {
        this.setErrorMessage(null);
    }

    protected void handleEdit() {
        try {
            if (this.frameworkInstance != null && this.frameworkInstance.getFrameworkInstanceConfiguration() != null) {
                ITargetDefinition original = this.frameworkInstance.getFrameworkInstanceConfiguration().getTargetDefinition();
                EditTargetDefinitionWizard wizard = new EditTargetDefinitionWizard(original, true);
                wizard.setWindowTitle(Messages.configurationEditorTargetDefinitionTitle);
                WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    ITargetDefinition newTarget = wizard.getTargetDefinition();
                    this.frameworkInstance.getFrameworkInstanceConfiguration().setTargetDefinition(newTarget);
                    ITargetPlatformService service = TargetDefinitionUtil.getTargetPlatformService();
                    service.saveTargetDefinition(newTarget);
                }
            }
        }
        catch (CoreException coreException) {
            Trace.trace((byte)2, (String)"failed to update target platform definition");
        }
    }
}

