/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.plugins.viewbpmn.figures.processes;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jwt.we.editors.preferences.PreferenceReader;
import org.eclipse.swt.graphics.Color;

public class RoundedRectangleBorder
extends LineBorder {
    public RoundedRectangleBorder() {
        super(ColorConstants.black, 3);
    }

    public Dimension getCornerDimensions(IFigure figure) {
        int size = PreferenceReader.appearanceCornerSize.get() * 2;
        return new Dimension(size, size);
    }

    public Insets getInsets(IFigure figure) {
        Dimension corner = this.getCornerDimensions(figure);
        int inset = (int)Math.ceil((double)corner.width * 0.5 - ((double)corner.width * 0.5 - (double)this.getWidth()) / Math.sqrt(2.0));
        return new Insets(inset);
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        tempRect.setBounds(RoundedRectangleBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        if (this.getWidth() % 2 == 1) {
            --RoundedRectangleBorder.tempRect.width;
            --RoundedRectangleBorder.tempRect.height;
        }
        tempRect.shrink(this.getWidth() / 2, this.getWidth() / 2);
        Dimension corner = this.getCornerDimensions(figure);
        graphics.setLineWidth(this.getWidth());
        if (PreferenceReader.appearanceShadowVisible.get()) {
            RoundedRectangleBorder.tempRect.height -= 4;
            RoundedRectangleBorder.tempRect.width -= 4;
            RoundedRectangleBorder.tempRect.x += 2;
            RoundedRectangleBorder.tempRect.y += 2;
            Rectangle shadowRectangle = new Rectangle(tempRect);
            shadowRectangle.x += 3;
            shadowRectangle.y += 3;
            graphics.setAlpha(50);
            graphics.setBackgroundColor(PreferenceReader.appearanceShadowColor.get());
            graphics.fillRoundRectangle(shadowRectangle, corner.width, corner.height);
            graphics.setAlpha(255);
            graphics.setBackgroundColor(figure.getBackgroundColor());
            ++RoundedRectangleBorder.tempRect.width;
            ++RoundedRectangleBorder.tempRect.height;
            graphics.fillRoundRectangle(tempRect, corner.width, corner.height);
            --RoundedRectangleBorder.tempRect.width;
            --RoundedRectangleBorder.tempRect.height;
        }
        graphics.setBackgroundColor(new Color(null, 70, 130, 180));
        graphics.setForegroundColor(new Color(null, 0, 0, 0));
        graphics.fillRoundRectangle(tempRect, corner.width, corner.height);
        graphics.setBackgroundColor(PreferenceReader.appearanceBorderColor.get());
        graphics.drawRoundRectangle(tempRect, corner.width, corner.height);
    }
}

