/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.functions;

import java.util.Date;
import org.apache.commons.lang.time.DateUtils;
import org.eclipse.jubula.client.core.functions.AbstractFunctionEvaluator;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;

public final class ModifyDateEvaluator
extends AbstractFunctionEvaluator {
    public String evaluate(String[] arguments) throws InvalidDataException {
        this.validateParamCount(arguments, 2);
        try {
            long dateTime = Long.parseLong(arguments[0]);
            if (dateTime < 0L) {
                throw new InvalidDataException("value to small: " + dateTime, MessageIDs.E_TOO_SMALL_VALUE);
            }
            String opString = arguments[1];
            int opStringLength = opString.length();
            if (opStringLength < 2) {
                throw new InvalidDataException("illegal value: " + opString, MessageIDs.E_WRONG_PARAMETER_VALUE);
            }
            String op = opString.substring(opStringLength - 1, opStringLength);
            String offsetString = opString.substring(0, opStringLength - 1);
            try {
                int offset = Integer.parseInt(offsetString);
                Date date = new Date(dateTime);
                Date result = null;
                if (op.equalsIgnoreCase("d")) {
                    result = DateUtils.addDays((Date)date, (int)offset);
                } else if (op.equalsIgnoreCase("m")) {
                    result = DateUtils.addMonths((Date)date, (int)offset);
                } else if (op.equalsIgnoreCase("y")) {
                    result = DateUtils.addYears((Date)date, (int)offset);
                } else if (op.equalsIgnoreCase("h")) {
                    result = DateUtils.addHours((Date)date, (int)offset);
                } else if (op.equalsIgnoreCase("i")) {
                    result = DateUtils.addMinutes((Date)date, (int)offset);
                } else if (op.equalsIgnoreCase("s")) {
                    result = DateUtils.addSeconds((Date)date, (int)offset);
                } else if (op.equalsIgnoreCase("j")) {
                    result = DateUtils.addMilliseconds((Date)date, (int)offset);
                } else {
                    throw new InvalidDataException("illegal offset format: " + arguments[1], MessageIDs.E_WRONG_PARAMETER_VALUE);
                }
                return String.valueOf(result.getTime());
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidDataException("illegal offset format: " + arguments[1], MessageIDs.E_WRONG_PARAMETER_VALUE);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidDataException("not an integer: " + arguments[0], MessageIDs.E_BAD_INT);
        }
    }
}

