/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.widget.utils;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.table.ui.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DialogUtils {
    private DialogUtils() {
    }

    public static void openErrorDialogWithLogStatus(List<IStatus> statusList) {
        if (!statusList.isEmpty()) {
            Status[] status = new Status[statusList.size()];
            statusList.toArray(status);
            MultiStatus globalStatus = new MultiStatus(Activator.getDefault().getBundle().getSymbolicName(), 4, (IStatus[])status, "An exception has occurred while retrieving structural features of the eObjects", (Throwable)new Exception());
            Logger.logError((Throwable)new CoreException((IStatus)globalStatus), (Plugin)Activator.getDefault());
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.TableUtils_FailToLoadFacetsShortMsg, (String)Messages.TableUtils_FailToLoadFacetsLongMsg);
        }
    }

    public static void logAndDisplayException(Exception exc, Shell shell) {
        Logger.logError((Throwable)exc, (Plugin)Activator.getDefault());
        MessageDialog.openError((Shell)shell, (String)Messages.NatTableWidget_error, (String)exc.getLocalizedMessage());
    }
}

