/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir;

import java.util.Collections;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPrinter;

public class IrService
extends IrNode {
    private final String serviceRefText;
    private final boolean silent;
    private final IrBGP bgp;

    public IrService(String serviceRefText, boolean silent, IrBGP bgp, boolean newScope) {
        super(newScope);
        this.serviceRefText = serviceRefText;
        this.silent = silent;
        this.bgp = bgp;
    }

    public String getServiceRefText() {
        return this.serviceRefText;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public IrBGP getWhere() {
        return this.bgp;
    }

    @Override
    public void print(IrPrinter p) {
        p.startLine();
        p.append("SERVICE ");
        if (this.silent) {
            p.append("SILENT ");
        }
        p.append(this.serviceRefText);
        p.append(" ");
        this.bgp.print(p);
    }

    @Override
    public IrNode transformChildren(UnaryOperator<IrNode> op) {
        IrBGP newWhere = this.bgp;
        if (newWhere != null) {
            IrNode t = (IrNode)op.apply(newWhere);
            if ((t = t.transformChildren(op)) instanceof IrBGP) {
                newWhere = (IrBGP)t;
            }
        }
        return new IrService(this.serviceRefText, this.silent, newWhere, this.isNewScope());
    }

    @Override
    public Set<Var> getVars() {
        return this.bgp == null ? Collections.emptySet() : this.bgp.getVars();
    }
}

