/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.values;

import java.util.List;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryValueEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtil;

public final class ListMemberValueOperationStep
implements QueryValueEvaluationStep {
    private final List<QueryValueEvaluationStep> compiledArgs;

    public ListMemberValueOperationStep(List<QueryValueEvaluationStep> compiledArgs) {
        this.compiledArgs = compiledArgs;
    }

    @Override
    public Value evaluate(BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value leftValue = this.compiledArgs.get(0).evaluate(bindings);
        boolean result = false;
        ValueExprEvaluationException typeError = null;
        for (int i = 1; i < this.compiledArgs.size(); ++i) {
            QueryValueEvaluationStep arg = this.compiledArgs.get(i);
            try {
                Value rightValue = arg.evaluate(bindings);
                boolean bl = result = leftValue == null && rightValue == null;
                if (!result) {
                    result = QueryEvaluationUtil.compare(leftValue, rightValue, Compare.CompareOp.EQ);
                }
                if (!result) continue;
                break;
            }
            catch (ValueExprEvaluationException caught) {
                typeError = caught;
            }
        }
        if (typeError != null && !result) {
            throw typeError;
        }
        return BooleanLiteral.valueOf((boolean)result);
    }
}

