/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.util;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.ConvertingIteration;
import org.eclipse.rdf4j.common.iteration.FilterIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Statements;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;

@Deprecated(since="4.1.0", forRemoval=true)
public class TripleSources {
    private static final ValueFactory vf = SimpleValueFactory.getInstance();

    TripleSources() {
    }

    public static CloseableIteration<Resource> listResources(Resource subj, TripleSource store) throws QueryEvaluationException {
        return new ConvertingIteration<Value, Resource>((CloseableIteration)new FilterIteration<Value>(TripleSources.list(subj, store)){

            @Override
            protected boolean accept(Value v) throws QueryEvaluationException {
                return v instanceof Resource;
            }

            @Override
            protected void handleClose() {
            }
        }){

            @Override
            protected Resource convert(Value v) throws QueryEvaluationException {
                return (Resource)v;
            }
        };
    }

    public static CloseableIteration<Value> list(final Resource subj, final TripleSource store) throws QueryEvaluationException {
        if (subj == null) {
            throw new NullPointerException("RDF list subject cannot be null");
        }
        return new CloseableIteration<Value>(){
            Resource list;
            {
                this.list = subj;
            }

            @Override
            public boolean hasNext() throws QueryEvaluationException {
                return !RDF.NIL.equals(this.list);
            }

            @Override
            public Value next() throws QueryEvaluationException {
                Value v = TripleSources.singleValue(this.list, RDF.FIRST, store);
                if (v == null) {
                    throw new QueryEvaluationException("List missing rdf:first: " + String.valueOf(this.list));
                }
                Resource nextList = (Resource)TripleSources.singleValue(this.list, RDF.REST, store);
                if (nextList == null) {
                    throw new QueryEvaluationException("List missing rdf:rest: " + String.valueOf(this.list));
                }
                this.list = nextList;
                return v;
            }

            @Override
            public void remove() throws QueryEvaluationException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
            }
        };
    }

    public static boolean booleanValue(Resource subj, IRI pred, TripleSource store) throws QueryEvaluationException {
        Value v = TripleSources.singleValue(subj, pred, store);
        if (v == null) {
            return false;
        }
        if (v instanceof Literal) {
            try {
                return ((Literal)v).booleanValue();
            }
            catch (IllegalArgumentException e) {
                throw new QueryEvaluationException("Value for " + String.valueOf(pred) + " must be of datatype " + String.valueOf(XSD.BOOLEAN) + ": " + String.valueOf(subj));
            }
        }
        throw new QueryEvaluationException("Non-literal value for " + String.valueOf(pred) + ": " + String.valueOf(subj));
    }

    public static Value singleValue(Resource subj, IRI pred, TripleSource store) throws QueryEvaluationException {
        Statement stmt = TripleSources.single(subj, pred, null, store);
        return stmt != null ? stmt.getObject() : null;
    }

    public static Statement single(Resource subj, IRI pred, Value obj, TripleSource store) throws QueryEvaluationException {
        Statement stmt;
        try (CloseableIteration<? extends Statement> stmts = store.getStatements(subj, pred, obj, new Resource[0]);){
            if (stmts.hasNext()) {
                stmt = (Statement)stmts.next();
                while (stmts.hasNext()) {
                    Statement nextStmt = (Statement)stmts.next();
                    if (Statements.isSameTriple(stmt, nextStmt)) continue;
                    throw new QueryEvaluationException("Multiple statements for pattern: " + String.valueOf(subj) + " " + String.valueOf(pred) + " " + String.valueOf(obj));
                }
            } else {
                stmt = null;
            }
        }
        return stmt;
    }

    public static CloseableIteration<IRI> getSubjectURIs(IRI predicate, Value object, TripleSource store) throws QueryEvaluationException {
        return new ConvertingIteration<Statement, IRI>((CloseableIteration)new FilterIteration<Statement>(store.getStatements(null, predicate, object, new Resource[0])){

            @Override
            protected boolean accept(Statement stmt) throws QueryEvaluationException {
                return stmt.getSubject() instanceof IRI;
            }

            @Override
            protected void handleClose() {
            }
        }){

            @Override
            protected IRI convert(Statement stmt) throws QueryEvaluationException {
                return (IRI)stmt.getSubject();
            }
        };
    }

    public static CloseableIteration<Resource> getObjectResources(Resource subject, IRI predicate, TripleSource store) throws QueryEvaluationException {
        return new ConvertingIteration<Statement, Resource>((CloseableIteration)new FilterIteration<Statement>(store.getStatements(subject, predicate, null, new Resource[0])){

            @Override
            protected boolean accept(Statement stmt) throws QueryEvaluationException {
                return stmt.getObject() instanceof Resource;
            }

            @Override
            protected void handleClose() {
            }
        }){

            @Override
            protected Resource convert(Statement stmt) throws QueryEvaluationException {
                return (Resource)stmt.getObject();
            }
        };
    }

    public static CloseableIteration<IRI> getObjectURIs(Resource subject, IRI predicate, TripleSource store) throws QueryEvaluationException {
        return new ConvertingIteration<Statement, IRI>((CloseableIteration)new FilterIteration<Statement>(store.getStatements(subject, predicate, null, new Resource[0])){

            @Override
            protected boolean accept(Statement stmt) throws QueryEvaluationException {
                return stmt.getObject() instanceof IRI;
            }

            @Override
            protected void handleClose() {
            }
        }){

            @Override
            protected IRI convert(Statement stmt) throws QueryEvaluationException {
                return (IRI)stmt.getObject();
            }
        };
    }

    public static CloseableIteration<Literal> getObjectLiterals(Resource subject, IRI predicate, TripleSource store) throws QueryEvaluationException {
        return new ConvertingIteration<Statement, Literal>((CloseableIteration)new FilterIteration<Statement>(store.getStatements(subject, predicate, null, new Resource[0])){

            @Override
            protected boolean accept(Statement stmt) throws QueryEvaluationException {
                return stmt.getObject() instanceof Literal;
            }

            @Override
            protected void handleClose() {
            }
        }){

            @Override
            protected Literal convert(Statement stmt) throws QueryEvaluationException {
                return (Literal)stmt.getObject();
            }
        };
    }
}

