/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Formatter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;

public class FilterByPredicate
implements PlanNode {
    private final SailConnection connection;
    private final Set<IRI> filterOnPredicates;
    final PlanNode parent;
    private final On on;
    private final ConnectionsGroup connectionsGroup;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;
    private final Resource[] dataGraph;

    public FilterByPredicate(SailConnection connection, Set<IRI> filterOnPredicates, PlanNode parent, On on, Resource[] dataGraph, ConnectionsGroup connectionsGroup) {
        this.dataGraph = dataGraph;
        this.parent = PlanNodeHelper.handleSorting(this, parent, connectionsGroup);
        this.connection = connection;
        assert (this.connection != null);
        this.filterOnPredicates = filterOnPredicates;
        this.on = on;
        this.connectionsGroup = connectionsGroup;
    }

    @Override
    public CloseableIteration<? extends ValidationTuple> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            ValidationTuple next;
            private CloseableIteration<? extends ValidationTuple> parentIterator;
            List<IRI> filterOnPredicates;
            {
                this.next = null;
                this.filterOnPredicates = null;
            }

            @Override
            protected void init() {
                this.parentIterator = FilterByPredicate.this.parent.iterator();
            }

            void calculateNext() {
                if (Thread.currentThread().isInterrupted()) {
                    this.close();
                    return;
                }
                if (this.filterOnPredicates == null) {
                    if (!this.parentIterator.hasNext()) {
                        return;
                    }
                    this.filterOnPredicates = FilterByPredicate.this.filterOnPredicates.stream().map(iri -> FilterByPredicate.this.connectionsGroup.getSailSpecificValue(iri, ConnectionsGroup.StatementPosition.predicate, FilterByPredicate.this.connection)).collect(Collectors.toList());
                }
                if (this.filterOnPredicates.isEmpty()) {
                    return;
                }
                while (this.next == null && this.parentIterator.hasNext()) {
                    if (Thread.currentThread().isInterrupted()) {
                        this.close();
                        return;
                    }
                    ValidationTuple temp = (ValidationTuple)this.parentIterator.next();
                    Value subject = temp.getActiveTarget();
                    IRI matchedPredicate = this.matchesFilter(subject);
                    if (matchedPredicate == null) continue;
                    this.next = temp;
                }
            }

            private IRI matchesFilter(Value node) {
                if (node.isResource() && FilterByPredicate.this.on == On.Subject) {
                    return this.filterOnPredicates.stream().filter(predicate -> FilterByPredicate.this.connection.hasStatement((Resource)node, (IRI)predicate, null, true, FilterByPredicate.this.dataGraph)).findFirst().orElse(null);
                }
                if (FilterByPredicate.this.on == On.Object) {
                    return this.filterOnPredicates.stream().filter(predicate -> FilterByPredicate.this.connection.hasStatement(null, (IRI)predicate, node, true, FilterByPredicate.this.dataGraph)).findFirst().orElse(null);
                }
                return null;
            }

            @Override
            public void localClose() {
                if (this.parentIterator != null) {
                    this.parentIterator.close();
                }
            }

            @Override
            protected boolean localHasNext() {
                this.calculateNext();
                return this.next != null;
            }

            @Override
            protected ValidationTuple loggingNext() {
                this.calculateNext();
                ValidationTuple temp = this.next;
                this.next = null;
                return temp;
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.parent.getId() + " -> " + this.getId()).append("\n");
        stringBuilder.append(System.identityHashCode(this.connection) + " -> " + this.getId() + " [label=\"filter source\"]").append("\n");
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    public String toString() {
        return "FilterByPredicate{filterOnPredicates=" + Formatter.prefix(this.filterOnPredicates) + "}";
    }

    @Override
    public String getId() {
        return "" + System.identityHashCode(this);
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parent.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return this.parent.producesSorted();
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterByPredicate that = (FilterByPredicate)o;
        if (this.connection instanceof MemoryStoreConnection && that.connection instanceof MemoryStoreConnection) {
            return ((MemoryStoreConnection)this.connection).getSail().equals(((MemoryStoreConnection)that.connection).getSail()) && Arrays.equals(this.dataGraph, that.dataGraph) && this.filterOnPredicates.equals(that.filterOnPredicates) && this.parent.equals(that.parent) && this.on == that.on;
        }
        return Objects.equals(this.connection, that.connection) && this.filterOnPredicates.equals(that.filterOnPredicates) && Arrays.equals(this.dataGraph, that.dataGraph) && this.parent.equals(that.parent) && this.on == that.on;
    }

    public int hashCode() {
        if (this.connection instanceof MemoryStoreConnection) {
            return Objects.hash(new Object[]{((MemoryStoreConnection)this.connection).getSail(), this.filterOnPredicates, Arrays.hashCode(this.dataGraph), this.parent, this.on});
        }
        return Objects.hash(new Object[]{this.connection, this.filterOnPredicates, Arrays.hashCode(this.dataGraph), this.parent, this.on});
    }

    public static enum On {
        Subject,
        Object;

    }
}

