/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.core.IModelProviderListener;

public abstract class AbstractModelManager {
    private final ListenerList<IModelProviderListener> fListeners = new ListenerList();

    public synchronized void removeModelProviderListener(IModelProviderListener listener) {
        if (listener != null) {
            this.fListeners.remove((Object)listener);
        }
    }

    public synchronized void addModelProviderListener(IModelProviderListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void fireModelProviderEvent(IModelProviderEvent event) {
        for (IModelProviderListener listener : this.fListeners) {
            listener.modelsChanged(event);
        }
    }

    public void shutdown() {
        this.removeListeners();
    }

    protected void removeListeners() {
        this.fListeners.clear();
    }
}

