/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.breakpoints;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;

public final class LambdaLocationLocatorHelper {
    private LambdaLocationLocatorHelper() {
    }

    public static String toMethodSignature(IMethodBinding methodBinding) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        if (methodBinding.getParameterTypes().length > 0 || methodBinding.getSyntheticOuterLocals().length > 0) {
            builder.append(Stream.of(methodBinding.getSyntheticOuterLocals()).map(b -> Signature.createTypeSignature((String)LambdaLocationLocatorHelper.qualifiedName(b.getType()), (boolean)true)).collect(Collectors.joining()));
            builder.append(Stream.of(methodBinding.getParameterTypes()).map(b -> Signature.createTypeSignature((String)LambdaLocationLocatorHelper.qualifiedName(b), (boolean)true)).collect(Collectors.joining()));
        }
        builder.append(')');
        builder.append(Signature.createTypeSignature((String)LambdaLocationLocatorHelper.qualifiedName(methodBinding.getReturnType()), (boolean)true));
        return builder.toString();
    }

    public static String toMethodName(IMethodBinding methodBinding) {
        String key = methodBinding.getKey();
        return key.substring(key.indexOf(46) + 1, key.indexOf(40));
    }

    private static String qualifiedName(ITypeBinding binding) {
        return binding.getQualifiedName().replace('.', '/');
    }
}

