/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.aut;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;
import org.eclipse.rcptt.launching.ILaunchValidator;

public class Q7LaunchValidatorManager {
    private static List<ILaunchValidator> validators = null;

    public static boolean isValid(ILaunchConfiguration config) {
        Q7LaunchValidatorManager.initialize();
        for (ILaunchValidator validator : validators) {
            if (validator.isLaunchValid(config)) continue;
            return false;
        }
        return true;
    }

    private static synchronized void initialize() {
        if (validators == null) {
            validators = new ArrayList<ILaunchValidator>();
            IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.rcptt.launching.launchValidator");
            if (extension != null) {
                IConfigurationElement[] elements;
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                    try {
                        ILaunchValidator validator = (ILaunchValidator)iConfigurationElement.createExecutableExtension("class");
                        validators.add(validator);
                    }
                    catch (Throwable e) {
                        Q7LaunchingPlugin.log(e);
                    }
                    ++n2;
                }
            }
        }
    }
}

