/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.debug.ui;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.InstructionPointerAnnotation;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugEditorPresentation;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.rcptt.ecl.debug.model.VariableKind;
import org.eclipse.rcptt.ecl.debug.ui.EclActiveCommandAnnotation;
import org.eclipse.rcptt.ecl.debug.ui.EclDebugUIPlugin;
import org.eclipse.rcptt.ecl.debug.ui.Images;
import org.eclipse.rcptt.ecl.internal.debug.core.EclVariable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class EclModelPresentation
extends LabelProvider
implements IDebugModelPresentation,
IDebugEditorPresentation {
    private static final String ECL_ACTIVE_CMD_ANNOTATION = "org.eclipse.rcptt.ecl.debug.ui.activeCommand";

    public String getText(Object element) {
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof EclVariable) {
            EclVariable var = (EclVariable)element;
            VariableKind kind = var.getVariableKind();
            switch (kind) {
                case ARGUMENT: {
                    return Images.getImage("icons/localvariable_obj.gif");
                }
                case COMMAND: {
                    return Images.getImage("icons/object_icon.gif");
                }
                case OBJECT: {
                    return Images.getImage("icons/object_icon.gif");
                }
                case VARIABLE: {
                    return Images.getImage("icons/field_public_obj.gif");
                }
                case REFERENCE: {
                    return Images.getImage("icons/object_icon.gif");
                }
                case FIELD: {
                    return Images.getImage("icons/field_protected_obj.gif");
                }
                case LOCAL: {
                    return Images.getImage("icons/localvariable_obj.gif");
                }
            }
        }
        return null;
    }

    public void setAttribute(String attribute, Object value) {
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        String detail = "";
        try {
            detail = value.getValueString();
            if (detail == null) {
                detail = "";
            }
        }
        catch (DebugException debugException) {}
        listener.detailComputed(value, detail);
    }

    public IEditorInput getEditorInput(Object element) {
        if (element instanceof IFile) {
            return new FileEditorInput((IFile)element);
        }
        if (element instanceof ILineBreakpoint) {
            return new FileEditorInput((IFile)((ILineBreakpoint)element).getMarker().getResource());
        }
        return null;
    }

    public String getEditorId(IEditorInput input, Object element) {
        IFile file;
        IResource resource;
        if (element instanceof IFile) {
            return this.getDefaultEditor((IFile)element);
        }
        if (element instanceof ILineBreakpoint && (resource = ((ILineBreakpoint)element).getMarker().getResource()) instanceof IFile) {
            return this.getDefaultEditor((IFile)resource);
        }
        if (input instanceof FileEditorInput && (file = ((FileEditorInput)input).getFile()) != null) {
            return this.getDefaultEditor(file);
        }
        return null;
    }

    private String getDefaultEditor(IFile resource) {
        IEditorDescriptor descriptor = IDE.getDefaultEditor((IFile)resource);
        if (descriptor != null) {
            return descriptor.getId();
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }

    public boolean addAnnotations(IEditorPart editorPart, IStackFrame frame) {
        IAnnotationModel model;
        if (frame.isTerminated()) {
            return false;
        }
        ISourceViewer viewer = this.getViewer(editorPart);
        if (viewer != null && (model = viewer.getAnnotationModel()) != null) {
            this.removeDebugAnnotations(model);
            try {
                IDocument document = viewer.getDocument();
                IRegion region = document.getLineInformation(frame.getLineNumber() - 1);
                int offset = region.getOffset();
                int length = region.getLength();
                Annotation annotation = EclModelPresentation.getInstructionPointerAnnotation(frame);
                model.addAnnotation(annotation, new Position(offset, length));
                EclActiveCommandAnnotation cmd = new EclActiveCommandAnnotation(frame, ECL_ACTIVE_CMD_ANNOTATION, frame.getName());
                model.addAnnotation((Annotation)cmd, new Position(region.getOffset() + frame.getCharStart() - 1, frame.getCharEnd()));
                viewer.revealRange(offset, length);
                return true;
            }
            catch (Exception e) {
                EclDebugUIPlugin.log(e);
                return false;
            }
        }
        return false;
    }

    private static Annotation getInstructionPointerAnnotation(IStackFrame frame) {
        String id = null;
        Image image = null;
        String text = null;
        IThread thread = frame.getThread();
        IStackFrame tos = null;
        boolean top = false;
        try {
            tos = thread.getTopStackFrame();
            top = frame.equals(tos);
        }
        catch (DebugException debugException) {}
        id = top ? "org.eclipse.debug.ui.currentIP" : "org.eclipse.debug.ui.secondaryIP";
        text = top ? DebugUIMessages.InstructionPointerAnnotation_0 : DebugUIMessages.InstructionPointerAnnotation_1;
        image = top ? DebugUITools.getImage((String)"IMG_OBJS_INSTRUCTION_POINTER_TOP") : DebugUITools.getImage((String)"IMG_OBJS_INSTRUCTION_POINTER");
        return new InstructionPointerAnnotation(frame, id, text, image);
    }

    public void removeAnnotations(IEditorPart editorPart, IThread thread) {
        IAnnotationModel model;
        ISourceViewer viewer = this.getViewer(editorPart);
        if (viewer != null && (model = viewer.getAnnotationModel()) != null) {
            this.removeDebugAnnotations(model);
        }
    }

    private void removeDebugAnnotations(IAnnotationModel model) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        Iterator it = model.getAnnotationIterator();
        while (it.hasNext()) {
            Annotation annotation = (Annotation)it.next();
            if ("org.eclipse.debug.ui.currentIP".equals(annotation.getType())) {
                annotations.add(annotation);
            }
            if ("org.eclipse.debug.ui.secondaryIP".equals(annotation.getType())) {
                annotations.add(annotation);
            }
            if (!ECL_ACTIVE_CMD_ANNOTATION.equals(annotation.getType())) continue;
            annotations.add(annotation);
        }
        for (Annotation annotation : annotations) {
            model.removeAnnotation(annotation);
        }
    }

    private ISourceViewer getViewer(IEditorPart part) {
        return (ISourceViewer)part.getAdapter(ISourceViewer.class);
    }
}

