/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.operations.internal.commands;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.operations.ParseTime;
import org.eclipse.rcptt.ecl.operations.internal.OperationsPlugin;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;

public class ParseTimeService
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        if (!(command instanceof ParseTime)) {
            return Status.CANCEL_STATUS;
        }
        ParseTime parseCommand = (ParseTime)command;
        String format = parseCommand.getFormat();
        String strValue = parseCommand.getInput();
        if (strValue == null) {
            return OperationsPlugin.createErr("Mandatory input is missing", new Object[0]);
        }
        Date parsed = new SimpleDateFormat(format).parse(strValue, new ParsePosition(0));
        if (parsed == null) {
            return OperationsPlugin.createErr("Failed to parse date: " + strValue + " of format: " + format, new Object[0]);
        }
        context.getOutput().write((Object)parsed.getTime());
        return Status.OK_STATUS;
    }
}

