/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.launching;

import java.util.List;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.launching.IExecutable;
import org.eclipse.rcptt.launching.IExecutionSession;
import org.eclipse.rcptt.launching.ILaunchListener;
import org.eclipse.rcptt.ui.launching.ExecutionView;
import org.eclipse.rcptt.ui.utils.WorkbenchUtils;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class LaunchListener
implements ILaunchListener {
    public void started(final IExecutionSession session) {
        if (PlatformUI.isWorkbenchRunning()) {
            this.exec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List<ExecutionView> views;
                    List<ExecutionView> list = views = ExecutionView.views;
                    synchronized (list) {
                        LaunchListener.this.showActivateView(views);
                        for (ExecutionView ew : views) {
                            ew.setInput(session);
                        }
                    }
                }
            });
        }
    }

    public void finished() {
        if (PlatformUI.isWorkbenchRunning()) {
            this.exec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List<ExecutionView> views;
                    List<ExecutionView> list = views = ExecutionView.views;
                    synchronized (list) {
                        for (ExecutionView ew : views) {
                            ew.finished();
                        }
                    }
                }
            });
        }
    }

    public void launchStatusChanged(final IExecutable ... executable) {
        if (PlatformUI.isWorkbenchRunning()) {
            this.exec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List<ExecutionView> views;
                    List<ExecutionView> list = views = ExecutionView.views;
                    synchronized (list) {
                        for (ExecutionView ew : views) {
                            ew.update(executable);
                        }
                    }
                }
            });
        }
    }

    private void exec(Runnable runnable) {
        WorkbenchUtils.uiRun(runnable);
    }

    private void showActivateView(List<ExecutionView> views) {
        if (views.size() == 0) {
            try {
                IWorkbenchPage page;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null && (page = window.getActivePage()) != null) {
                    page.showView("org.eclipse.rcptt.ui.views.execution");
                }
            }
            catch (PartInitException e) {
                Q7UIPlugin.log(e);
            }
        }
    }
}

