/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.cocoa.NSMenuItem;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTMenu;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;

public class MenuItem
extends Item {
    NSMenuItem nsItem;
    Menu parent;
    Menu menu;
    int accelerator;
    long nsItemAction;
    id nsItemTarget;
    String toolTipText;

    public MenuItem(Menu parent, int style) {
        super(parent, MenuItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
    }

    public MenuItem(Menu parent, int style, int index) {
        super(parent, MenuItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, index);
    }

    MenuItem(Menu parent, NSMenuItem nsMenuItem) {
        super(parent, 0);
        this.parent = parent;
        this.nsItem = nsMenuItem;
        parent.createItem(this, parent.getItemCount());
    }

    public void addArmListener(ArmListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(30, typedListener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int style) {
        return MenuItem.checkBits(style, 8, 32, 16, 2, 64, 0);
    }

    NSMenu createEmptyMenu() {
        if ((this.parent.style & 2) != 0) {
            return (NSMenu)new SWTMenu().alloc().init();
        }
        return null;
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(this.nsItem);
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public int getAccelerator() {
        this.checkWidget();
        return this.accelerator;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public int getID() {
        this.checkWidget();
        return (int)this.nsItem.tag();
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    @Override
    String getNameText() {
        if ((this.style & 2) != 0) {
            return "|";
        }
        return super.getNameText();
    }

    public Menu getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        return this.nsItem.state() == 1L;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean isEnabled() {
        return this.getEnabled() && this.parent.isEnabled();
    }

    int keyChar(int key) {
        switch (key) {
            case 8: {
                return 8;
            }
            case 13: {
                return 13;
            }
            case 127: {
                return 127;
            }
            case 27: {
                return 27;
            }
            case 10: {
                return 10;
            }
            case 9: {
                return 9;
            }
            case 65536: {
                return 8997;
            }
            case 131072: {
                return 8679;
            }
            case 262144: {
                return 992003;
            }
            case 0x400000: {
                return 8984;
            }
            case 0x1000001: {
                return 8593;
            }
            case 0x1000002: {
                return 8595;
            }
            case 0x1000003: {
                return 8592;
            }
            case 0x1000004: {
                return 8594;
            }
            case 0x1000005: {
                return 8670;
            }
            case 0x1000006: {
                return 8671;
            }
            case 0x1000050: {
                return 3;
            }
            case 0x1000051: {
                return 63302;
            }
            case 0x1000007: {
                return 63273;
            }
            case 0x1000008: {
                return 63275;
            }
            case 0x100000A: {
                return 63236;
            }
            case 0x100000B: {
                return 63237;
            }
            case 0x100000C: {
                return 63238;
            }
            case 0x100000D: {
                return 63239;
            }
            case 0x100000E: {
                return 63240;
            }
            case 0x100000F: {
                return 63241;
            }
            case 0x1000010: {
                return 63242;
            }
            case 0x1000011: {
                return 63243;
            }
            case 0x1000012: {
                return 63244;
            }
            case 0x1000013: {
                return 63245;
            }
            case 0x1000014: {
                return 63246;
            }
            case 0x1000015: {
                return 63247;
            }
            case 0x1000016: {
                return 63248;
            }
            case 0x1000017: {
                return 63249;
            }
            case 0x1000018: {
                return 63250;
            }
        }
        return 0;
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(this.nsItem, this);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        if (this.nsItem != null) {
            this.nsItem.release();
        }
        this.nsItem = null;
        this.parent = null;
    }

    @Override
    void releaseChildren(boolean destroy) {
        if (this.menu != null) {
            this.menu.release(false);
            this.menu = null;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.accelerator = 0;
        if (this == this.parent.defaultItem) {
            this.parent.defaultItem = null;
        }
    }

    public void removeArmListener(ArmListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(30, listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    @Override
    void reskinChildren(int flags) {
        if (this.menu != null) {
            this.menu.reskin(flags);
        }
        super.reskinChildren(flags);
    }

    void selectRadio() {
        int index = 0;
        MenuItem[] items = this.parent.getItems();
        while (index < items.length && items[index] != this) {
            ++index;
        }
        int i = index - 1;
        while (i >= 0 && items[i].setRadioSelection(false)) {
            --i;
        }
        int j = index + 1;
        while (j < items.length && items[j].setRadioSelection(false)) {
            ++j;
        }
        this.setSelection(true);
    }

    @Override
    void sendSelection() {
        if ((this.style & 0x20) != 0) {
            this.setSelection(!this.getSelection());
        } else if ((this.style & 0x10) != 0) {
            if ((this.parent.getStyle() & 0x400000) != 0) {
                this.setSelection(!this.getSelection());
            } else {
                this.selectRadio();
            }
        }
        Event event = new Event();
        this.sendSelectionEvent(13, event, this.nsItemAction != 0L);
        if (this.isDisposed()) {
            return;
        }
        if (this.nsItemAction != 0L && event.doit) {
            NSApplication app = NSApplication.sharedApplication();
            app.sendAction(this.nsItemAction, this.nsItemTarget, app);
        }
    }

    public void setAccelerator(int accelerator) {
        int virtualKey;
        this.checkWidget();
        if (this.accelerator == accelerator) {
            return;
        }
        this.accelerator = accelerator;
        int key = accelerator & 0x100FFFF;
        if (key == 27 && key == accelerator && !this.display.escAsAcceleratorPresent) {
            this.display.escAsAcceleratorPresent = true;
        }
        String string = (virtualKey = this.keyChar(key)) != 0 ? "" + (char)virtualKey : "" + (char)key;
        NSString nsstring = (NSString)new NSString().alloc();
        nsstring = nsstring.initWithString(string);
        this.nsItem.setKeyEquivalent(nsstring.lowercaseString());
        nsstring.release();
        int mask = 0;
        if ((accelerator & 0x20000) != 0) {
            mask |= 0x20000;
        }
        if ((accelerator & 0x40000) != 0) {
            mask |= 0x40000;
        }
        if ((accelerator & 0x400000) != 0) {
            mask |= 0x100000;
        }
        if ((accelerator & 0x10000) != 0) {
            mask |= 0x80000;
        }
        this.nsItem.setKeyEquivalentModifierMask(mask);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        this.state = enabled ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
        this.nsItem.setEnabled(enabled);
    }

    public void setID(int id2) {
        this.checkWidget();
        if (id2 < 0) {
            this.error(5);
        }
        this.nsItem.setTag(id2);
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        if (this.image == image) {
            return;
        }
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        this.nsItem.setImage(image != null ? image.handle : null);
    }

    public void setMenu(Menu menu) {
        Menu oldMenu;
        this.checkWidget();
        if ((this.style & 0x40) == 0) {
            this.error(27);
        }
        if (menu != null) {
            if (menu.isDisposed() || menu == this.parent) {
                this.error(5);
            }
            if ((menu.style & 4) == 0) {
                this.error(21);
            }
            if (this.parent.parent != null && menu.parent != this.parent.parent) {
                this.error(32);
            }
        }
        if ((oldMenu = this.menu) == menu) {
            return;
        }
        if (oldMenu != null) {
            oldMenu.cascade = null;
        }
        this.menu = menu;
        if (menu == null) {
            NSMenu emptyMenu = this.createEmptyMenu();
            if (emptyMenu != null) {
                this.nsItem.setSubmenu(emptyMenu);
                emptyMenu.release();
            }
        } else {
            menu.cascade = this;
            this.nsItem.setSubmenu(menu.nsMenu);
        }
        if (menu != null) {
            this.nsItem.setTarget(null);
            this.nsItem.setAction(0L);
        } else {
            this.nsItem.setTarget(this.nsItem);
            this.nsItem.setAction(OS.sel_sendSelection);
        }
        this.updateText();
    }

    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        this.nsItem.setState(selected ? 1 : 0);
    }

    @Override
    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.text.equals(string)) {
            return;
        }
        super.setText(string);
        this.updateText();
    }

    public void setToolTipText(String toolTip) {
        this.checkWidget();
        if (toolTip == null && this.toolTipText != null) {
            this.toolTipText = null;
            this.nsItem.setToolTip(null);
        }
        if (toolTip == null || toolTip.trim().length() == 0 || toolTip.equals(this.toolTipText)) {
            return;
        }
        this.toolTipText = toolTip;
        char[] chars = new char[this.toolTipText.length()];
        this.toolTipText.getChars(0, chars.length, chars, 0);
        int length = this.fixMnemonic(chars);
        this.nsItem.setToolTip(NSString.stringWithCharacters(chars, length));
    }

    void updateText() {
        if (this.isDisposed() || this.parent.isDisposed()) {
            return;
        }
        char[] buffer = new char[this.text.length()];
        this.text.getChars(0, buffer.length, buffer, 0);
        int i = 0;
        int j = 0;
        while (i < buffer.length) {
            if (buffer[i] == '\t') break;
            if ((buffer[j++] = buffer[i++]) != '&' || i == buffer.length) continue;
            if (buffer[i] == '&') {
                ++i;
                continue;
            }
            --j;
        }
        String text = new String(buffer, 0, j);
        NSMenu submenu = this.nsItem.submenu();
        NSString label = (NSString)new NSString().alloc();
        label = label.initWithString(text);
        if (submenu != null && (this.parent.getStyle() & 2) != 0) {
            submenu.setTitle(label);
        } else {
            int direction = (this.parent.getStyle() & 0x4000000) != 0 ? 1 : 0;
            NSMutableDictionary dict = ((NSMutableDictionary)new NSMutableDictionary().alloc()).initWithCapacity(2L);
            NSMutableParagraphStyle paragraphStyle = (NSMutableParagraphStyle)new NSMutableParagraphStyle().alloc().init();
            paragraphStyle.setBaseWritingDirection(direction);
            paragraphStyle.setLineBreakMode(5L);
            dict.setObject(paragraphStyle, OS.NSParagraphStyleAttributeName);
            paragraphStyle.release();
            dict.setObject(NSFont.menuBarFontOfSize(0.0), OS.NSFontAttributeName);
            NSAttributedString attribStr = ((NSAttributedString)new NSAttributedString().alloc()).initWithString(label, dict);
            dict.release();
            this.nsItem.setAttributedTitle(attribStr);
            if (text.length() == 0) {
                this.nsItem.setTitle(NSString.string());
            }
            attribStr.release();
        }
        label.release();
    }

    boolean updateAccelerator(boolean show) {
        if (this.accelerator != 0) {
            return false;
        }
        int mask = 0;
        int key = 0;
        if (show) {
            char[] buffer = new char[this.text.length()];
            this.text.getChars(0, buffer.length, buffer, 0);
            int i = 0;
            int j = 0;
            while (i < buffer.length) {
                if (buffer[i] == '\t') break;
                if ((buffer[j++] = buffer[i++]) != '&' || i == buffer.length) continue;
                if (buffer[i] == '&') {
                    ++i;
                    continue;
                }
                --j;
            }
            if (i < buffer.length && buffer[i] == '\t') {
                j = i + 1;
                while (j < buffer.length) {
                    switch (buffer[j]) {
                        case '\u2303': {
                            mask |= 0x40000;
                            ++i;
                            break;
                        }
                        case '\u2325': {
                            mask |= 0x80000;
                            ++i;
                            break;
                        }
                        case '\u21e7': {
                            mask |= 0x20000;
                            ++i;
                            break;
                        }
                        case '\u2318': {
                            mask |= 0x100000;
                            ++i;
                            break;
                        }
                        default: {
                            j = buffer.length;
                        }
                    }
                    ++j;
                }
                block6 : switch (buffer.length - i - 1) {
                    case 1: {
                        key = buffer[i + 1];
                        if (key != 9251) break;
                        key = 32;
                        break;
                    }
                    case 2: {
                        if (buffer[i + 1] != 'F') break;
                        switch (buffer[i + 2]) {
                            case '1': {
                                key = 63236;
                                break;
                            }
                            case '2': {
                                key = 63237;
                                break;
                            }
                            case '3': {
                                key = 63238;
                                break;
                            }
                            case '4': {
                                key = 63239;
                                break;
                            }
                            case '5': {
                                key = 63240;
                                break;
                            }
                            case '6': {
                                key = 63241;
                                break;
                            }
                            case '7': {
                                key = 63242;
                                break;
                            }
                            case '8': {
                                key = 63243;
                                break;
                            }
                            case '9': {
                                key = 63244;
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (buffer[i + 1] != 'F' || buffer[i + 2] != '1') break;
                        switch (buffer[i + 3]) {
                            case '0': {
                                key = 63245;
                                break block6;
                            }
                            case '1': {
                                key = 63246;
                                break block6;
                            }
                            case '2': {
                                key = 63247;
                                break block6;
                            }
                            case '3': {
                                key = 63248;
                                break block6;
                            }
                            case '4': {
                                key = 63249;
                                break block6;
                            }
                            case '5': {
                                key = 63250;
                            }
                        }
                    }
                }
            }
        }
        this.nsItem.setKeyEquivalentModifierMask(mask);
        NSString nsstring = (NSString)new NSString().alloc();
        nsstring = nsstring.initWithString(key == 0 ? "" : String.valueOf((char)key));
        this.nsItem.setKeyEquivalent(nsstring.lowercaseString());
        nsstring.release();
        return key != 0;
    }
}

