/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.tools.change.BndProjectUpdateChange;
import org.eclipse.pde.internal.ui.wizards.tools.change.BuildToBndChange;
import org.eclipse.pde.internal.ui.wizards.tools.change.CreatePackageInfoChange;
import org.eclipse.pde.internal.ui.wizards.tools.change.ManifestToBndChange;
import org.eclipse.pde.internal.ui.wizards.tools.change.PreferenceChange;
import org.osgi.framework.Version;

public class ConvertAutomaticManifestProcessor
extends RefactoringProcessor {
    private List<IProject> projects;
    private boolean useProjectRoot;
    private boolean keepRequireBundle;
    private boolean keepImportPackage;
    private boolean keepBREE;
    private boolean keepExportPackage;

    public ConvertAutomaticManifestProcessor(List<IProject> projects) {
        this.projects = projects;
    }

    public Object[] getElements() {
        return this.projects.toArray();
    }

    public String getIdentifier() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getProcessorName() {
        return PDEUIMessages.ConvertAutomaticManifestWizardPage_title;
    }

    public boolean isApplicable() {
        return true;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) {
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) {
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange change = new CompositeChange(PDEUIMessages.ConvertAutomaticManifestWizardPage_title);
        change.markAsSynthetic();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)pm, (String)PDEUIMessages.ConvertAutomaticManifestJob_taskName, (int)this.projects.size());
        for (IProject project : this.projects) {
            change.add(this.convertProject(project, (IProgressMonitor)subMonitor.split(1)));
        }
        return change;
    }

    private Change convertProject(IProject project, IProgressMonitor monitor) throws CoreException {
        ExportPackageDescription[] exportPackages;
        CompositeChange change = new CompositeChange(NLS.bind((String)PDEUIMessages.ConvertAutomaticManifestsProcessor_changeProject, (Object)project.getName()));
        SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)PDEUIMessages.ConvertAutomaticManifestsProcessor_rootMessage, (Object)project.getName()), (int)100);
        IFile manifest = PDEProject.getManifest((IProject)project);
        IPluginModelBase model = PluginRegistry.findModel((IProject)project);
        IFile instructionsFile = project.getFile("pde.bnd");
        IBuildModel buildModel = PluginRegistry.createBuildModel((IPluginModelBase)model);
        change.add((Change)new BndProjectUpdateChange(project));
        change.add((Change)new ManifestToBndChange(project, manifest, model, instructionsFile, this.keepRequireBundle, this.keepImportPackage, this.keepBREE, this.keepExportPackage));
        if (!this.keepExportPackage && (exportPackages = model.getBundleDescription().getExportPackages()).length > 0) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            ExportPackageDescription[] exportPackageDescriptionArray = exportPackages;
            int n = exportPackages.length;
            int n2 = 0;
            while (n2 < n) {
                ExportPackageDescription exportPackage = exportPackageDescriptionArray[n2];
                Change packageInfoChange = this.getPackageInfoChange(exportPackage.getName(), exportPackage.getVersion(), javaProject);
                if (packageInfoChange != null) {
                    change.add(packageInfoChange);
                }
                ++n2;
            }
        }
        change.add((Change)new BuildToBndChange(project, buildModel, instructionsFile));
        IFile buildProperties = PDEProject.getBuildProperties((IProject)project);
        if (buildProperties.exists()) {
            change.add((Change)new DeleteResourceChange(buildProperties.getFullPath(), true));
        }
        if (this.useProjectRoot) {
            ProjectScope scope = new ProjectScope(project);
            IEclipsePreferences node = scope.getNode("org.eclipse.pde.core");
            change.add((Change)new PreferenceChange(node));
        } else if (manifest.exists()) {
            change.add((Change)new DeleteResourceChange(manifest.getFullPath(), true));
        }
        return change;
    }

    private Change getPackageInfoChange(String name, Version version, IJavaProject javaProject) throws CoreException {
        IPackageFragment pkg = ConvertAutomaticManifestProcessor.findPackage(javaProject, name);
        if (pkg == null) {
            return null;
        }
        ICompilationUnit cu = pkg.getCompilationUnit("package-info.java");
        if (cu.exists()) {
            return null;
        }
        return new CreatePackageInfoChange(pkg, name, version);
    }

    private static IPackageFragment findPackage(IJavaProject javaProject, String name) throws JavaModelException {
        IPackageFragment[] iPackageFragmentArray = javaProject.getPackageFragments();
        int n = iPackageFragmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragment pkg = iPackageFragmentArray[n2];
            if (pkg.getKind() == 1 && pkg.getElementName().equals(name)) {
                return pkg;
            }
            ++n2;
        }
        return null;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return new RefactoringParticipant[0];
    }

    public void setUseProjectRoot(boolean useProjectRoot) {
        this.useProjectRoot = useProjectRoot;
    }

    public void setKeepRequireBundle(boolean keepRequireBundle) {
        this.keepRequireBundle = keepRequireBundle;
    }

    public void setKeepImportPackage(boolean keepImportPackage) {
        this.keepImportPackage = keepImportPackage;
    }

    public void setKeepRequiredExecutionEnvironment(boolean keepBREE) {
        this.keepBREE = keepBREE;
    }

    public void setKeepExportPackage(boolean keepExportPackage) {
        this.keepExportPackage = keepExportPackage;
    }
}

