/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.testing;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7ElementVisitor;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.internal.core.model.ModelManager;
import org.eclipse.rcptt.testing.TestingPlugin;
import org.eclipse.rcptt.testing.commands.FindContexts;

public class FindContextsService
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        if (!(command instanceof FindContexts)) {
            return Status.CANCEL_STATUS;
        }
        FindContexts cmd = (FindContexts)command;
        String type = cmd.getType();
        ModelManager.getModelManager().getModel().accept((IQ7ElementVisitor)new ElementVisitor(context, type));
        return Status.OK_STATUS;
    }

    private static final class ElementVisitor
    implements IQ7ElementVisitor {
        private final IProcess context;
        private final String type;

        private ElementVisitor(IProcess context, String type) {
            this.context = context;
            this.type = type == null ? "" : type;
        }

        public boolean visit(IQ7Element element) {
            block7: {
                block6: {
                    if (element instanceof IContext) break block6;
                    return true;
                }
                NamedElement ne = ((IQ7NamedElement)element).getNamedElement();
                if (this.type.length() == 0 || ne.eClass().getName().equals(this.type)) break block7;
                return false;
            }
            try {
                try {
                    this.context.getOutput().write((Object)element.getResource().getFullPath().toString());
                }
                catch (CoreException e) {
                    TestingPlugin.logErr(String.format("Error writing to output pipe", new Object[0]), e);
                }
            }
            catch (ModelException e) {
                TestingPlugin.logErr(String.format("Problem loading q7 element: %s", element.getName()), e);
            }
            return true;
        }

        public boolean endVisit(IQ7Element element) {
            return false;
        }
    }
}

