/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.VectorSimilarityValuesSource;

class ByteVectorSimilarityValuesSource
extends VectorSimilarityValuesSource {
    private final byte[] queryVector;

    public ByteVectorSimilarityValuesSource(byte[] vector, String fieldName) {
        super(fieldName);
        this.queryVector = vector;
    }

    @Override
    public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
        final ByteVectorValues vectorValues = ctx.reader().getByteVectorValues(this.fieldName);
        final VectorSimilarityFunction function = ctx.reader().getFieldInfos().fieldInfo(this.fieldName).getVectorSimilarityFunction();
        return new DoubleValues(){

            @Override
            public double doubleValue() throws IOException {
                return function.compare(ByteVectorSimilarityValuesSource.this.queryVector, vectorValues.vectorValue());
            }

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return doc >= vectorValues.docID() && (vectorValues.docID() == doc || vectorValues.advance(doc) == doc);
            }
        };
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fieldName, Arrays.hashCode(this.queryVector));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ByteVectorSimilarityValuesSource other = (ByteVectorSimilarityValuesSource)obj;
        return Objects.equals(this.fieldName, other.fieldName) && Arrays.equals(this.queryVector, other.queryVector);
    }

    @Override
    public String toString() {
        return "ByteVectorSimilarityValuesSource(fieldName=" + this.fieldName + " queryVector=" + Arrays.toString(this.queryVector) + ")";
    }
}

