/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.refactoring.delete;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ITestSuite;
import org.eclipse.rcptt.core.scenario.TestSuiteItem;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.ui.refactoring.delete.AbstractDeleteTestReferenceChange;
import org.eclipse.rcptt.ui.refactoring.delete.DeleteTestReferenceChange;

public class UndoDeleteTestReferenceChange
extends AbstractDeleteTestReferenceChange {
    private final Map<Integer, TestSuiteItem> deletedItems;

    protected UndoDeleteTestReferenceChange(ITestSuite testSuite, IQ7NamedElement q7Element, Map<Integer, TestSuiteItem> deletedItems) {
        super(testSuite, q7Element);
        this.deletedItems = deletedItems;
    }

    public String getName() {
        return Messages.bind((String)Messages.UndoDeleteContextReferenceChange_Name, (Object)this.getQ7Element().getName(), (Object)this.getTestSuite().getName());
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (!this.isValid()) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.UndoDeleteReferenceChange_InvalidRefMsg);
        }
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        try {
            ITestSuite suiteCopy = (ITestSuite)this.getTestSuite().getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            try {
                for (Map.Entry<Integer, TestSuiteItem> entry : this.deletedItems.entrySet()) {
                    suiteCopy.getTestSuite().getItems().add(entry.getKey().intValue(), (Object)entry.getValue());
                }
                suiteCopy.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
            }
            finally {
                suiteCopy.discardWorkingCopy();
            }
            DeleteTestReferenceChange deleteTestReferenceChange = new DeleteTestReferenceChange(this.getTestSuite(), this.getQ7Element());
            return deleteTestReferenceChange;
        }
        finally {
            pm.done();
        }
    }
}

