/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.equinox.requirements;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.requirements.Feature;
import org.eclipse.passage.lic.internal.api.requirements.Requirement;
import org.eclipse.passage.lic.internal.api.restrictions.RestrictionLevel;
import org.eclipse.passage.lic.internal.base.requirements.BaseFeature;
import org.eclipse.passage.lic.internal.base.requirements.BaseRequirement;
import org.eclipse.passage.lic.internal.base.restrictions.DefaultRestrictionLevel;
import org.eclipse.passage.lic.internal.base.version.DefaultVersion;
import org.eclipse.passage.lic.internal.base.version.SafeVersion;
import org.eclipse.passage.lic.internal.equinox.requirements.BundleVendor;
import org.eclipse.passage.lic.internal.equinox.requirements.ComponentLicFeatureId;
import org.eclipse.passage.lic.internal.equinox.requirements.ComponentLicFeatureLevel;
import org.eclipse.passage.lic.internal.equinox.requirements.ComponentLicFeatureName;
import org.eclipse.passage.lic.internal.equinox.requirements.ComponentLicFeatureProvider;
import org.eclipse.passage.lic.internal.equinox.requirements.ComponentLicFeatureVersion;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;

final class RequirementFromComponent
implements Supplier<Optional<Requirement>> {
    private final ComponentDescriptionDTO component;
    private final BundleContext context;

    public RequirementFromComponent(ComponentDescriptionDTO component, BundleContext context) {
        this.component = component;
        this.context = context;
    }

    @Override
    public Optional<Requirement> get() {
        Optional<Map> properties = Optional.ofNullable(this.component.properties);
        if (!properties.isPresent()) {
            return Optional.empty();
        }
        Optional feature = new ComponentLicFeatureId(properties.get()).get();
        if (!feature.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(this.requirementFromProperties((String)feature.get(), properties.get()));
    }

    private Requirement requirementFromProperties(String feature, Map<String, Object> properties) {
        String version = new ComponentLicFeatureVersion(properties).get().map(raw -> new SafeVersion(raw).value()).orElse(new DefaultVersion().value());
        String name = new ComponentLicFeatureName(properties).get().orElse(feature);
        String provider = new ComponentLicFeatureProvider(properties).get().orElseGet(new BundleVendor(this.context.getBundle(this.component.bundle.id)));
        RestrictionLevel level = new ComponentLicFeatureLevel(properties).get().map(RestrictionLevel.Of::new).orElseGet((Supplier<RestrictionLevel>)new DefaultRestrictionLevel());
        return new BaseRequirement((Feature)new BaseFeature(feature, version, name, provider), level, (Object)this.component.name);
    }
}

