/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.licenses.model.transport;

import java.io.IOException;
import java.io.InputStream;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.passage.lic.api.EvaluationInstructions;
import org.eclipse.passage.lic.api.EvaluationType;
import org.eclipse.passage.lic.api.agreements.GlobalAgreement;
import org.eclipse.passage.lic.api.conditions.Condition;
import org.eclipse.passage.lic.api.conditions.IssuerSignature;
import org.eclipse.passage.lic.api.conditions.ValidityPeriod;
import org.eclipse.passage.lic.api.conditions.mining.ConditionTransport;
import org.eclipse.passage.lic.api.conditions.mining.ContentType;
import org.eclipse.passage.lic.base.conditions.BaseCondition;
import org.eclipse.passage.lic.base.conditions.BaseEvaluationInstructions;
import org.eclipse.passage.lic.base.conditions.BaseValidityPeriodClosed;
import org.eclipse.passage.lic.internal.emf.BlindResource;
import org.eclipse.passage.lic.internal.licenses.convert.PAgreements;
import org.eclipse.passage.lic.internal.licenses.convert.PIssuerSignature;
import org.eclipse.passage.lic.internal.licenses.convert.PVersionMatch;
import org.eclipse.passage.lic.internal.licenses.model.migration.LicensesResourceHandler;
import org.eclipse.passage.lic.licenses.model.api.AgreementData;
import org.eclipse.passage.lic.licenses.model.api.PersonalFeatureGrant;
import org.eclipse.passage.lic.licenses.model.api.PersonalLicensePack;
import org.eclipse.passage.lic.licenses.model.api.ValidityPeriodClosed;
import org.eclipse.passage.lic.licenses.model.meta.LicensesPackage;

abstract class BaseXmiConditionTransport
implements ConditionTransport {
    private final ContentType type = new ContentType.Xml();
    private final Predicate<PersonalLicensePack> filter;

    protected BaseXmiConditionTransport() {
        this(p -> true);
    }

    protected BaseXmiConditionTransport(Predicate<PersonalLicensePack> filter) {
        this.filter = filter;
    }

    public ContentType id() {
        return this.type;
    }

    public ConditionTransport.Data read(InputStream input) throws IOException {
        Resource resource = new BlindResource(LicensesPackage.eINSTANCE.getPersonalLicensePack()).get();
        resource.load(input, this.loadOptions());
        Optional<PersonalLicensePack> license = resource.getContents().stream().filter(PersonalLicensePack.class::isInstance).map(PersonalLicensePack.class::cast).filter(this.filter).findAny();
        if (!license.isPresent()) {
            return new ConditionTransport.Data();
        }
        return new ConditionTransport.Data(this.conditions(license.get()), this.agreements(license.get()), this.signature(license.get()));
    }

    private Collection<GlobalAgreement> agreements(PersonalLicensePack pack) {
        return new PAgreements((Collection<AgreementData>)pack.getLicense().getAgreements()).get();
    }

    private Optional<IssuerSignature> signature(PersonalLicensePack pack) {
        if (pack.getLicense().getSignature() == null) {
            return Optional.empty();
        }
        return Optional.of(new PIssuerSignature(pack.getLicense().getSignature()).get());
    }

    private Collection<Condition> conditions(PersonalLicensePack license) {
        return license.getGrants().stream().map(this::condition).collect(Collectors.toList());
    }

    private Map<String, Object> loadOptions() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("http://www.eclipse.org/passage/lic/licenses/3.0.0", LicensesPackage.eINSTANCE);
        options.put("licenses", LicensesPackage.eINSTANCE);
        options.put("RESOURCE_HANDLER", (Object)new LicensesResourceHandler());
        return options;
    }

    private Condition condition(PersonalFeatureGrant grant) {
        return new BaseCondition(grant.getIdentifier(), grant.getFeature().getIdentifier(), new PVersionMatch(grant.getFeature().getVersionMatch()).get(), (ValidityPeriod)new BaseValidityPeriodClosed(this.fromDate(((ValidityPeriodClosed)grant.getValid()).getFrom()), this.fromDate(((ValidityPeriodClosed)grant.getValid()).getUntil())), (EvaluationInstructions)new BaseEvaluationInstructions((EvaluationType)new EvaluationType.Of(grant.getUserAuthentication().getType()), grant.getUserAuthentication().getExpression()));
    }

    private ZonedDateTime fromDate(Date date) {
        if (date == null) {
            return ZonedDateTime.now().minusMinutes(1L);
        }
        return ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }
}

