/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.licenses.edit.providers;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.passage.lic.licenses.edit.ClosedPeriodPrinted;
import org.eclipse.passage.lic.licenses.edit.LicensesEditPlugin;
import org.eclipse.passage.lic.licenses.model.api.FeatureGrant;
import org.eclipse.passage.lic.licenses.model.api.FeatureRef;
import org.eclipse.passage.lic.licenses.model.api.VersionMatch;
import org.eclipse.passage.lic.licenses.model.meta.LicensesFactory;
import org.eclipse.passage.lic.licenses.model.meta.LicensesPackage;

public class FeatureGrantItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public FeatureGrantItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addIdentifierPropertyDescriptor(object);
            this.addFeaturePropertyDescriptor(object);
            this.addVividPropertyDescriptor(object);
            this.addCapacityPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addIdentifierPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_FeatureGrant_identifier_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_FeatureGrant_identifier_feature", "_UI_FeatureGrant_type"), (EStructuralFeature)LicensesPackage.eINSTANCE.getFeatureGrant_Identifier(), true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addFeaturePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_FeatureGrant_feature_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_FeatureGrant_feature_feature", "_UI_FeatureGrant_type"), (EStructuralFeature)LicensesPackage.eINSTANCE.getFeatureGrant_Feature(), true, false, false, null, null, null));
    }

    protected void addVividPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_FeatureGrant_vivid_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_FeatureGrant_vivid_feature", "_UI_FeatureGrant_type"), (EStructuralFeature)LicensesPackage.eINSTANCE.getFeatureGrant_Vivid(), true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addCapacityPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_FeatureGrant_capacity_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_FeatureGrant_capacity_feature", "_UI_FeatureGrant_type"), (EStructuralFeature)LicensesPackage.eINSTANCE.getFeatureGrant_Capacity(), true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(LicensesPackage.eINSTANCE.getFeatureGrant_Valid());
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/license.png"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        FeatureGrant grant = (FeatureGrant)object;
        String feature = Optional.ofNullable(grant.getFeature()).map(FeatureRef::getIdentifier).orElse("unknown");
        Optional<VersionMatch> match = Optional.ofNullable(grant.getFeature()).map(FeatureRef::getVersionMatch);
        String version = match.map(VersionMatch::getVersion).orElse("unknown");
        String rule = match.map(VersionMatch::getRule).orElse("unknown");
        ClosedPeriodPrinted period = new ClosedPeriodPrinted(grant.getValid());
        return this.getString("_UI_FeatureGrant_type_detailed", new Object[]{feature, version, rule, grant.getCapacity(), period.from(), period.until(), grant.getVivid()});
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(FeatureGrant.class)) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 2: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(LicensesPackage.eINSTANCE.getFeatureGrant_Valid(), LicensesFactory.eINSTANCE.createValidityPeriodClosed()));
    }

    public ResourceLocator getResourceLocator() {
        return LicensesEditPlugin.INSTANCE;
    }
}

