/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base.mine;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import org.eclipse.passage.lbc.internal.base.i18n.BaseMessages;
import org.eclipse.passage.lic.internal.api.EvaluationInstructions;
import org.eclipse.passage.lic.internal.api.EvaluationType;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.conditions.Condition;
import org.eclipse.passage.lic.internal.api.conditions.ValidityPeriod;
import org.eclipse.passage.lic.internal.api.conditions.VersionMatch;
import org.eclipse.passage.lic.internal.base.conditions.BaseCondition;
import org.eclipse.passage.lic.internal.base.conditions.BaseEvaluationInstructions;
import org.eclipse.passage.lic.internal.base.conditions.BaseValidityPeriodClosed;
import org.eclipse.passage.lic.internal.licenses.convert.PVersionMatch;
import org.eclipse.passage.lic.licenses.VersionMatchDescriptor;
import org.eclipse.passage.lic.licenses.model.api.FeatureGrant;
import org.eclipse.passage.lic.licenses.model.api.FloatingLicensePack;
import org.eclipse.passage.lic.licenses.model.api.UserGrant;
import org.eclipse.passage.lic.licenses.model.api.ValidityPeriodClosed;

final class AssembledConditions {
    private final FloatingLicensePack license;

    AssembledConditions(FloatingLicensePack license) {
        this.license = license;
    }

    Collection<Condition> forUser(String identifier) throws LicensingException {
        Optional<UserGrant> user = this.license.getUsers().stream().filter(grant -> grant.getUser().equals(identifier)).findFirst();
        if (!user.isPresent()) {
            return Collections.emptyList();
        }
        return this.forFeatures(user.get());
    }

    private Collection<Condition> forFeatures(UserGrant user) throws LicensingException {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (FeatureGrant feature : this.license.getFeatures()) {
            conditions.add(this.condition(user, feature));
        }
        return conditions;
    }

    private Condition condition(UserGrant user, FeatureGrant feature) throws LicensingException {
        return new BaseCondition(feature.getIdentifier(), feature.getFeature().getIdentifier(), this.version(feature), this.period(feature), this.evaluation(user));
    }

    private EvaluationInstructions evaluation(UserGrant user) {
        return new BaseEvaluationInstructions((EvaluationType)new EvaluationType.Of(user.getAuthentication().getType()), user.getAuthentication().getExpression());
    }

    private ValidityPeriod period(FeatureGrant feature) throws LicensingException {
        org.eclipse.passage.lic.licenses.model.api.ValidityPeriod origin = feature.getValid();
        if (!ValidityPeriodClosed.class.isInstance(origin)) {
            throw new LicensingException(String.format(BaseMessages.AssembledConditions_validity_period_type_unknown, origin.eClass().getName()));
        }
        ValidityPeriodClosed closed = (ValidityPeriodClosed)ValidityPeriodClosed.class.cast(origin);
        return new BaseValidityPeriodClosed(this.date(closed.getFrom()), this.to(feature, closed));
    }

    private ZonedDateTime to(FeatureGrant feature, ValidityPeriodClosed closed) {
        return this.min(this.date(closed.getUntil()), ZonedDateTime.now().plusMinutes(feature.getVivid()));
    }

    private ZonedDateTime date(Date date) {
        return ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    private ZonedDateTime min(ZonedDateTime first, ZonedDateTime second) {
        return first.isAfter(second) ? second : first;
    }

    private VersionMatch version(FeatureGrant feature) {
        return new PVersionMatch((VersionMatchDescriptor)feature.getFeature().getVersionMatch()).get();
    }
}

