/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base.mine;

import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.conditions.Condition;
import org.eclipse.passage.lic.internal.api.conditions.ValidityPeriodClosed;
import org.eclipse.passage.lic.internal.api.conditions.ValidityPeriodOpen;
import org.eclipse.passage.lic.internal.licenses.model.EmptyPersonalFeatureGrant;
import org.eclipse.passage.lic.internal.licenses.model.EmptyPersonalLicensePack;
import org.eclipse.passage.lic.licenses.model.api.PersonalFeatureGrant;
import org.eclipse.passage.lic.licenses.model.api.PersonalLicensePack;

final class PersonalLicenseGenerated
implements Supplier<PersonalLicensePack> {
    private final LicensedProduct product;
    private final String user;
    private final Collection<Condition> conditions;

    PersonalLicenseGenerated(LicensedProduct product, String user, Collection<Condition> conditions) {
        this.product = product;
        this.user = user;
        this.conditions = conditions;
    }

    @Override
    public PersonalLicensePack get() {
        PersonalLicensePack pack = new EmptyPersonalLicensePack().get();
        pack.getLicense().setIdentifier(this.generated());
        pack.getLicense().setIssueDate(new Date());
        pack.getLicense().setPlan("ignored");
        pack.getLicense().getProduct().setIdentifier(this.product.identifier());
        pack.getLicense().getProduct().setVersion(this.product.version());
        pack.getLicense().getUser().setName(this.user);
        pack.getLicense().getUser().setIdentifier(this.user);
        this.conditions.stream().map(this::grant).forEach(arg_0 -> pack.getGrants().add(arg_0));
        return pack;
    }

    private String generated() {
        return String.format("generated:%s", UUID.randomUUID().toString());
    }

    private PersonalFeatureGrant grant(Condition condition) {
        PersonalFeatureGrant grant = new EmptyPersonalFeatureGrant().get();
        grant.setIdentifier(condition.identifier());
        grant.getFeature().setIdentifier(condition.feature());
        grant.getFeature().getVersionMatch().setVersion(condition.versionMatch().version());
        grant.getFeature().getVersionMatch().setRule(condition.versionMatch().rule().identifier());
        grant.setCapacity(1);
        grant.getUserAuthentication().setExpression(condition.evaluationInstructions().expression());
        grant.getUserAuthentication().setType(condition.evaluationInstructions().type().identifier());
        ((org.eclipse.passage.lic.licenses.model.api.ValidityPeriodClosed)grant.getValid()).setFrom(this.date(condition, ValidityPeriodOpen::from));
        ((org.eclipse.passage.lic.licenses.model.api.ValidityPeriodClosed)grant.getValid()).setUntil(this.date(condition, ValidityPeriodClosed::to));
        return grant;
    }

    private Date date(Condition condition, Function<ValidityPeriodClosed, ZonedDateTime> source) {
        ValidityPeriodClosed closed = (ValidityPeriodClosed)condition.validityPeriod();
        return Date.from(source.apply(closed).toInstant());
    }
}

