/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base;

import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.passage.lbc.internal.base.api.FloatingState;
import org.eclipse.passage.lbc.internal.base.api.FlsGear;
import org.eclipse.passage.lbc.internal.base.api.FlsGearAwre;
import org.eclipse.passage.lbc.internal.base.api.RawRequest;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.io.Hashes;
import org.eclipse.passage.lic.internal.api.io.KeyKeeper;
import org.eclipse.passage.lic.internal.api.registry.Registry;
import org.eclipse.passage.lic.internal.api.registry.ServiceId;
import org.eclipse.passage.lic.internal.api.registry.StringServiceId;
import org.eclipse.passage.lic.internal.net.api.handle.NetResponse;
import org.eclipse.passage.lic.internal.net.handle.EObjectTransfer;
import org.eclipse.passage.lic.internal.net.handle.Failure;
import org.eclipse.passage.lic.internal.net.handle.ProductUserRequest;

public final class EncodedResponse<T extends EObject> {
    private final T payload;
    private final ProductUserRequest<RawRequest> data;

    public EncodedResponse(T payload, ProductUserRequest<RawRequest> data) {
        this.payload = payload;
        this.data = data;
    }

    public NetResponse get() {
        return (NetResponse)new FlsGearAwre().withGear(this::transferable).orElse(new Failure.OperationFailed("mine", "Failed exploiting gear"));
    }

    private Optional<NetResponse> transferable(FlsGear gear) {
        return Optional.of(new EObjectTransfer(this.payload, this.keyKeeper(gear), this.hashes(gear)));
    }

    private KeyKeeper keyKeeper(FlsGear gear) {
        return gear.keyKeper((LicensedProduct)this.data.product().get(), ((FloatingState)((RawRequest)this.data.raw()).state())::source);
    }

    private Hashes hashes(FlsGear gear) {
        return (Hashes)((Registry)gear.hashes().get()).service((ServiceId)new StringServiceId((String)this.data.algorithm().get()));
    }
}

