/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jface.dialogs.licensing;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.HereLabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableColumn;

final class HereTable<T> {
    private final TableViewer table;
    private final Class<T> cls;
    private final Map<Integer, Function<T, String>> texts = new HashMap<Integer, Function<T, String>>();

    HereTable(Composite parent, Class<T> cls) {
        this.table = new TableViewer(parent);
        this.cls = cls;
    }

    public TableViewer viewer() {
        this.table.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.table.setLabelProvider(new HereLabelProvider<T>(this.texts, this.cls));
        this.table.getTable().setHeaderVisible(true);
        this.table.getTable().setLinesVisible(true);
        this.table.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        return this.table;
    }

    public HereTable<T> withColumn(String name, int width, Function<T, String> text) {
        TableViewerColumn column = new TableViewerColumn(this.table, 0);
        this.setupColumn(column.getColumn(), name, width);
        this.texts.put(this.table.getTable().getColumnCount() - 1, text);
        return this;
    }

    public HereTable<T> withColumn(String name, int width, int index, Function<T, String> text) {
        TableViewerColumn column = new TableViewerColumn(this.table, 0, index);
        this.setupColumn(column.getColumn(), name, width);
        this.texts.put(index, text);
        return this;
    }

    private void setupColumn(TableColumn column, String name, int width) {
        column.setText(name);
        column.setWidth(width);
        column.setResizable(true);
    }
}

