/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.equinox.conditions;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.passage.lbc.api.conditions.ConditionArbiter;
import org.eclipse.passage.lbc.internal.equinox.conditions.ConditionTimerTask;
import org.eclipse.passage.lbc.internal.equinox.i18n.EquinoxMessages;
import org.eclipse.passage.lic.api.LicensingResult;
import org.eclipse.passage.lic.api.conditions.LicensingCondition;
import org.eclipse.passage.lic.base.LicensingResults;

public class ServerConditionArbiter
implements ConditionArbiter {
    List<LicensingCondition> reservedConditions = new ArrayList<LicensingCondition>();
    List<LicensingCondition> leaseConditions = new ArrayList<LicensingCondition>();
    List<ConditionTimerTask> reservedConditionTasks = new ArrayList<ConditionTimerTask>();
    List<ConditionTimerTask> leasedConditionTasks = new ArrayList<ConditionTimerTask>();
    Logger logger = Logger.getLogger(ServerConditionArbiter.class.getName());

    public boolean addConditionToReserv(LicensingCondition condition) {
        boolean isReserved = false;
        if (this.leaseConditions.contains(condition)) {
            this.logger.info(EquinoxMessages.ServerConditionArbiter_i_lease);
            return isReserved;
        }
        if (this.reservedConditions.contains(condition)) {
            this.logger.info(EquinoxMessages.ServerConditionArbiter_i_reserv);
            return isReserved;
        }
        isReserved = this.createTaskForReserving(condition);
        if (isReserved) {
            isReserved = this.reservedConditions.add(condition);
        }
        return isReserved;
    }

    public boolean addConditionToLease(LicensingCondition condition) {
        boolean isLeased = false;
        if (this.leaseConditions.contains(condition)) {
            this.logger.info(EquinoxMessages.ServerConditionArbiter_i_already_leased);
            return isLeased;
        }
        if (this.reservedConditions.contains(condition)) {
            isLeased = this.createTaskForLeasing(condition);
            if (isLeased) {
                isLeased = this.leaseConditions.add(condition);
            }
        } else {
            this.logger.info(EquinoxMessages.ServerConditionArbiter_i_not_reserved);
        }
        return isLeased;
    }

    private boolean createTaskForLeasing(final LicensingCondition condition) {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime nowPlusDay = now.plusDays(1L);
        ConditionTimerTask task = new ConditionTimerTask(nowPlusDay.toString()){

            @Override
            void timeExpired() {
                ServerConditionArbiter.this.leasedConditionTasks.remove(this);
                ServerConditionArbiter.this.leaseConditions.remove(condition);
            }
        };
        return this.leasedConditionTasks.add(task);
    }

    private boolean createTaskForReserving(final LicensingCondition condition) {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime nowPlusMinute = now.plusMinutes(1L);
        ConditionTimerTask task = new ConditionTimerTask(nowPlusMinute.toString()){

            @Override
            void timeExpired() {
                ServerConditionArbiter.this.reservedConditionTasks.remove(this);
                ServerConditionArbiter.this.reservedConditions.remove(condition);
            }
        };
        return this.reservedConditionTasks.add(task);
    }

    public LicensingCondition checkoutReservedCondition(LicensingCondition condition) {
        if (this.reservedConditions.contains(condition) && this.reservedConditions.remove(condition)) {
            this.leaseConditions.add(condition);
            return condition;
        }
        return null;
    }

    public LicensingResult acquireConditions(Iterable<LicensingCondition> conditions) {
        return LicensingResults.createOK();
    }

    public LicensingResult keepConditions(Iterable<LicensingCondition> conditions) {
        return LicensingResults.createOK();
    }

    public LicensingResult releaseConditions(Iterable<LicensingCondition> conditions) {
        return LicensingResults.createOK();
    }
}

