/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core.request;

import java.time.LocalDate;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.api.EvaluationInstructions;
import org.eclipse.passage.lic.api.EvaluationType;
import org.eclipse.passage.lic.base.conditions.BaseEvaluationInstructions;
import org.eclipse.passage.lic.licenses.LicensePlanDescriptor;
import org.eclipse.passage.lic.products.ProductVersionDescriptor;
import org.eclipse.passage.lic.users.UserDescriptor;
import org.eclipse.passage.loc.internal.api.FloatingLicenseRequest;
import org.eclipse.passage.loc.internal.licenses.core.request.GeneralLicenseData;

public final class FloatingLicenseData
extends GeneralLicenseData
implements FloatingLicenseRequest {
    private final Supplier<Collection<UserDescriptor>> users;
    private final Supplier<Integer> capacity;

    public FloatingLicenseData(Supplier<Collection<UserDescriptor>> users, Supplier<LicensePlanDescriptor> plan, Supplier<ProductVersionDescriptor> product, Supplier<LocalDate> from, Supplier<LocalDate> until, Supplier<Integer> capacity) {
        super(plan, product, from, until);
        Objects.requireNonNull(users, "PersonalLicenseData::users");
        this.users = users;
        this.capacity = capacity;
    }

    public Collection<String> users() {
        return this.users.get().stream().map(user -> user.getContact().getEmail()).collect(Collectors.toList());
    }

    public EvaluationInstructions userAuthentication(String user) {
        UserDescriptor target = this.user(user);
        return new BaseEvaluationInstructions((EvaluationType)new EvaluationType.Of(target.getPreferredEvaluationExpression()), target.getPreferredEvaluationType());
    }

    private UserDescriptor user(String identifier) {
        return this.users.get().stream().filter(user -> identifier.equals(user.getContact().getEmail())).findAny().get();
    }

    public int defaultCapacity() {
        return this.capacity.get();
    }
}

