/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.ui.handlers;

import java.time.LocalDate;
import java.time.LocalDateTime;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.passage.lic.internal.api.MandatoryService;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.base.diagnostic.NoSevereErrors;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.DiagnosticDialog;
import org.eclipse.passage.lic.licenses.LicensePlanDescriptor;
import org.eclipse.passage.lic.licenses.PersonalLicensePackDescriptor;
import org.eclipse.passage.lic.licenses.model.api.PersonalLicensePack;
import org.eclipse.passage.lic.products.ProductVersionDescriptor;
import org.eclipse.passage.lic.users.UserDescriptor;
import org.eclipse.passage.loc.internal.api.IssuedLicense;
import org.eclipse.passage.loc.internal.api.OperatorLicenseService;
import org.eclipse.passage.loc.internal.api.PersonalLicenseRequest;
import org.eclipse.passage.loc.internal.licenses.core.request.PersonalLicenseData;
import org.eclipse.passage.loc.internal.licenses.ui.i18n.LicensesUiMessages;
import org.eclipse.passage.loc.internal.products.ProductRegistry;
import org.eclipse.passage.loc.internal.users.ui.SelectUser;
import org.eclipse.passage.loc.internal.users.ui.SelectUserOrigin;
import org.eclipse.passage.loc.internal.workbench.MandatoryEclipseContext;
import org.eclipse.passage.loc.internal.workbench.SelectInner;
import org.eclipse.passage.loc.products.ui.ProductsUi;
import org.eclipse.passage.loc.workbench.LocWokbench;
import org.eclipse.swt.widgets.Shell;

public class LicenseExportHandler {
    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") LicensePlanDescriptor licensePlan, IEclipseContext context) {
        PersonalLicensePackDescriptor licensePack;
        OperatorLicenseService licenseService = (OperatorLicenseService)context.get(OperatorLicenseService.class);
        Shell shell = (Shell)context.get(Shell.class);
        MandatoryEclipseContext resolution = new MandatoryEclipseContext(context);
        java.util.Optional user = new SelectInner(new SelectUser((MandatoryService)resolution).get(), new SelectUserOrigin((MandatoryService)resolution).get(), (MandatoryService)resolution).get();
        if (!user.isPresent()) {
            return;
        }
        ProductRegistry productRegistry = (ProductRegistry)context.get(ProductRegistry.class);
        ProductVersionDescriptor productVersion = ProductsUi.selectProductVersionDescriptor((Shell)shell, (ProductRegistry)productRegistry, null);
        if (productVersion == null) {
            return;
        }
        long months = 12L;
        InputDialog durationDialog = new InputDialog(shell, LicensesUiMessages.LicenseExportHandler_period_title, LicensesUiMessages.LicenseExportHandler_period_message, String.valueOf(months), new IInputValidator(){

            public String isValid(String newText) {
                String invalidInput = LicensesUiMessages.LicenseExportHandler_e_period_invalid;
                try {
                    long parsed = Long.parseLong(newText);
                    if (parsed <= 0L) {
                        return invalidInput;
                    }
                }
                catch (Exception e) {
                    return invalidInput;
                }
                return null;
            }
        });
        if (durationDialog.open() != 0) {
            return;
        }
        months = Long.parseLong(durationDialog.getValue());
        LocalDateTime fromLocal = LocalDateTime.now();
        LocalDateTime untilLocal = fromLocal.plusMonths(months);
        PersonalLicenseRequest request = this.createLicensingRequest((UserDescriptor)user.get(), licensePlan, productVersion, fromLocal.toLocalDate(), untilLocal.toLocalDate());
        ServiceInvocationResult result = licenseService.issueLicensePack(request, licensePack = licenseService.createLicensePack(request));
        if (new NoSevereErrors().test(result.diagnostic()) && result.data().isPresent()) {
            MessageDialog.openInformation((Shell)shell, (String)LicensesUiMessages.LicenseExportHandler_success_title, (String)String.format(LicensesUiMessages.LicenseExportHandler_success_description, ((IssuedLicense)result.data().get()).encrypted().toAbsolutePath().toString(), ((IssuedLicense)result.data().get()).decrypted().toAbsolutePath().toString()));
            PersonalLicensePack userLicense = ((IssuedLicense)result.data().get()).license();
            String perspectiveId = "org.eclipse.passage.loc.users.ui.perspective.main";
            LocWokbench.switchPerspective((IEclipseContext)context, (String)perspectiveId);
            IEventBroker broker = (IEventBroker)context.get(IEventBroker.class);
            broker.post("org/eclipse/passage/loc/workbench/show", (Object)userLicense);
        } else {
            new DiagnosticDialog(shell, result.diagnostic()).open();
        }
    }

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") @Optional @Named(value="org.eclipse.ui.selection") LicensePlanDescriptor licensePlan, IEclipseContext context) {
        OperatorLicenseService licenseService = (OperatorLicenseService)context.get(OperatorLicenseService.class);
        if (licenseService == null) {
            return false;
        }
        return licensePlan != null;
    }

    private PersonalLicenseRequest createLicensingRequest(UserDescriptor user, LicensePlanDescriptor plan, ProductVersionDescriptor product, LocalDate from, LocalDate until) {
        return new PersonalLicenseData(() -> user, () -> plan, () -> product, () -> from, () -> until);
    }
}

