/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.seal.internal.demo;

import java.util.Arrays;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.acquire.LicenseAcquisitionService;
import org.eclipse.passage.lic.internal.api.acquire.LicenseAcquisitionServicesRegistry;
import org.eclipse.passage.lic.internal.api.conditions.ConditionMiningTarget;
import org.eclipse.passage.lic.internal.api.conditions.mining.MinedConditions;
import org.eclipse.passage.lic.internal.api.conditions.mining.MinedConditionsRegistry;
import org.eclipse.passage.lic.internal.api.conditions.mining.MiningEquipment;
import org.eclipse.passage.lic.internal.api.io.HashesRegistry;
import org.eclipse.passage.lic.internal.api.registry.Registry;
import org.eclipse.passage.lic.internal.base.acquire.UserHomeLicenseAcquisitionService;
import org.eclipse.passage.lic.internal.base.conditions.mining.UserHomeResidentConditions;
import org.eclipse.passage.lic.internal.base.registry.ReadOnlyRegistry;
import org.eclipse.passage.lic.internal.equinox.acquire.ConfigurationLicenseAcquisitionService;
import org.eclipse.passage.lic.internal.equinox.acquire.InstallationLicenseAcquisitionService;
import org.eclipse.passage.lic.internal.equinox.conditions.ConfigurationResidentConditions;
import org.eclipse.passage.lic.internal.equinox.conditions.InstallationResidentConditions;
import org.eclipse.passage.seal.internal.demo.LicensingDirection;

final class PersonalLicensing
implements LicensingDirection {
    private final Registry<ConditionMiningTarget, MinedConditions> conditions;
    private final Registry<ConditionMiningTarget, LicenseAcquisitionService> acquirers;

    PersonalLicensing(Supplier<MiningEquipment> equipment) {
        this.conditions = new ReadOnlyRegistry(Arrays.asList(new UserHomeResidentConditions(equipment.get()), new InstallationResidentConditions(equipment.get()), new ConfigurationResidentConditions(equipment.get())));
        this.acquirers = new ReadOnlyRegistry(Arrays.asList(new UserHomeLicenseAcquisitionService(), new InstallationLicenseAcquisitionService(), new ConfigurationLicenseAcquisitionService()));
    }

    @Override
    public final MinedConditionsRegistry conditionMiners() {
        return () -> this.conditions;
    }

    @Override
    public final LicenseAcquisitionServicesRegistry acquirers() {
        return () -> this.acquirers;
    }

    @Override
    public final HashesRegistry hashes() {
        return () -> new ReadOnlyRegistry();
    }
}

