/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.report.internal.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.passage.loc.yars.internal.api.ReportException;

final class ExistingFileStream {
    private final Path path;

    ExistingFileStream(Path path) {
        this.path = path;
    }

    Appendable stream() throws ReportException {
        try {
            return new OutputStreamWriter((OutputStream)new FileOutputStream(this.file()), StandardCharsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            throw new ReportException(String.format("file %s appears to be not-existing all of a sudden!", this.path), null);
        }
    }

    private File file() throws ReportException {
        if (Files.notExists(this.path, new LinkOption[0])) {
            return this.create().toFile();
        }
        if (Files.isDirectory(this.path, new LinkOption[0])) {
            throw new ReportException(String.format("path %s points to a directory, but we expect a file to export to", this.path), null);
        }
        return this.path.toFile();
    }

    private Path create() throws ReportException {
        try {
            return Files.createFile(this.path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ReportException(String.format("failed to create file %s", this.path), (Throwable)e);
        }
    }
}

