/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.jface.viewers;

import java.util.Iterator;
import org.eclipse.passage.lic.api.requirements.LicensingRequirement;
import org.eclipse.passage.lic.internal.jface.i18n.JFaceMessages;

public class RequirementLabels {
    public static final String PROVIDER_NOT_AVAILABLE = JFaceMessages.RequirementLabels_provider_n_a;
    public static final String NAME_NOT_AVAILABLE = JFaceMessages.RequirementLabels_name_n_a;

    public static String getFeatureProvider(Iterable<LicensingRequirement> requirements) {
        if (requirements == null) {
            return PROVIDER_NOT_AVAILABLE;
        }
        Iterator<LicensingRequirement> iterator = requirements.iterator();
        if (iterator.hasNext()) {
            return RequirementLabels.getFeatureProvider(iterator.next());
        }
        return PROVIDER_NOT_AVAILABLE;
    }

    public static String getFeatureProvider(LicensingRequirement requirement) {
        if (requirement == null) {
            return PROVIDER_NOT_AVAILABLE;
        }
        String value = requirement.getFeatureProvider();
        if (value == null || value.trim().length() == 0) {
            return PROVIDER_NOT_AVAILABLE;
        }
        return value;
    }

    public static String getFeatureName(Iterable<LicensingRequirement> requirements) {
        if (requirements == null) {
            return NAME_NOT_AVAILABLE;
        }
        Iterator<LicensingRequirement> iterator = requirements.iterator();
        if (iterator.hasNext()) {
            return RequirementLabels.getFeatureName(iterator.next());
        }
        return NAME_NOT_AVAILABLE;
    }

    public static String getFeatureName(LicensingRequirement requirement) {
        if (requirement == null) {
            return NAME_NOT_AVAILABLE;
        }
        String value = requirement.getFeatureName();
        if (value == null || value.trim().length() == 0) {
            return NAME_NOT_AVAILABLE;
        }
        return value;
    }
}

