/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.jface.viewers;

import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.passage.lic.api.LicensingResult;
import org.eclipse.passage.lic.api.conditions.LicensingCondition;
import org.eclipse.passage.lic.base.conditions.LicensingConditions;
import org.eclipse.passage.lic.jface.resource.LicensingColors;
import org.eclipse.swt.graphics.RGB;

public class ConditionRepresenters {
    private static String source = ConditionRepresenters.class.getName();

    public static String resolveImageKey(LicensingCondition condition) {
        LicensingResult result = LicensingConditions.validate((LicensingCondition)condition, (String)source);
        switch (result.getSeverity()) {
            case 0: {
                return "IMG_LEVEL_OK";
            }
            case 1: {
                return "IMG_LEVEL_INFO";
            }
            case 2: {
                return "IMG_LEVEL_WARN";
            }
            case 4: {
                return "IMG_LEVEL_ERROR";
            }
            case 8: {
                return "IMG_LEVEL_FATAL";
            }
        }
        return "IMG_LEVEL_WARN";
    }

    public static RGB resolveRGB(LicensingCondition condition) {
        LicensingResult result = LicensingConditions.validate((LicensingCondition)condition, (String)source);
        ColorRegistry colorRegistry = LicensingColors.getColorRegistry();
        switch (result.getSeverity()) {
            case 0: {
                return colorRegistry.get("COLOR_LEVEL_OK").getRGB();
            }
            case 1: {
                return colorRegistry.get("COLOR_LEVEL_INFO").getRGB();
            }
            case 2: {
                return colorRegistry.get("COLOR_LEVEL_WARN").getRGB();
            }
            case 4: {
                return colorRegistry.get("COLOR_LEVEL_ERROR").getRGB();
            }
            case 8: {
                return colorRegistry.get("COLOR_LEVEL_FATAL").getRGB();
            }
        }
        return colorRegistry.get("COLOR_LEVEL_WARN").getRGB();
    }
}

