/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.AppenderRefModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.DependencyDefinition;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.model.processor.PhaseIndicator;
import ch.qos.logback.core.model.processor.ProcessingPhase;
import java.util.List;
import java.util.stream.Collectors;

@PhaseIndicator(phase=ProcessingPhase.DEPENDENCY_ANALYSIS)
public class AppenderRefDependencyAnalyser
extends ModelHandlerBase {
    public AppenderRefDependencyAnalyser(Context context) {
        super(context);
    }

    protected Class<Model> getSupportedModelClass() {
        return Model.class;
    }

    @Override
    public void handle(ModelInterpretationContext mic, Model parentModel) throws ModelHandlerException {
        List appenderRefModels = parentModel.getSubModels().stream().filter(m -> m instanceof AppenderRefModel).map(m -> (AppenderRefModel)m).collect(Collectors.toList());
        for (AppenderRefModel appenderRefModel : appenderRefModels) {
            String ref = mic.subst(appenderRefModel.getRef());
            DependencyDefinition dd = new DependencyDefinition(parentModel, ref);
            mic.addDependencyDefinition(dd);
        }
    }
}

