/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.metadata.expression.CompoundIterator;
import org.eclipse.equinox.internal.p2.metadata.index.CompoundIndex;
import org.eclipse.equinox.internal.p2.metadata.index.IndexProvider;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.KeyWithLocale;
import org.eclipse.equinox.p2.metadata.expression.IEvaluationContext;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.index.IIndex;
import org.eclipse.equinox.p2.metadata.index.IIndexProvider;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;

public final class CompoundQueryable<T>
extends IndexProvider<T> {
    private Collection<? extends IQueryable<T>> queryables;

    public CompoundQueryable(IQueryable<T>[] queryables) {
        this.queryables = Arrays.asList(queryables);
    }

    public CompoundQueryable(Collection<? extends IQueryable<T>> queryables) {
        this.queryables = List.copyOf(queryables);
    }

    CompoundQueryable(IQueryable<T> query1, IQueryable<T> query2) {
        this(List.of(query1, query2));
    }

    @Override
    public IIndex<T> getIndex(String memberName) {
        boolean found = this.queryables.stream().filter(IIndexProvider.class::isInstance).map(IIndexProvider.class::cast).anyMatch(ip -> ip.getIndex(memberName) != null);
        if (!found) {
            return null;
        }
        ArrayList indexes = new ArrayList(this.queryables.size());
        for (IQueryable<T> queryable : this.queryables) {
            if (queryable instanceof IIndexProvider) {
                IIndexProvider ip2 = (IIndexProvider)((Object)queryable);
                IIndex index = ip2.getIndex(memberName);
                if (index != null) {
                    indexes.add(index);
                    continue;
                }
                indexes.add(new PassThroughIndex(ip2.everything()));
                continue;
            }
            indexes.add(new PassThroughIndex<T>(CompoundQueryable.getIteratorFromQueryable(queryable)));
        }
        return indexes.size() == 1 ? (IIndex)indexes.get(0) : new CompoundIndex(indexes);
    }

    @Override
    public Iterator<T> everything() {
        if (this.queryables.isEmpty()) {
            return Collections.emptyIterator();
        }
        if (this.queryables.size() == 1) {
            return CompoundQueryable.getIteratorFromQueryable(this.queryables.iterator().next());
        }
        ArrayList<Iterator<T>> iterators = new ArrayList<Iterator<T>>(this.queryables.size());
        for (IQueryable<T> queryable : this.queryables) {
            iterators.add(CompoundQueryable.getIteratorFromQueryable(queryable));
        }
        return new CompoundIterator(iterators.iterator());
    }

    @Override
    public boolean contains(T element) {
        for (IQueryable<T> queryable : this.queryables) {
            if (!queryable.contains(element)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object getManagedProperty(Object client, String memberName, Object key) {
        Object ip;
        for (IQueryable<T> queryable : this.queryables) {
            Object value;
            if (!(queryable instanceof IIndexProvider) || (value = (ip = (IIndexProvider)((Object)queryable)).getManagedProperty(client, memberName, key)) == null) continue;
            return value;
        }
        Object object = client;
        if (object instanceof IInstallableUnit) {
            IQueryable<T> queryable;
            queryable = (IInstallableUnit)object;
            IInstallableUnit cfr_ignored_0 = (IInstallableUnit)object;
            if (memberName.equals("translatedProperties")) {
                String string;
                Object object2 = key;
                if (object2 instanceof KeyWithLocale) {
                    void keyWithLocal;
                    ip = (KeyWithLocale)object2;
                    KeyWithLocale cfr_ignored_1 = (KeyWithLocale)object2;
                    string = iu.getProperty(keyWithLocal.getKey());
                } else {
                    string = iu.getProperty(key.toString());
                }
                return string;
            }
        }
        return null;
    }

    private static <T> Iterator<T> getIteratorFromQueryable(IQueryable<T> queryable) {
        if (queryable instanceof IIndexProvider) {
            IIndexProvider ip = (IIndexProvider)((Object)queryable);
            return ip.everything();
        }
        IteratorCapture capture = new IteratorCapture();
        queryable.query(capture, (IProgressMonitor)new NullProgressMonitor());
        return capture.getCapturedIterator();
    }

    static class IteratorCapture<T>
    implements IQuery<T> {
        private Iterator<T> capturedIterator;

        IteratorCapture() {
        }

        @Override
        public IQueryResult<T> perform(Iterator<T> iterator) {
            this.capturedIterator = iterator;
            return Collector.emptyCollector();
        }

        @Override
        public IExpression getExpression() {
            return null;
        }

        Iterator<T> getCapturedIterator() {
            return this.capturedIterator == null ? Collections.emptyIterator() : this.capturedIterator;
        }
    }

    static class PassThroughIndex<T>
    implements IIndex<T> {
        private final Iterator<T> iterator;

        public PassThroughIndex(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public Iterator<T> getCandidates(IEvaluationContext ctx, IExpression variable, IExpression booleanExpr) {
            return this.iterator;
        }
    }
}

