/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.cookie.DateUtils;
import org.eclipse.core.internal.net.ProxyManager;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.ConnectContextFactory;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.core.util.ProxyAddress;
import org.eclipse.ecf.filetransfer.BrowseFileTransferException;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IIncomingFileTransfer;
import org.eclipse.ecf.filetransfer.IRemoteFile;
import org.eclipse.ecf.filetransfer.IRemoteFileInfo;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemBrowserContainerAdapter;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemListener;
import org.eclipse.ecf.filetransfer.IRetrieveFileTransferContainerAdapter;
import org.eclipse.ecf.filetransfer.IRetrieveFileTransferOptions;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.filetransfer.UserCancelledException;
import org.eclipse.ecf.filetransfer.events.IFileTransferConnectStartEvent;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDoneEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveStartEvent;
import org.eclipse.ecf.filetransfer.events.IRemoteFileSystemBrowseEvent;
import org.eclipse.ecf.filetransfer.events.IRemoteFileSystemEvent;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.provider.filetransfer.identity.FileTransferID;
import org.eclipse.ecf.provider.filetransfer.identity.FileTransferNamespace;
import org.eclipse.ecf.provider.filetransfer.util.ProxySetupHelper;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupCorePlugin;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.internal.core.util.URIResolver;
import org.eclipse.oomph.setup.util.SetupUtil;
import org.eclipse.oomph.util.IOExceptionWithCause;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.util.WorkerPool;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ECFURIHandlerImpl
extends URIHandlerImpl
implements URIResolver {
    public static final String OPTION_CACHE_HANDLING = "OPTION_CACHE_HANDLING";
    public static final String OPTION_AUTHORIZATION_HANDLER = "OPTION_AUTHORIZATION_HANDLER";
    public static final String OPTION_AUTHORIZATION = "OPTION_AUTHORIZATION";
    public static final String OPTION_PROXY_AUTHORIZATION = "OPTION_PROXY_AUTHORIZATION";
    public static final String OPTION_MONITOR = "OPTION_MONITOR";
    public static final java.net.CookieStore COOKIE_STORE = new CookieManager().getCookieStore();
    public static final String OPTION_LOGIN_URI = "OPTION_LOGIN_URI";
    private static final String FAILED_EXPECTED_ETAG = "-1";
    private static final URI CACHE_FOLDER = SetupContext.GLOBAL_STATE_LOCATION_URI.appendSegment("cache");
    private static final Map<URI, String> EXPECTED_ETAGS = new HashMap<URI, String>();
    private static final Map<URI, IOException> EXPECTED_EXCEPTIONS = Collections.synchronizedMap(new HashMap());
    private static final Map<URI, CountDownLatch> LOCKS = new HashMap<URI, CountDownLatch>();
    private static final boolean TEST_IO_EXCEPTION = false;
    private static final boolean TEST_SLOW_NETWORK = false;
    private static final boolean TRACE = PropertiesUtil.isProperty((String)"oomph.setup.ecf.trace");
    private static final String API_GITHUB_HOST = "api.github.com";
    private static final String CONTENT_TAG = "\"content\":\"";
    private static final int CONNECT_TIMEOUT = PropertiesUtil.getProperty((String)"oomph.setup.ecf.connect.timeout", (int)10000);
    private static final int READ_TIMEOUT = PropertiesUtil.getProperty((String)"oomph.setup.ecf.read.timeout", (int)10000);
    private static boolean loggedBlockedURI;
    private static final String USER_AGENT;
    private AuthorizationHandler defaultAuthorizationHandler;

    static {
        String userAgentProperty = PropertiesUtil.getProperty((String)"oomph.userAgent");
        if (userAgentProperty == null) {
            StringBuilder userAgent = new StringBuilder("eclipse/oomph/");
            if (SetupUtil.INSTALLER_APPLICATION) {
                userAgent.append("installer/");
            } else if (SetupUtil.SETUP_ARCHIVER_APPLICATION) {
                userAgent.append("archiver/");
            }
            Version oomphVersion = SetupCorePlugin.INSTANCE.getBundle().getVersion();
            userAgent.append(oomphVersion);
            USER_AGENT = userAgent.toString();
        } else {
            USER_AGENT = userAgentProperty;
        }
    }

    public ECFURIHandlerImpl(AuthorizationHandler defaultAuthorizationHandler) {
        this.defaultAuthorizationHandler = defaultAuthorizationHandler;
    }

    @Override
    public URI resolve(URI uri) {
        return ECFURIHandlerImpl.transform(uri, null);
    }

    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        Set requestedAttributes;
        if (uri.scheme().startsWith("http") && (requestedAttributes = this.getRequestedAttributes(options)) != null && requestedAttributes.contains("readOnly") && requestedAttributes.size() == 1) {
            HashMap<String, Boolean> result = new HashMap<String, Boolean>();
            result.put("readOnly", true);
            return result;
        }
        return this.getRemoteAttributes(uri, options);
    }

    private Map<String, ?> getRemoteAttributes(URI uri, Map<?, ?> options) {
        if (uri.isPlatform()) {
            return super.getAttributes(uri, options);
        }
        try {
            return (Map)new RemoteAttributionsConnectionHandler(uri, options).process();
        }
        catch (IOException iOException) {
            return Collections.emptyMap();
        }
    }

    private final Map<String, ?> handleResponseAttributes(Set<String> requestedAttributes, Map<Object, Object> response) {
        Object timeStamp;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (requestedAttributes == null || requestedAttributes.contains("readOnly")) {
            result.put("readOnly", true);
        }
        if ((requestedAttributes == null || requestedAttributes.contains("timeStamp")) && (timeStamp = response.get("TIME_STAMP")) != null) {
            result.put("timeStamp", timeStamp);
        }
        return result;
    }

    private final Map<String, ?> handleAttributes(Set<String> requestedAttributes, IRemoteFileInfo info) {
        HashMap<String, Comparable<Boolean>> result = new HashMap<String, Comparable<Boolean>>();
        if (requestedAttributes == null || requestedAttributes.contains("readOnly")) {
            result.put("readOnly", Boolean.valueOf(true));
        }
        if (requestedAttributes == null || requestedAttributes.contains("timeStamp")) {
            result.put("timeStamp", Long.valueOf(info.getLastModified()));
        }
        if (requestedAttributes == null || requestedAttributes.contains("length")) {
            result.put("length", Long.valueOf(info.getLength()));
        }
        return result;
    }

    private final Map<String, ?> handleAttributes(Set<String> requestedAttributes, Map<String, ?> attributes) {
        Object length;
        Object timeStamp;
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        if (requestedAttributes == null || requestedAttributes.contains("readOnly")) {
            result.put("readOnly", true);
        }
        if ((requestedAttributes == null || requestedAttributes.contains("timeStamp")) && (timeStamp = attributes.get("timeStamp")) != null) {
            result.put("timeStamp", (Boolean)timeStamp);
        }
        if ((requestedAttributes == null || requestedAttributes.contains("length")) && (length = attributes.get("length")) != null) {
            result.put("length", (Boolean)length);
        }
        return result;
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        return !this.getAttributes(uri, options).isEmpty();
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        if (uri.isPlatform()) {
            return super.createInputStream(uri, options);
        }
        return (InputStream)new InputStreamConnectionHandler(uri, options).process();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CountDownLatch acquireLock(URI uri) throws IOException {
        CountDownLatch countDownLatch = null;
        Map<URI, CountDownLatch> map = LOCKS;
        synchronized (map) {
            countDownLatch = LOCKS.get(uri);
            if (countDownLatch == null) {
                countDownLatch = new CountDownLatch(1);
                LOCKS.put(uri, countDownLatch);
                return countDownLatch;
            }
        }
        try {
            countDownLatch.await();
            return this.acquireLock(uri);
        }
        catch (InterruptedException ex) {
            throw new IOExceptionWithCause((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLock(URI uri, CountDownLatch countDownLatch) {
        Map<URI, CountDownLatch> map = LOCKS;
        synchronized (map) {
            LOCKS.remove(uri);
        }
        countDownLatch.countDown();
    }

    private IContainer createContainer() throws IOException {
        try {
            return ContainerFactory.getDefault().createContainer();
        }
        catch (ContainerCreateException ex) {
            throw new IOExceptionWithCause((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<? extends URI> clearExpectedETags() {
        HashSet<URI> result;
        Map<URI, String> map = EXPECTED_ETAGS;
        synchronized (map) {
            result = new HashSet<URI>(EXPECTED_ETAGS.keySet());
            EXPECTED_ETAGS.clear();
        }
        EXPECTED_EXCEPTIONS.clear();
        return result;
    }

    public static Job mirror(final Set<? extends URI> uris) {
        Job job = new Job("ETag Mirror"){

            protected IStatus run(IProgressMonitor monitor) {
                new ETagMirror().begin(uris, monitor);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        return job;
    }

    public static URI getCacheFile(URI uri) {
        return CACHE_FOLDER.appendSegment(IOUtil.encodeFileName((String)uri.toString()));
    }

    public static String getETag(URIConverter uriConverter, URI file) {
        URI eTagFile;
        if (uriConverter.exists(file, null) && uriConverter.exists(eTagFile = file.appendFileExtension("etag"), null)) {
            try {
                return new String(BaseUtil.readFile((URIConverter)uriConverter, null, (URI)eTagFile), "UTF-8");
            }
            catch (IORuntimeException iORuntimeException) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return null;
    }

    private static void setETag(URIConverter uriConverter, URI file, String eTag) {
        try {
            if (eTag != null) {
                BaseUtil.writeFile((URIConverter)uriConverter, null, (URI)file.appendFileExtension("etag"), (byte[])eTag.getBytes("UTF-8"));
            } else {
                BaseUtil.deleteFile((URIConverter)uriConverter, null, (URI)file);
            }
        }
        catch (IORuntimeException iORuntimeException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    private AuthorizationHandler getAuthorizatonHandler(Map<?, ?> options) {
        if (options.containsKey(OPTION_AUTHORIZATION_HANDLER)) {
            return (AuthorizationHandler)options.get(OPTION_AUTHORIZATION_HANDLER);
        }
        return this.defaultAuthorizationHandler;
    }

    private static String getHost(URI uri) {
        String authority = uri.authority();
        if (authority != null) {
            int i = authority.indexOf(64);
            int j = authority.indexOf(58, i + 1);
            return j < 0 ? authority.substring(i + 1) : authority.substring(i + 1, j);
        }
        return null;
    }

    private static Date parseHTTPDate(String string) {
        try {
            return DateUtils.parseDate((String)string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getExpectedETag(URI uri) {
        Map<URI, String> map = EXPECTED_ETAGS;
        synchronized (map) {
            return EXPECTED_ETAGS.get(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setExpectedETag(URI uri, String eTag) {
        Map<URI, String> map = EXPECTED_ETAGS;
        synchronized (map) {
            String originalExpectedETag = EXPECTED_ETAGS.put(uri, eTag);
            if (eTag == null && originalExpectedETag != null) {
                EXPECTED_ETAGS.put(uri, originalExpectedETag);
            }
        }
    }

    private static CacheHandling getCacheHandling(Map<?, ?> options) {
        CacheHandling cacheHandling = (CacheHandling)((Object)options.get(OPTION_CACHE_HANDLING));
        if (cacheHandling == null) {
            cacheHandling = CacheHandling.CACHE_WITH_ETAG_CHECKING;
        }
        return cacheHandling;
    }

    private static AuthorizationHandler.Authorization getAuthorizaton(Map<?, ?> options) {
        return (AuthorizationHandler.Authorization)options.get(OPTION_AUTHORIZATION);
    }

    private static AuthorizationHandler.Authorization getProxyAuthorizaton(Map<?, ?> options) {
        return (AuthorizationHandler.Authorization)options.get(OPTION_PROXY_AUTHORIZATION);
    }

    private static IOException createIOException(String url, Throwable cause) {
        String message = cause.getMessage();
        if (message != null && message.contains(url)) {
            if (cause instanceof IOException) {
                return (IOException)cause;
            }
            return new IOExceptionWithCause(cause);
        }
        return new IOExceptionWithCause(String.valueOf(StringUtil.isEmpty((String)message) ? "Error: " : String.valueOf(message) + ": ") + url, cause);
    }

    public static URI transform(URI uri, Map<Object, Object> options) {
        return Main.transform(uri, options);
    }

    public static void saveProxies() {
        if (CommonPlugin.IS_ECLIPSE_RUNNING) {
            ProxyHelper.saveProxyData();
        }
    }

    static /* synthetic */ CountDownLatch access$2(ECFURIHandlerImpl eCFURIHandlerImpl, URI uRI) throws IOException {
        return eCFURIHandlerImpl.acquireLock(uRI);
    }

    static /* synthetic */ void access$3(ECFURIHandlerImpl eCFURIHandlerImpl, URI uRI, CountDownLatch countDownLatch) {
        eCFURIHandlerImpl.releaseLock(uRI, countDownLatch);
    }

    static /* synthetic */ CacheHandling access$4(Map map) {
        return ECFURIHandlerImpl.getCacheHandling(map);
    }

    static /* synthetic */ URIConverter access$5(ECFURIHandlerImpl eCFURIHandlerImpl, Map map) {
        return eCFURIHandlerImpl.getURIConverter(map);
    }

    static /* synthetic */ Map access$7() {
        return EXPECTED_EXCEPTIONS;
    }

    static /* synthetic */ boolean access$8() {
        return loggedBlockedURI;
    }

    static /* synthetic */ void access$9(boolean bl) {
        loggedBlockedURI = bl;
    }

    static /* synthetic */ IContainer access$10(ECFURIHandlerImpl eCFURIHandlerImpl) throws IOException {
        return eCFURIHandlerImpl.createContainer();
    }

    static /* synthetic */ AuthorizationHandler access$11(ECFURIHandlerImpl eCFURIHandlerImpl, Map map) {
        return eCFURIHandlerImpl.getAuthorizatonHandler(map);
    }

    static /* synthetic */ AuthorizationHandler.Authorization access$12(Map map) {
        return ECFURIHandlerImpl.getAuthorizaton(map);
    }

    static /* synthetic */ AuthorizationHandler.Authorization access$13(Map map) {
        return ECFURIHandlerImpl.getProxyAuthorizaton(map);
    }

    static /* synthetic */ IOException access$14(String string, Throwable throwable) {
        return ECFURIHandlerImpl.createIOException(string, throwable);
    }

    public static interface AuthorizationHandler {
        public Authorization authorize(URI var1);

        public Authorization reauthorize(URI var1, Authorization var2);

        public static final class Authorization {
            public static final Authorization UNAUTHORIZED = new Authorization("", "");
            public static final Authorization UNAUTHORIZEABLE = new Authorization("", "");
            private final String user;
            private final String password;

            public Authorization(String user, String password) {
                this.user = user == null ? "" : user;
                this.password = this.obscure(password == null ? "" : password);
            }

            public String getUser() {
                return this.user;
            }

            public String getPassword() {
                return this.unobscure(this.password);
            }

            public String getAuthorization() {
                return "Basic " + this.obscure(this.user.length() == 0 ? this.getPassword() : String.valueOf(this.user) + ":" + this.getPassword());
            }

            public boolean isAuthorized() {
                return !"".equals(this.password);
            }

            public boolean isUnauthorizeable() {
                return this == UNAUTHORIZEABLE;
            }

            private String obscure(String string) {
                return XMLTypeFactory.eINSTANCE.convertBase64Binary(string.getBytes());
            }

            private String unobscure(String string) {
                return new String(XMLTypeFactory.eINSTANCE.createBase64Binary(string));
            }

            public int hashCode() {
                int result = 1;
                result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
                result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                if (this == UNAUTHORIZEABLE) {
                    return obj == UNAUTHORIZEABLE;
                }
                Authorization other = (Authorization)obj;
                if (!this.user.equals(other.user)) {
                    return false;
                }
                return this.password.equals(other.password);
            }

            public String toString() {
                return this == UNAUTHORIZEABLE ? "Authorization [unauthorizeable]" : "Authorization [user=" + this.user + ", password=" + this.password + "]";
            }
        }
    }

    public static class AuthorizationHandlerImpl
    implements AuthorizationHandler {
        private final Map<String, AuthorizationHandler.Authorization> authorizations = new HashMap<String, AuthorizationHandler.Authorization>();
        private final UIServices uiServices;
        private ISecurePreferences securePreferences;

        public AuthorizationHandlerImpl(UIServices uiServices, ISecurePreferences securePreferences) {
            this.uiServices = uiServices;
            this.securePreferences = securePreferences;
        }

        public synchronized void clearCache() {
            this.authorizations.clear();
        }

        public synchronized AuthorizationHandler.Authorization authorize(URI uri) {
            String host = ECFURIHandlerImpl.getHost(uri);
            if (host != null) {
                AuthorizationHandler.Authorization cachedAuthorization = this.authorizations.get(host);
                if (cachedAuthorization == AuthorizationHandler.Authorization.UNAUTHORIZEABLE) {
                    return cachedAuthorization;
                }
                if (this.securePreferences != null) {
                    try {
                        ISecurePreferences node = this.securePreferences.node(host);
                        String user = node.get("user", "");
                        String password = node.get("password", "");
                        AuthorizationHandler.Authorization authorization = new AuthorizationHandler.Authorization(user, password);
                        if (authorization.isAuthorized()) {
                            this.authorizations.put(host, authorization);
                            return authorization;
                        }
                    }
                    catch (StorageException ex) {
                        SetupCorePlugin.INSTANCE.log(ex);
                    }
                }
                if (cachedAuthorization != null) {
                    return cachedAuthorization;
                }
            }
            return AuthorizationHandler.Authorization.UNAUTHORIZED;
        }

        public synchronized AuthorizationHandler.Authorization reauthorize(URI uri, AuthorizationHandler.Authorization authorization) {
            String host;
            AuthorizationHandler.Authorization currentAuthorization = this.authorize(uri);
            if (!currentAuthorization.equals(authorization) || currentAuthorization == AuthorizationHandler.Authorization.UNAUTHORIZEABLE) {
                return currentAuthorization;
            }
            if (this.uiServices != null && (host = ECFURIHandlerImpl.getHost(uri)) != null) {
                String password;
                UIServices.AuthenticationInfo authenticationInfo = this.uiServices.getUsernamePassword(uri.toString());
                String user = authenticationInfo.getUserName();
                AuthorizationHandler.Authorization reauthorization = new AuthorizationHandler.Authorization(user, password = authenticationInfo.getPassword());
                if (reauthorization.isAuthorized()) {
                    if (authenticationInfo.saveResult() && this.securePreferences != null) {
                        try {
                            ISecurePreferences node = this.securePreferences.node(host);
                            node.put("user", user, false);
                            node.put("password", password, true);
                            node.flush();
                        }
                        catch (IOException ex) {
                            SetupCorePlugin.INSTANCE.log(ex);
                        }
                        catch (StorageException ex) {
                            SetupCorePlugin.INSTANCE.log(ex);
                        }
                    }
                    this.authorizations.put(host, reauthorization);
                    return reauthorization;
                }
                this.authorizations.put(host, AuthorizationHandler.Authorization.UNAUTHORIZEABLE);
                return AuthorizationHandler.Authorization.UNAUTHORIZEABLE;
            }
            return currentAuthorization;
        }

        public String toString() {
            StringBuilder result = new StringBuilder(super.toString());
            result.append(" authorizations: ");
            result.append(this.authorizations);
            result.append(" securePreferences: ");
            result.append(this.securePreferences);
            result.append(" uiServices: ");
            result.append(this.uiServices);
            return result.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CacheHandling {
        CACHE_ONLY,
        CACHE_WITHOUT_ETAG_CHECKING,
        CACHE_WITH_ETAG_CHECKING,
        CACHE_IGNORE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ConnectionHandler<T> {
        protected URI uri;
        protected final Map<?, ?> options;
        protected String tracePrefix;

        public ConnectionHandler(URI uri, Map<?, ?> options) throws IOException {
            this.uri = uri;
            this.options = options;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public T process() throws IOException {
            transformedOptions = new HashMap<Object, Object>(this.options);
            this.uri = ECFURIHandlerImpl.transform(this.uri, transformedOptions);
            loginURI = (URI)transformedOptions.get("OPTION_LOGIN_URI");
            if (loginURI != null) {
                try {
                    inputStream = ECFURIHandlerImpl.this.createInputStream(loginURI, this.options);
                    inputStream.close();
                }
                catch (IOException v0) {}
            }
            this.tracePrefix = "> ECF: " + this.uri;
            monitor = (IProgressMonitor)this.options.get("OPTION_MONITOR");
            countDownLatch = ECFURIHandlerImpl.access$2(ECFURIHandlerImpl.this, this.uri);
            try {
                block44: {
                    cacheHandling = ECFURIHandlerImpl.access$4(this.options);
                    uriConverter = ECFURIHandlerImpl.access$5(ECFURIHandlerImpl.this, this.options);
                    cacheURI = ECFURIHandlerImpl.getCacheFile(this.uri);
                    eTag = cacheHandling == CacheHandling.CACHE_IGNORE ? null : ECFURIHandlerImpl.getETag(uriConverter, cacheURI);
                    v1 = expectedETag = cacheHandling == CacheHandling.CACHE_IGNORE ? null : ECFURIHandlerImpl.getExpectedETag(this.uri);
                    if (ECFURIHandlerImpl.access$6()) {
                        System.out.println(String.valueOf(this.tracePrefix) + " uri=" + this.uri);
                        System.out.println(String.valueOf(this.tracePrefix) + " cacheURI=" + cacheURI);
                        System.out.println(String.valueOf(this.tracePrefix) + " eTag=" + eTag);
                        System.out.println(String.valueOf(this.tracePrefix) + " expectedETag=" + expectedETag);
                    }
                    host = ECFURIHandlerImpl.access$0(this.uri);
                    v2 = isBlockedEclipseGitURI = SetupUtil.SETUP_ARCHIVER_APPLICATION == false && "git.eclipse.org".equals(host) != false;
                    if (isBlockedEclipseGitURI && uriConverter.exists(cacheURI, this.options)) {
                        cacheHandling = CacheHandling.CACHE_ONLY;
                    }
                    if ("-1".equals(expectedETag)) {
                        throw (IOException)ECFURIHandlerImpl.access$7().get(this.uri);
                    }
                    if (expectedETag == null && cacheHandling != CacheHandling.CACHE_ONLY && cacheHandling != CacheHandling.CACHE_WITHOUT_ETAG_CHECKING || !(cacheHandling == CacheHandling.CACHE_ONLY || cacheHandling == CacheHandling.CACHE_WITHOUT_ETAG_CHECKING ? eTag != null : expectedETag.equals(eTag) != false)) ** GOTO lbl38
                    try {
                        var25_12 = this.handleCache(uriConverter, cacheURI, expectedETag);
                    }
                    catch (IOException v3) {
                        if (ECFURIHandlerImpl.access$6()) {
                            System.out.println(String.valueOf(this.tracePrefix) + " unable to load cached content");
                        }
lbl38:
                        // 4 sources

                        if (!isBlockedEclipseGitURI) break block44;
                        var12_17 = this;
                        synchronized (var12_17) {
                            if (!ECFURIHandlerImpl.access$8()) {
                                launcher = OS.getCurrentLauncher((boolean)true);
                                if (launcher == null) {
                                    launcher = "eclipse";
                                }
                                SetupCorePlugin.INSTANCE.log("The Eclipse Git-hosted URI '" + this.uri + "' is blocked for direct access." + StringUtil.NL + "Please open a Bugzilla to add it to an official Oomph catalog." + StringUtil.NL + "For initial testing, use the file system local version of the resource." + StringUtil.NL + "Alternatively, run the setup archiver application as follows:" + StringUtil.NL + "  " + launcher + " -application org.eclipse.oomph.setup.core.SetupArchiver -consoleLog -noSplash -uris " + this.uri, 2);
                                ECFURIHandlerImpl.access$9(true);
                            }
                        }
                        var25_13 = this.handleEclipseGit();
                    }
                    return var25_12;
                    return var25_13;
                }
                proxyWrapper = ProxyWrapper.create(this.uri);
                container = ECFURIHandlerImpl.access$10(ECFURIHandlerImpl.this);
                authorizationHandler = ECFURIHandlerImpl.access$11(ECFURIHandlerImpl.this, this.options);
                authorization = ECFURIHandlerImpl.access$12(this.options);
                if (authorization == null && authorizationHandler != null) {
                    authorization = authorizationHandler.authorize(this.uri);
                }
                proxyAuthorization = ECFURIHandlerImpl.access$13(this.options);
                if (proxyWrapper.isProxified() && proxyAuthorization == null && authorizationHandler != null) {
                    proxyAuthorization = authorizationHandler.authorize(proxyWrapper.getProxyURI());
                }
                if (proxyWrapper.isProxified() && !proxyWrapper.hasAuthorization() && proxyAuthorization != null && proxyAuthorization.isAuthorized()) {
                    proxyWrapper.authorize(proxyAuthorization);
                }
                if (ECFURIHandlerImpl.access$6()) {
                    if (proxyWrapper.isProxified()) {
                        System.out.println(String.valueOf(this.tracePrefix) + " proxy=" + proxyWrapper);
                    }
                    System.out.println(String.valueOf(this.tracePrefix) + " authorizationHandler=" + authorizationHandler);
                }
                triedReauthorization = 0;
                triedProxyReauthorization = 0;
                i = 0;
                while (true) {
                    block45: {
                        block46: {
                            block47: {
                                if (ECFURIHandlerImpl.access$6()) {
                                    System.out.println(String.valueOf(this.tracePrefix) + " trying=" + i);
                                    System.out.println(String.valueOf(this.tracePrefix) + " triedReauthorization=" + triedReauthorization);
                                    System.out.println(String.valueOf(this.tracePrefix) + " authorization=" + authorization);
                                    System.out.println(String.valueOf(this.tracePrefix) + " triedProxyReauthorization=" + triedProxyReauthorization);
                                    System.out.println(String.valueOf(this.tracePrefix) + " proxyAuthorization=" + proxyAuthorization);
                                }
                                transferListener = this.createConnectionListener(container, proxyWrapper, authorization, eTag, monitor);
                                try {
                                    fileTransferID = new FileTransferID((Namespace)new FileTransferNamespace(), ProxyWrapper.access$0(proxyWrapper));
                                    this.sendConnectionRequest(fileTransferID, host);
                                }
                                catch (ECFException ex) {
                                    if (ECFURIHandlerImpl.access$6()) {
                                        System.out.println(String.valueOf(this.tracePrefix) + " " + ex.getClass().getSimpleName());
                                        ex.printStackTrace(System.out);
                                    }
                                    throw ECFURIHandlerImpl.access$14(this.uri.toString(), ex);
                                }
                                try {
                                    transferListener.await();
                                }
                                catch (InterruptedException ex) {
                                    if (ECFURIHandlerImpl.access$6()) {
                                        System.out.println(String.valueOf(this.tracePrefix) + " InterruptedException");
                                        ex.printStackTrace(System.out);
                                    }
                                    throw ECFURIHandlerImpl.access$14(this.uri.toString(), ex);
                                }
                                exception = transferListener.getException();
                                if (exception == null) ** GOTO lbl139
                                if (ECFURIHandlerImpl.access$6()) {
                                    System.out.println(String.valueOf(this.tracePrefix) + " transferLister.exception");
                                    exception.printStackTrace(System.out);
                                }
                                if (exception instanceof UserCancelledException) ** GOTO lbl129
                                if ((exception instanceof SocketTimeoutException || exception.getCause() instanceof SocketTimeoutException) && i < 2) break block45;
                                if (authorizationHandler == null || !transferListener.hasTransferException()) ** GOTO lbl-1000
                                errorCode = transferListener.getErrorCode();
                                if (ECFURIHandlerImpl.access$6()) {
                                    System.out.println(String.valueOf(this.tracePrefix) + " errorCode=" + errorCode);
                                }
                                if (errorCode != 407 || !proxyWrapper.isProxified()) break block46;
                                if (proxyAuthorization != null || !(proxyAuthorization = authorizationHandler.authorize(proxyWrapper.getProxyURI())).isAuthorized()) break block47;
                                proxyWrapper.authorize(proxyAuthorization);
                                --i;
                                break block45;
                            }
                            if (proxyAuthorization.isUnauthorizeable() || triedProxyReauthorization++ >= 3 || !(proxyAuthorization = authorizationHandler.reauthorize(proxyWrapper.getProxyURI(), proxyAuthorization)).isAuthorized()) ** GOTO lbl-1000
                            proxyWrapper.authorize(proxyAuthorization);
                            --i;
                            break block45;
                        }
                        if (errorCode != 401 && (!"api.github.com".equals(ECFURIHandlerImpl.access$0(this.uri)) || errorCode != 404)) ** GOTO lbl-1000
                        if (authorization == null && (authorization = authorizationHandler.authorize(this.uri)).isAuthorized()) {
                            --i;
                        } else if (!authorization.isUnauthorizeable() && triedReauthorization++ < 3 && (authorization = authorizationHandler.reauthorize(this.uri, authorization)).isAuthorized()) {
                            --i;
                        } else lbl-1000:
                        // 4 sources

                        {
                            if (transferListener.hasTransferException() && (errorCode = transferListener.getErrorCode()) == 405 && (result = this.handleBadMethod(this.options)) != null) {
                                var25_14 = result;
                                return var25_14;
                            }
lbl129:
                            // 3 sources

                            if (!CacheHandling.CACHE_IGNORE.equals((Object)cacheHandling) && uriConverter.exists(cacheURI, this.options) && (!transferListener.hasTransferException() || transferListener.getErrorCode() != 404) || this.uri.equals(SetupContext.INDEX_SETUP_ARCHIVE_LOCATION_URI) || loginURI != null) {
                                var25_15 = this.handleCache(uriConverter, cacheURI, eTag);
                                return var25_15;
                            }
                            if (ECFURIHandlerImpl.access$6()) {
                                System.out.println(String.valueOf(this.tracePrefix) + " failing");
                            }
                            ioException = ECFURIHandlerImpl.access$14(this.uri.toString(), transferListener.getException());
                            ECFURIHandlerImpl.access$7().put(this.uri, ioException);
                            ECFURIHandlerImpl.setExpectedETag(this.uri, "-1");
                            throw ioException;
lbl139:
                            // 1 sources

                            proxyWrapper.update();
                            var25_16 = this.handleResult(uriConverter, cacheURI);
                            return var25_16;
                        }
                    }
                    ++i;
                }
                {
                    catch (Throwable var24_34) {
                        throw var24_34;
                    }
                }
            }
            finally {
                ECFURIHandlerImpl.access$3(ECFURIHandlerImpl.this, this.uri, countDownLatch);
            }
        }

        protected abstract T handleCache(URIConverter var1, URI var2, String var3) throws IOException;

        protected abstract T handleEclipseGit() throws IOException;

        protected abstract ConnectionListener createConnectionListener(IContainer var1, ProxyWrapper var2, AuthorizationHandler.Authorization var3, String var4, IProgressMonitor var5);

        protected abstract void sendConnectionRequest(FileTransferID var1, String var2) throws ECFException;

        protected T handleBadMethod(Map<?, ?> options) {
            return null;
        }

        protected abstract T handleResult(URIConverter var1, URI var2) throws IOException;
    }

    public static interface ConnectionListener {
        public void await() throws InterruptedException;

        public Exception getException();

        public boolean hasTransferException();

        public int getErrorCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ETagMirror
    extends WorkerPool<ETagMirror, URI, Worker> {
        private static final Map<Object, Object> OPTIONS;
        private static final URIConverter URI_CONVERTER;
        private static final String OPTION_ETAG_MIRROR = "OPTION_ETAG_MIRROR";
        private Set<? extends URI> uris;
        private Map<Object, Object> options = new HashMap<Object, Object>(OPTIONS);

        static {
            ResourceSet resourceSet = SetupCoreUtil.createResourceSet();
            OPTIONS = resourceSet.getLoadOptions();
            OPTIONS.put(ECFURIHandlerImpl.OPTION_CACHE_HANDLING, (Object)CacheHandling.CACHE_WITH_ETAG_CHECKING);
            URI_CONVERTER = resourceSet.getURIConverter();
        }

        public ETagMirror() {
            this.options.put(OPTION_ETAG_MIRROR, (Object)this);
        }

        protected Worker createWorker(URI key, int workerID, boolean secondary) {
            return new Worker("ETag Mirror " + key, this, key, workerID, secondary);
        }

        public void begin(Set<? extends URI> uris, IProgressMonitor monitor) {
            this.options.put(ECFURIHandlerImpl.OPTION_MONITOR, monitor);
            this.uris = uris;
            int size = uris.size();
            monitor.beginTask("Mirroring " + size + " resource" + (size == 1 ? "" : "s"), uris.size());
            super.begin("Mirroring", monitor);
        }

        protected void run(String taskName, IProgressMonitor monitor) {
            this.perform(this.uris);
        }

        protected void cacheUpdated(URI uri) {
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Worker
        extends WorkerPool.Worker<URI, ETagMirror> {
            protected Worker(String name, ETagMirror workPool, URI key, int id, boolean secondary) {
                super(name, (WorkerPool)workPool, (Object)key, id, secondary);
            }

            protected IStatus perform(IProgressMonitor monitor) {
                URI key = (URI)this.getKey();
                ETagMirror workPool = (ETagMirror)this.getWorkPool();
                IProgressMonitor workpoolMonitor = workPool.getMonitor();
                try {
                    workpoolMonitor.subTask("Mirroring " + key);
                }
                catch (Exception ex) {
                    SetupCorePlugin.INSTANCE.log(ex, 2);
                }
                try {
                    try {
                        URI_CONVERTER.createInputStream(key, workPool.options).close();
                    }
                    catch (IOException ex) {
                        SetupCorePlugin.INSTANCE.log(ex, 2);
                        try {
                            workpoolMonitor.worked(1);
                        }
                        catch (Exception ex2) {
                            SetupCorePlugin.INSTANCE.log(ex2, 2);
                        }
                    }
                }
                finally {
                    try {
                        workpoolMonitor.worked(1);
                    }
                    catch (Exception ex) {
                        SetupCorePlugin.INSTANCE.log(ex, 2);
                    }
                }
                return Status.OK_STATUS;
            }
        }
    }

    private static final class FileTransferListener
    implements IFileTransferListener,
    ConnectionListener {
        private static final BasicCookieStore COOKIE_STORE = new BasicCookieStore();
        public final CountDownLatch receiveLatch = new CountDownLatch(1);
        public final String expectedETag;
        public String eTag;
        public ByteArrayOutputStream out;
        public long lastModified;
        public Exception exception;
        private IProgressMonitor monitor;

        public FileTransferListener(String expectedETag, IProgressMonitor monitor) {
            this.expectedETag = expectedETag;
            this.monitor = monitor;
        }

        public void handleTransferEvent(IFileTransferEvent event) {
            if (event instanceof IFileTransferConnectStartEvent) {
                IFileTransferConnectStartEvent connectStartEvent = (IFileTransferConnectStartEvent)event;
                if (this.monitor != null && this.monitor.isCanceled()) {
                    connectStartEvent.cancel();
                    this.exception = new UserCancelledException();
                    this.receiveLatch.countDown();
                    return;
                }
                FileTransferListener.applyCookieStore(connectStartEvent);
            } else if (event instanceof IIncomingFileTransferReceiveStartEvent) {
                IIncomingFileTransferReceiveStartEvent receiveStartEvent = (IIncomingFileTransferReceiveStartEvent)event;
                if (this.monitor != null && this.monitor.isCanceled()) {
                    receiveStartEvent.cancel();
                    this.exception = new UserCancelledException();
                    this.receiveLatch.countDown();
                    return;
                }
                this.out = new ByteArrayOutputStream();
                Map responseHeaders = receiveStartEvent.getResponseHeaders();
                if (responseHeaders != null) {
                    Date date;
                    this.eTag = (String)responseHeaders.get("ETag");
                    String lastModifiedValue = (String)responseHeaders.get("Last-Modified");
                    if (lastModifiedValue != null && (date = ECFURIHandlerImpl.parseHTTPDate(lastModifiedValue.toString())) != null) {
                        this.lastModified = date.getTime();
                        if (this.eTag == null) {
                            this.eTag = Long.toString(this.lastModified);
                        }
                    }
                    if (this.lastModified == 0L) {
                        this.lastModified = System.currentTimeMillis();
                        if (this.eTag == null) {
                            this.eTag = Long.toString(this.lastModified);
                        }
                    }
                    if (this.expectedETag != null && this.expectedETag.equals(this.eTag)) {
                        receiveStartEvent.cancel();
                        this.exception = new UserCancelledException();
                        this.receiveLatch.countDown();
                        return;
                    }
                }
                try {
                    receiveStartEvent.receive((OutputStream)this.out);
                }
                catch (IOException ex) {
                    this.exception = ex;
                }
            } else if (event instanceof IIncomingFileTransferReceiveDoneEvent) {
                IIncomingFileTransferReceiveDoneEvent done = (IIncomingFileTransferReceiveDoneEvent)event;
                Exception ex = done.getException();
                if (ex != null && this.exception == null) {
                    this.exception = ex;
                }
                this.receiveLatch.countDown();
            }
        }

        private static void applyCookieStore(IFileTransferConnectStartEvent connectStartEvent) {
            IIncomingFileTransfer fileTransfer = (IIncomingFileTransfer)connectStartEvent.getAdapter(IIncomingFileTransfer.class);
            final IFileID fileID = connectStartEvent.getFileID();
            try {
                if (fileTransfer != null) {
                    Object httpClient = ReflectUtil.getValue((String)"httpClient", (Object)fileTransfer);
                    ReflectUtil.setValue((String)"cookieStore", (Object)httpClient, (Object)new CookieStore(){

                        public List<Cookie> getCookies() {
                            return COOKIE_STORE.getCookies();
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public boolean clearExpired(Date date) {
                            BasicCookieStore basicCookieStore = COOKIE_STORE;
                            synchronized (basicCookieStore) {
                                ArrayList originalCookies = new ArrayList(COOKIE_STORE.getCookies());
                                COOKIE_STORE.clearExpired(date);
                                List remainingCookies = COOKIE_STORE.getCookies();
                                originalCookies.removeAll(remainingCookies);
                                for (Cookie cookie : originalCookies) {
                                    ECFURIHandlerImpl.COOKIE_STORE.remove(null, new HttpCookie(cookie.getName(), cookie.getValue()));
                                }
                                return !originalCookies.isEmpty();
                            }
                        }

                        public void clear() {
                            COOKIE_STORE.clear();
                            ECFURIHandlerImpl.COOKIE_STORE.removeAll();
                        }

                        public void addCookie(Cookie cookie) {
                            try {
                                java.net.URI uri = fileID.getURI();
                                ECFURIHandlerImpl.COOKIE_STORE.add(uri, new HttpCookie(cookie.getName(), cookie.getValue()));
                            }
                            catch (Exception exception) {}
                            COOKIE_STORE.addCookie(cookie);
                        }
                    });
                }
            }
            catch (Throwable throwable) {}
        }

        public void await() throws InterruptedException {
            this.receiveLatch.await();
        }

        public Exception getException() {
            return this.exception;
        }

        public boolean hasTransferException() {
            return this.exception instanceof IncomingFileTransferException;
        }

        public int getErrorCode() {
            return ((IncomingFileTransferException)this.exception).getErrorCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InputStreamConnectionHandler
    extends ConnectionHandler<InputStream> {
        private IRetrieveFileTransferContainerAdapter fileTransfer;
        private FileTransferListener transferListener;

        public InputStreamConnectionHandler(URI uri, Map<?, ?> options) throws IOException {
            super(uri, options);
        }

        @Override
        protected InputStream handleCache(URIConverter uriConverter, URI cacheURI, String expectedETag) throws IOException {
            ECFURIHandlerImpl.setExpectedETag(this.uri, this.transferListener == null ? expectedETag : (this.transferListener.eTag == null ? (expectedETag == null ? Long.toString(System.currentTimeMillis()) : expectedETag) : this.transferListener.eTag));
            InputStream result = uriConverter.createInputStream(cacheURI, this.options);
            if (TRACE) {
                System.out.println(String.valueOf(this.tracePrefix) + " returning cached content");
            }
            return result;
        }

        @Override
        protected InputStream handleEclipseGit() throws IOException {
            throw new IOException("Eclipse Git access blocked: " + this.uri);
        }

        @Override
        protected ConnectionListener createConnectionListener(IContainer container, ProxyWrapper proxyWrapper, AuthorizationHandler.Authorization authorization, String eTag, IProgressMonitor monitor) {
            this.fileTransfer = (IRetrieveFileTransferContainerAdapter)container.getAdapter(IRetrieveFileTransferContainerAdapter.class);
            this.fileTransfer.setProxy(proxyWrapper.getProxy());
            if (authorization != null && authorization.isAuthorized()) {
                this.fileTransfer.setConnectContextForAuthentication(ConnectContextFactory.createUsernamePasswordConnectContext((String)authorization.getUser(), (Object)authorization.getPassword()));
            }
            this.transferListener = new FileTransferListener(eTag, monitor);
            return this.transferListener;
        }

        @Override
        protected void sendConnectionRequest(FileTransferID fileTransferID, String host) throws ECFException {
            HashMap<String, Serializable> requestOptions = new HashMap<String, Serializable>();
            requestOptions.put(IRetrieveFileTransferOptions.CONNECT_TIMEOUT, Integer.valueOf(CONNECT_TIMEOUT));
            requestOptions.put(IRetrieveFileTransferOptions.READ_TIMEOUT, Integer.valueOf(READ_TIMEOUT));
            if (!StringUtil.isEmpty((String)USER_AGENT) && host != null && host.endsWith(".eclipse.org")) {
                HashMap<String, String> requestHeaders = new HashMap<String, String>();
                requestOptions.put(IRetrieveFileTransferOptions.REQUEST_HEADERS, requestHeaders);
                requestHeaders.put("User-Agent", USER_AGENT);
            }
            this.fileTransfer.sendRetrieveRequest((IFileID)fileTransferID, (IFileTransferListener)this.transferListener, requestOptions);
        }

        @Override
        protected InputStream handleResult(URIConverter uriConverter, URI cacheURI) throws IOException {
            ETagMirror etagMirror;
            byte[] bytes;
            block12: {
                int end;
                String value;
                int start22;
                bytes = this.transferListener.out.toByteArray();
                if (ECFURIHandlerImpl.API_GITHUB_HOST.equals(ECFURIHandlerImpl.getHost(this.uri)) && (start22 = (value = new String(bytes, "UTF-8")).indexOf(ECFURIHandlerImpl.CONTENT_TAG)) != -1 && (end = value.indexOf(34, start22 += ECFURIHandlerImpl.CONTENT_TAG.length())) != -1) {
                    String content = value.substring(start22, end);
                    String[] split = content.split("\\\\n");
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    String[] stringArray = split;
                    int n = split.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        byte[] binary = XMLTypeFactory.eINSTANCE.createBase64Binary(line);
                        out.write(binary);
                        ++n2;
                    }
                    out.close();
                    bytes = out.toByteArray();
                }
                try {
                    try {
                        if (TRACE) {
                            System.out.println(String.valueOf(this.tracePrefix) + " writing cache");
                        }
                        BaseUtil.writeFile((URIConverter)uriConverter, (Map)this.options, (URI)cacheURI, (byte[])bytes);
                    }
                    catch (IORuntimeException ex) {
                        this.transferListener.eTag = null;
                        if (TRACE) {
                            System.out.println(String.valueOf(this.tracePrefix) + " failed writing cache");
                            ex.printStackTrace(System.out);
                        }
                        ECFURIHandlerImpl.setETag(uriConverter, cacheURI, this.transferListener.eTag);
                        break block12;
                    }
                }
                catch (Throwable start22) {
                    ECFURIHandlerImpl.setETag(uriConverter, cacheURI, this.transferListener.eTag);
                    throw start22;
                }
                ECFURIHandlerImpl.setETag(uriConverter, cacheURI, this.transferListener.eTag);
            }
            ECFURIHandlerImpl.setExpectedETag(this.uri, this.transferListener.eTag);
            Map response = ECFURIHandlerImpl.this.getResponse(this.options);
            if (response != null) {
                response.put("TIME_STAMP", this.transferListener.lastModified);
            }
            if ((etagMirror = (ETagMirror)((Object)this.options.get("OPTION_ETAG_MIRROR"))) != null) {
                etagMirror.cacheUpdated(this.uri);
            }
            if (TRACE) {
                System.out.println(String.valueOf(this.tracePrefix) + " returning successful results");
            }
            return new ByteArrayInputStream(bytes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Main {
        public static void main(String[] args) throws Exception {
            URI expectedURI = URI.createURI((String)"https://example.com/gerrit/gitweb?p=EXAMPLE.git;a=blob_plain;f=Src/com.example.releng/example.setup;hb=HEAD");
            URI inputURI = URI.createURI((String)"https://user:password@example.com:1234/gerrit/gitweb/EXAMPLE.git/Src/com.example.releng/example.setup?oomph=b[0..1];oomph_login=s://a/[0..1]/'login';oomph-p=[2];oomph-f=[3..];a=blob_plain;hb=HEAD;oomph-s=s;oomph-S=S;oomph-u=u;oomph-U=U;oomph-h=h;oomph--p=p;oomph-P=P;oomph-a=a;oomph-b=b;oomph-text='text';oomph-quote='';oomph-slash=/;oomph-colon=:;oomph-r1=[1];oomph-r2=[2];oomph-r3=[-1];oomph-r4=[-3..-1];oomph-r5=[-2..]");
            inputURI = URI.createURI((String)"https://example.com/gerrit/gitweb/EXAMPLE.git/Src/com.example.releng/example.setup?oomph=b[0..1];oomph_login=b[0]/'login';oomph-p=[2];oomph-f=[3..];a=blob_plain;hb=HEAD");
            new java.net.URI(inputURI.toString());
            HashMap<Object, Object> options = new HashMap<Object, Object>();
            URI uri = Main.transform(inputURI, options);
            System.err.println(">   " + expectedURI);
            System.err.println(">>  " + inputURI);
            System.err.println(">>> " + uri);
            System.err.println(">>>>" + options.get(ECFURIHandlerImpl.OPTION_LOGIN_URI));
        }

        private static URI transform(URI uri, Map<Object, Object> options) {
            String query = uri.query();
            if (query != null) {
                List parameters = StringUtil.explode((String)query, (String)";");
                if (parameters.isEmpty()) {
                    return uri;
                }
                LinkedHashMap<String, String> arguments = new LinkedHashMap<String, String>();
                for (String parameter : parameters) {
                    List assignment = StringUtil.explode((String)parameter, (String)"=");
                    if (assignment.size() != 2) {
                        return uri;
                    }
                    arguments.put((String)assignment.get(0), (String)assignment.get(1));
                }
                URI outputURI = uri.trimQuery();
                URI loginURI = null;
                LinkedHashMap<String, String> outputQuery = new LinkedHashMap<String, String>();
                for (Map.Entry entry : arguments.entrySet()) {
                    String result;
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if ("oomph".equals(key)) {
                        result = Main.evaluate(value, uri);
                        if (result == null) continue;
                        outputURI = URI.createURI((String)result);
                        continue;
                    }
                    if ("oomph_login".equals(key)) {
                        result = Main.evaluate(value, uri);
                        if (result == null) continue;
                        loginURI = URI.createURI((String)result);
                        continue;
                    }
                    if (key.startsWith("oomph-") && (result = Main.evaluate(value, uri)) != null) {
                        key = key.substring("oomph-".length());
                        value = result;
                    }
                    outputQuery.put(key, value);
                }
                if (!outputQuery.isEmpty()) {
                    StringBuilder queryResult = new StringBuilder();
                    for (Map.Entry entry : outputQuery.entrySet()) {
                        if (queryResult.length() != 0) {
                            queryResult.append(';');
                        }
                        queryResult.append((String)entry.getKey()).append('=').append((String)entry.getValue());
                    }
                    outputURI = outputURI.appendQuery(queryResult.toString());
                }
                if (loginURI != null && options != null) {
                    options.put(ECFURIHandlerImpl.OPTION_LOGIN_URI, loginURI);
                }
                return outputURI;
            }
            return uri;
        }

        private static String evaluate(String expression, URI uri) {
            StringBuilder result = new StringBuilder();
            boolean quote = false;
            int segmentCount = uri.segmentCount();
            int i = 0;
            int length = expression.length();
            while (i < length) {
                char character = expression.charAt(i);
                if (quote && character != '\'') {
                    result.append(character);
                } else {
                    switch (character) {
                        case '\'': {
                            if (i + 1 < length && expression.charAt(i + 1) == '\'') {
                                ++i;
                                result.append('\'');
                                break;
                            }
                            quote = !quote;
                            break;
                        }
                        case 's': {
                            String scheme = uri.scheme();
                            if (scheme == null) {
                                return null;
                            }
                            result.append(scheme);
                            break;
                        }
                        case 'S': {
                            String scheme = uri.scheme();
                            if (scheme == null) break;
                            result.append(scheme).append(':');
                            break;
                        }
                        case 'u': {
                            String userInfo = uri.userInfo();
                            if (userInfo == null) {
                                return null;
                            }
                            result.append(userInfo);
                            break;
                        }
                        case 'U': {
                            String userInfo = uri.userInfo();
                            if (userInfo == null) break;
                            result.append(userInfo).append('@');
                            break;
                        }
                        case 'h': {
                            String host = uri.host();
                            if (host == null) {
                                return null;
                            }
                            result.append(host);
                            break;
                        }
                        case 'p': {
                            String port = uri.port();
                            if (port == null) {
                                return null;
                            }
                            result.append(port);
                            break;
                        }
                        case 'P': {
                            String port = uri.port();
                            if (port == null) break;
                            result.append(':').append(port);
                            break;
                        }
                        case 'a': {
                            String authority = uri.authority();
                            if (authority == null) {
                                return null;
                            }
                            result.append(authority);
                            break;
                        }
                        case 'b': {
                            String base = uri.isHierarchical() ? uri.trimSegments(segmentCount).trimQuery().trimFragment().toString() : String.valueOf(uri.scheme()) + ":";
                            result.append(base);
                            break;
                        }
                        case 'o': {
                            String opaquePart = uri.opaquePart();
                            if (opaquePart == null) {
                                return null;
                            }
                            result.append(opaquePart);
                            break;
                        }
                        case '/': 
                        case ':': {
                            result.append(character);
                            break;
                        }
                        case '[': {
                            int m;
                            if (++i >= length) {
                                return null;
                            }
                            character = expression.charAt(i);
                            boolean negativeN = false;
                            if (character == '-') {
                                negativeN = true;
                                if (++i >= length) {
                                    return null;
                                }
                                character = expression.charAt(i);
                            }
                            if (character < '0' && character > '9') {
                                return null;
                            }
                            int n = 0;
                            while (character >= '0' && character <= '9') {
                                n = 10 * n + character - 48;
                                if (++i >= length) {
                                    return null;
                                }
                                character = expression.charAt(i);
                            }
                            boolean negativeM = false;
                            if (character == '.') {
                                if (++i >= length) {
                                    return null;
                                }
                                character = expression.charAt(i);
                                if (character != '.') {
                                    return null;
                                }
                                if (++i >= length) {
                                    return null;
                                }
                                character = expression.charAt(i);
                                if (character == '-') {
                                    m = 0;
                                    negativeM = true;
                                    if (++i >= length) {
                                        return null;
                                    }
                                    character = expression.charAt(i);
                                    if (character < '0' && character > '9') {
                                        return null;
                                    }
                                } else if (character >= '0' && character <= '9') {
                                    m = 0;
                                } else {
                                    m = 1;
                                    negativeM = true;
                                }
                                while (character >= '0' && character <= '9') {
                                    m = m == Integer.MIN_VALUE ? character - 48 : 10 * m + character - 48;
                                    if (++i >= length) {
                                        return null;
                                    }
                                    character = expression.charAt(i);
                                }
                            } else {
                                m = n;
                                negativeM = negativeN;
                            }
                            if (character != ']') {
                                return null;
                            }
                            if (negativeN) {
                                n = segmentCount - n;
                            }
                            if (negativeM) {
                                m = segmentCount - m;
                            }
                            if (m == Integer.MIN_VALUE) {
                                m = n;
                            } else if (n >= segmentCount || m >= segmentCount || n > m) {
                                return null;
                            }
                            int j = n;
                            while (j <= m) {
                                if (j != n) {
                                    result.append('/');
                                }
                                result.append(uri.segment(j));
                                ++j;
                            }
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                }
                ++i;
            }
            if (quote) {
                return null;
            }
            return result.toString();
        }
    }

    protected static class ProxyHelper {
        private static final Set<IProxyData> PROXY_DATA = new HashSet<IProxyData>();
        private static final IProxyService PROXY_MANAGER = ProxyManager.getProxyManager();

        protected ProxyHelper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ProxyWrapper createProxyWrapper(java.net.URI uri) {
            if (PROXY_MANAGER.isProxiesEnabled()) {
                IProxyService iProxyService = PROXY_MANAGER;
                synchronized (iProxyService) {
                    IProxyData[] proxies = PROXY_MANAGER.select(uri);
                    IProxyData selectedProxy = ProxySetupHelper.selectProxyFromProxies((String)uri.getScheme(), (IProxyData[])proxies);
                    if (selectedProxy != null) {
                        Proxy proxy = new Proxy(selectedProxy.getType().equalsIgnoreCase("SOCKS") ? Proxy.Type.SOCKS : Proxy.Type.HTTP, new ProxyAddress(selectedProxy.getHost(), selectedProxy.getPort()), selectedProxy.getUserId(), selectedProxy.getPassword());
                        return new ProxyWrapper(proxy, selectedProxy, uri);
                    }
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected static void update(Proxy proxy, IProxyData proxyData) {
            if (SetupUtil.INSTALLER_APPLICATION || SetupUtil.SETUP_ARCHIVER_APPLICATION) {
                IProxyService iProxyService = PROXY_MANAGER;
                synchronized (iProxyService) {
                    proxyData.setUserid(proxy.getUsername());
                    proxyData.setPassword(proxy.getPassword());
                    PROXY_DATA.add(proxyData);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected static void saveProxyData() {
            if (!PROXY_DATA.isEmpty()) {
                IProxyService iProxyService = PROXY_MANAGER;
                synchronized (iProxyService) {
                    try {
                        PROXY_MANAGER.setProxyData(PROXY_DATA.toArray(new IProxyData[PROXY_DATA.size()]));
                        PROXY_MANAGER.setSystemProxiesEnabled(false);
                        PROXY_MANAGER.setProxiesEnabled(false);
                        PROXY_MANAGER.setProxiesEnabled(true);
                    }
                    catch (CoreException coreException) {}
                }
                PROXY_DATA.clear();
            }
        }
    }

    private static class ProxyWrapper {
        private Proxy proxy;
        private final IProxyData proxyData;
        private final java.net.URI uri;
        private final URI proxyURI;
        private boolean authorized;

        public ProxyWrapper(Proxy proxy, IProxyData proxyData, java.net.URI uri) {
            this.proxy = proxy;
            this.proxyData = proxyData;
            this.uri = uri;
            if (proxy != null) {
                ProxyAddress address = proxy.getAddress();
                String hostName = address.getHostName();
                int port = address.getPort();
                Proxy.Type type = proxy.getType();
                this.proxyURI = URI.createURI((String)(String.valueOf(type.toString()) + "://" + hostName + ":" + port));
            } else {
                this.proxyURI = null;
            }
        }

        public void authorize(AuthorizationHandler.Authorization proxyAuthorization) {
            this.authorized = true;
            this.proxy = new Proxy(this.proxy.getType(), this.proxy.getAddress(), proxyAuthorization.getUser(), proxyAuthorization.getPassword());
        }

        public static ProxyWrapper create(URI uri) {
            ProxyWrapper proxyWrapper;
            java.net.URI javaNetURI = IOUtil.newURI((String)uri.toString());
            if (CommonPlugin.IS_ECLIPSE_RUNNING && (proxyWrapper = ProxyHelper.createProxyWrapper(javaNetURI)) != null) {
                return proxyWrapper;
            }
            return new ProxyWrapper(null, null, javaNetURI);
        }

        public boolean isProxified() {
            return this.proxy != null;
        }

        public boolean hasAuthorization() {
            return this.proxy != null && !StringUtil.isEmpty((String)this.proxy.getPassword());
        }

        public Proxy getProxy() {
            return this.proxy;
        }

        public URI getProxyURI() {
            return this.proxyURI;
        }

        private java.net.URI getURI() {
            return this.uri;
        }

        public void update() {
            if (this.authorized) {
                ProxyHelper.update(this.proxy, this.proxyData);
            }
        }

        public String toString() {
            if (this.proxyData == null) {
                return "Unproxified";
            }
            StringBuilder stringBuffer = new StringBuilder();
            stringBuffer.append("type: ");
            stringBuffer.append(this.proxyData.getType());
            stringBuffer.append(" host: ");
            stringBuffer.append(this.proxyData.getHost());
            stringBuffer.append(" port: ");
            stringBuffer.append(this.proxyData.getPort());
            stringBuffer.append(" user: ");
            stringBuffer.append(this.proxyData.getUserId());
            stringBuffer.append(" password: ");
            String password = this.proxyData.getPassword();
            stringBuffer.append(password == null ? "" : XMLTypeFactory.eINSTANCE.convertBase64Binary(password.getBytes()));
            stringBuffer.append(" reqAuth: ");
            stringBuffer.append(this.proxyData.isRequiresAuthentication());
            return stringBuffer.toString();
        }

        static /* synthetic */ java.net.URI access$0(ProxyWrapper proxyWrapper) {
            return proxyWrapper.getURI();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RemoteAttributionsConnectionHandler
    extends ConnectionHandler<Map<String, ?>> {
        private IRemoteFileSystemBrowserContainerAdapter fileBrowser;
        private RemoteFileSystemListener fileSystemListener;
        private final Set<String> requestedAttributes;

        public RemoteAttributionsConnectionHandler(URI uri, Map<?, ?> options) throws IOException {
            super(uri, options);
            this.requestedAttributes = ECFURIHandlerImpl.this.getRequestedAttributes(options);
        }

        @Override
        protected Map<String, ?> handleCache(URIConverter uriConverter, URI cacheURI, String expectedETag) throws IOException {
            Map result = ECFURIHandlerImpl.this.handleAttributes((Set<String>)this.requestedAttributes, uriConverter.getAttributes(cacheURI, this.options));
            return result;
        }

        @Override
        protected Map<String, ?> handleEclipseGit() throws IOException {
            return Collections.emptyMap();
        }

        @Override
        protected ConnectionListener createConnectionListener(IContainer container, ProxyWrapper proxyWrapper, AuthorizationHandler.Authorization authorization, String eTag, IProgressMonitor monitor) {
            this.fileBrowser = (IRemoteFileSystemBrowserContainerAdapter)container.getAdapter(IRemoteFileSystemBrowserContainerAdapter.class);
            this.fileBrowser.setProxy(proxyWrapper.getProxy());
            if (authorization != null && authorization.isAuthorized()) {
                this.fileBrowser.setConnectContextForAuthentication(ConnectContextFactory.createUsernamePasswordConnectContext((String)authorization.getUser(), (Object)authorization.getPassword()));
            }
            this.fileSystemListener = new RemoteFileSystemListener();
            return this.fileSystemListener;
        }

        @Override
        protected void sendConnectionRequest(FileTransferID fileTransferID, String host) throws ECFException {
            this.fileBrowser.sendBrowseRequest((IFileID)fileTransferID, (IRemoteFileSystemListener)this.fileSystemListener);
        }

        @Override
        protected Map<String, ?> handleResult(URIConverter uriConverter, URI cacheURI) throws IOException {
            ECFURIHandlerImpl.API_GITHUB_HOST.equals(ECFURIHandlerImpl.getHost(this.uri));
            return ECFURIHandlerImpl.this.handleAttributes((Set<String>)this.requestedAttributes, this.fileSystemListener.info);
        }

        @Override
        protected Map<String, ?> handleBadMethod(Map<?, ?> options) {
            if (TRACE) {
                System.out.println(String.valueOf(this.tracePrefix) + " unsupported HEAD request");
            }
            HashMap specializedOptions = new HashMap(options);
            HashMap response = new HashMap();
            specializedOptions.put("RESPONSE", response);
            try {
                InputStream inputStream = ECFURIHandlerImpl.this.createInputStream(this.uri, specializedOptions);
                inputStream.close();
                System.out.println(String.valueOf(this.tracePrefix) + " using response from GET request");
                return ECFURIHandlerImpl.this.handleResponseAttributes(this.requestedAttributes, response);
            }
            catch (IOException ex) {
                if (TRACE) {
                    System.out.println(String.valueOf(this.tracePrefix) + " GET request failed");
                    ex.printStackTrace(System.out);
                }
                return null;
            }
        }
    }

    private static final class RemoteFileSystemListener
    implements IRemoteFileSystemListener,
    ConnectionListener {
        public final CountDownLatch receiveLatch = new CountDownLatch(1);
        public Exception exception;
        public IRemoteFileInfo info;

        public void handleRemoteFileEvent(IRemoteFileSystemEvent event) {
            if (event instanceof IRemoteFileSystemBrowseEvent) {
                IRemoteFile[] iRemoteFileArray;
                IRemoteFileSystemBrowseEvent browseEvent = (IRemoteFileSystemBrowseEvent)event;
                this.exception = browseEvent.getException();
                if (this.exception == null && (iRemoteFileArray = browseEvent.getRemoteFiles()).length != 0) {
                    IRemoteFile remoteFile = iRemoteFileArray[0];
                    this.info = remoteFile.getInfo();
                }
                this.receiveLatch.countDown();
            }
        }

        public void await() throws InterruptedException {
            this.receiveLatch.await();
        }

        public Exception getException() {
            return this.exception;
        }

        public boolean hasTransferException() {
            return this.exception instanceof BrowseFileTransferException;
        }

        public int getErrorCode() {
            return ((BrowseFileTransferException)this.exception).getErrorCode();
        }
    }
}

