/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.util.ArrayList;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.configurator.IPlatformConfigurationFactory;
import org.eclipse.update.internal.configurator.FeatureEntry;
import org.eclipse.update.internal.configurator.Messages;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={IBundleGroupProvider.class})
public class BundleGroupComponent
implements IBundleGroupProvider {
    private IPlatformConfigurationFactory factory;

    @Activate
    public BundleGroupComponent(@Reference IPlatformConfigurationFactory factory) {
        this.factory = factory;
    }

    public IBundleGroup[] getBundleGroups() {
        IPlatformConfiguration configuration = this.factory.getCurrentPlatformConfiguration();
        if (configuration == null) {
            return new IBundleGroup[0];
        }
        IPlatformConfiguration.IFeatureEntry[] features = configuration.getConfiguredFeatureEntries();
        ArrayList<IBundleGroup> bundleGroups = new ArrayList<IBundleGroup>(features.length);
        IPlatformConfiguration.IFeatureEntry[] iFeatureEntryArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            IPlatformConfiguration.IFeatureEntry feature = iFeatureEntryArray[n2];
            if (feature instanceof FeatureEntry && ((FeatureEntry)feature).hasBranding()) {
                bundleGroups.add((IBundleGroup)feature);
            }
            ++n2;
        }
        return bundleGroups.toArray(new IBundleGroup[bundleGroups.size()]);
    }

    public String getName() {
        return Messages.BundleGroupProvider;
    }
}

