/*
 * Decompiled with CFR 0.152.
 */
package aQute.libg.qtokens;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class QuotedTokenizer
implements Iterable<String> {
    private static final Pattern TOKEN_P = Pattern.compile("[-\\w]+");
    private final String string;
    private final String separators;
    private final boolean returnTokens;
    private final boolean retainQuotes;
    private int index = 0;
    private String peek;
    private char separator;

    public QuotedTokenizer(String string, String separators, boolean returnTokens, boolean retainQuotes) {
        this.string = Objects.requireNonNull(string, "string argument must be not null");
        this.separators = Objects.requireNonNull(separators, "separators argument must be not null");
        this.returnTokens = returnTokens;
        this.retainQuotes = retainQuotes;
    }

    public QuotedTokenizer(String string, String separators, boolean returnTokens) {
        this(string, separators, returnTokens, false);
    }

    public QuotedTokenizer(String string, String separators) {
        this(string, separators, false);
    }

    private QuotedTokenizer copy() {
        return new QuotedTokenizer(this.string, this.separators, this.returnTokens, this.retainQuotes);
    }

    public String toString() {
        return String.format("\"%s\" - \"%s\" - %s", this.string, this.separators, this.returnTokens);
    }

    public String nextToken(String separators) {
        this.separator = '\u0000';
        if (this.peek != null) {
            String tmp = this.peek;
            this.peek = null;
            return tmp;
        }
        if (this.index == this.string.length()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean hadstring = false;
        boolean escaped = false;
        int lastNonWhitespace = 0;
        while (this.index < this.string.length()) {
            char c = this.string.charAt(this.index++);
            if (escaped) {
                sb.append(c);
                escaped = false;
            } else {
                if (separators.indexOf(c) >= 0) {
                    if (this.returnTokens) {
                        this.peek = Character.toString(c);
                        break;
                    }
                    this.separator = c;
                    break;
                }
                if (Character.isWhitespace(c)) {
                    if (this.index == this.string.length()) break;
                    if (sb.length() <= 0) continue;
                    sb.append(c);
                    continue;
                }
                switch (c) {
                    case '\"': 
                    case '\'': {
                        hadstring = true;
                        this.quotedString(sb, c);
                        break;
                    }
                    case '\\': {
                        escaped = true;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            lastNonWhitespace = sb.length();
        }
        sb.setLength(lastNonWhitespace);
        String result = sb.toString();
        if (!hadstring && result.isEmpty() && this.index == this.string.length()) {
            return null;
        }
        return result;
    }

    public String nextToken() {
        return this.nextToken(this.separators);
    }

    private void quotedString(StringBuilder sb, char quote) {
        boolean retain;
        boolean bl = retain = this.retainQuotes || sb.length() != 0;
        if (retain) {
            sb.append(quote);
        }
        while (this.index < this.string.length()) {
            char c;
            if ((c = this.string.charAt(this.index++)) == quote) {
                if (!retain) break;
                sb.append(quote);
                break;
            }
            if (c == '\\' && this.index < this.string.length()) {
                c = this.string.charAt(this.index++);
                if (retain || c != quote) {
                    sb.append('\\');
                }
            }
            sb.append(c);
        }
    }

    public String[] getTokens() {
        return (String[])QuotedTokenizer.stream(this).toArray(String[]::new);
    }

    public char getSeparator() {
        return this.separator;
    }

    public List<String> getTokenSet() {
        return QuotedTokenizer.stream(this).collect(Collectors.toList());
    }

    public Stream<String> stream() {
        return QuotedTokenizer.stream(this.copy());
    }

    private static Stream<String> stream(QuotedTokenizer qt) {
        return StreamSupport.stream(new TokenSpliterator(qt), false);
    }

    @Override
    public Spliterator<String> spliterator() {
        return new TokenSpliterator(this.copy());
    }

    @Override
    public Iterator<String> iterator() {
        return new TokenIterator(this.copy());
    }

    @Override
    public void forEach(Consumer<? super String> action) {
        String next;
        Objects.requireNonNull(action);
        QuotedTokenizer qt = this.copy();
        while ((next = qt.nextToken()) != null) {
            action.accept(next);
        }
    }

    public static boolean quote(StringBuilder sb, String value) {
        boolean clean;
        if (value.startsWith("\\\"")) {
            value = value.substring(2);
        }
        if (value.endsWith("\\\"")) {
            value = value.substring(0, value.length() - 2);
        }
        if (value.startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        boolean bl = clean = value.length() >= 2 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"' || TOKEN_P.matcher(value).matches();
        if (!clean) {
            sb.append("\"");
        }
        block3: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append('\\').append('\"');
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (!clean) {
            sb.append("\"");
        }
        return clean;
    }

    static final class TokenSpliterator
    extends Spliterators.AbstractSpliterator<String> {
        private final QuotedTokenizer qt;

        TokenSpliterator(QuotedTokenizer qt) {
            super(Long.MAX_VALUE, 272);
            this.qt = qt;
        }

        @Override
        public boolean tryAdvance(Consumer<? super String> action) {
            Objects.requireNonNull(action);
            String next = this.qt.nextToken();
            if (next != null) {
                action.accept(next);
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super String> action) {
            String next;
            Objects.requireNonNull(action);
            while ((next = this.qt.nextToken()) != null) {
                action.accept(next);
            }
        }
    }

    static final class TokenIterator
    implements Iterator<String> {
        private final QuotedTokenizer qt;
        private boolean hasNext = false;
        private String next;

        TokenIterator(QuotedTokenizer qt) {
            this.qt = qt;
        }

        @Override
        public boolean hasNext() {
            if (this.hasNext) {
                return true;
            }
            this.next = this.qt.nextToken();
            this.hasNext = this.next != null;
            return this.hasNext;
        }

        @Override
        public String next() {
            if (this.hasNext()) {
                this.hasNext = false;
                return this.next;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void forEachRemaining(Consumer<? super String> action) {
            String next;
            Objects.requireNonNull(action);
            if (this.hasNext) {
                action.accept(this.next);
                this.hasNext = false;
            }
            while ((next = this.qt.nextToken()) != null) {
                action.accept(next);
            }
        }
    }
}

