/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.provider;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.AttributeValueWrapperItemProvider;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.edit.provider.WrapperItemProvider;
import org.eclipse.oomph.base.provider.ModelElementItemProvider;
import org.eclipse.oomph.targlets.TargletContainer;
import org.eclipse.oomph.targlets.TargletFactory;
import org.eclipse.oomph.targlets.TargletPackage;
import org.eclipse.oomph.targlets.provider.TargletEditPlugin;
import org.eclipse.oomph.util.ReflectUtil;

public class TargletContainerItemProvider
extends ModelElementItemProvider {
    private static final String SEPARATOR = " - ";
    private static long timestamp;
    private static Map<String, String> targetDefinitionInfo;

    public TargletContainerItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addIDPropertyDescriptor(object);
            this.addComposedTargetsPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addIDPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TargletContainer_iD_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TargletContainer_iD_feature", "_UI_TargletContainer_type"), (EStructuralFeature)TargletPackage.Literals.TARGLET_CONTAINER__ID, false, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addComposedTargetsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TargletContainer_composedTargets_feature"), this.getString("_UI_TargletContainer_composedTargets_description"), (EStructuralFeature)TargletPackage.Literals.TARGLET_CONTAINER__COMPOSED_TARGETS, true, false, true, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected Collection<?> filterChoices(Collection<?> choices, EStructuralFeature feature, Object object) {
        Set<String> targetDefinitionNames;
        if (feature == TargletPackage.Literals.TARGLET_CONTAINER__COMPOSED_TARGETS && (targetDefinitionNames = TargletContainerItemProvider.getTargetDefinitionNames()) != null) {
            return targetDefinitionNames;
        }
        return super.filterChoices(choices, feature, object);
    }

    protected boolean isChoiceArbitrary(EStructuralFeature feature, Object object) {
        return feature == TargletPackage.Literals.TARGLET_CONTAINER__COMPOSED_TARGETS || super.isChoiceArbitrary(feature, object);
    }

    protected IItemLabelProvider getLabelProvider(IItemLabelProvider itemLabelProvider, EStructuralFeature feature, Object object) {
        if (feature == TargletPackage.Literals.TARGLET_CONTAINER__COMPOSED_TARGETS) {
            return new ComposedTargetItemLabelProvider();
        }
        return super.getLabelProvider(itemLabelProvider, feature, object);
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(TargletPackage.Literals.TARGLET_CONTAINER__COMPOSED_TARGETS);
            this.childrenFeatures.add(TargletPackage.Literals.TARGLET_CONTAINER__TARGLETS);
        }
        return this.childrenFeatures;
    }

    protected Object createWrapper(EObject object, EStructuralFeature feature, Object value, int index) {
        if (feature == TargletPackage.Literals.TARGLET_CONTAINER__COMPOSED_TARGETS) {
            return TargletContainerItemProvider.createComposedTargetWrapper(object, TargletPackage.Literals.TARGLET_CONTAINER__COMPOSED_TARGETS, (String)value, index, this.adapterFactory, this.getResourceLocator());
        }
        return super.createWrapper(object, feature, value, index);
    }

    protected Command createCreateChildCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value, int index, Collection<?> collection) {
        if (feature == TargletPackage.Literals.TARGLET_CONTAINER__COMPOSED_TARGETS) {
            return TargletContainerItemProvider.createCreateChildComposedTargetCommand(domain, owner, (EStructuralFeature)TargletPackage.Literals.TARGLET_CONTAINER__COMPOSED_TARGETS, value, index, collection, (CreateChildCommand.Helper)this);
        }
        return super.createCreateChildCommand(domain, owner, feature, value, index, collection);
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/TargletContainer"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        String label = ((TargletContainer)object).getID();
        return label == null || label.length() == 0 ? this.getString("_UI_TargletContainer_type") : this.getString("_UI_TargletContainer_type") + " " + label;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(TargletContainer.class)) {
            case 1: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 2: 
            case 3: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(TargletPackage.Literals.TARGLET_CONTAINER__TARGLETS, TargletFactory.eINSTANCE.createTarglet()));
        TargletContainerItemProvider.collectNewChildComposedTargetDescriptors(newChildDescriptors, object, TargletPackage.Literals.TARGLET_CONTAINER__COMPOSED_TARGETS);
    }

    public static Set<String> getTargetDefinitionNames(EObject eObject, EStructuralFeature feature) {
        Set<String> targetDefinitionNames = TargletContainerItemProvider.getTargetDefinitionNames();
        if (targetDefinitionNames != null) {
            targetDefinitionNames.removeAll((Collection)eObject.eGet(feature));
        }
        return targetDefinitionNames;
    }

    public static Set<String> getTargetDefinitionNames() {
        Map<String, String> targetDefinitions = TargletContainerItemProvider.getTargetDefinitions();
        if (targetDefinitions != null) {
            return new TreeSet<String>(targetDefinitions.keySet());
        }
        return null;
    }

    private static Map<String, String> getTargetDefinitions() {
        long now = System.currentTimeMillis();
        if (targetDefinitionInfo != null && now - timestamp < 5000L) {
            return targetDefinitionInfo;
        }
        TreeMap<String, String> result = new TreeMap<String, String>();
        try {
            Object[] targetDefinitions;
            Object[] objectArray = targetDefinitions = (Object[])ReflectUtil.getMethod((Class)CommonPlugin.loadClass((String)"org.eclipse.oomph.util.pde", (String)"org.eclipse.oomph.util.pde.TargetPlatformUtil"), (String)"getTargetDefinitions", (Class[])new Class[]{IProgressMonitor.class}).invoke(null, new Object[]{null});
            int n = targetDefinitions.length;
            int n2 = 0;
            while (n2 < n) {
                Object targetDefinition = objectArray[n2];
                String name = (String)ReflectUtil.invokeMethod((String)"getName", (Object)targetDefinition);
                Object handle = ReflectUtil.invokeMethod((String)"getHandle", (Object)targetDefinition);
                String memento = (String)ReflectUtil.invokeMethod((String)"getMemento", (Object)handle);
                result.put(name, memento);
                ++n2;
            }
            timestamp = now;
            targetDefinitionInfo = result;
            return targetDefinitionInfo;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Object createComposedTargetWrapper(final EObject eObject, EAttribute feature, String value, int index, AdapterFactory adapterFactory, ResourceLocator resourceLocator) {
        return new AttributeValueWrapperItemProvider(value, eObject, feature, index, adapterFactory, resourceLocator){

            public String getText(Object object) {
                return ComposedTargetItemLabelProvider.getTargetPlatformText(object);
            }

            public Object getImage(Object object) {
                return ComposedTargetItemLabelProvider.getTargetPlatformImage();
            }

            public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
                if (this.propertyDescriptors == null) {
                    this.propertyDescriptors = Collections.singletonList(new WrapperItemProvider.WrapperItemPropertyDescriptor((WrapperItemProvider)this, this.resourceLocator, this.feature){
                        {
                            super(wrapperItemProvider, $anonymous0, $anonymous1);
                            this.itemDelegator = new ItemPropertyDescriptor.ItemDelegator((ItemPropertyDescriptor)this, this.adapterFactory, this.resourceLocator){

                                public String getText(Object object) {
                                    return ComposedTargetItemLabelProvider.getTargetPlatformText(object);
                                }

                                public Object getImage(Object otherObject) {
                                    return ComposedTargetItemLabelProvider.getTargetPlatformImage();
                                }
                            };
                            this.staticImage = null;
                            this.displayName = TargletEditPlugin.INSTANCE.getString("_UI_TargletContainer_composedTarget_label");
                        }

                        public Collection<?> getChoiceOfValues(Object object) {
                            Set<String> targetDefinitionNames = TargletContainerItemProvider.getTargetDefinitionNames(eObject, this.feature);
                            if (object != null) {
                                targetDefinitionNames.add(this.getEditableValue(object).toString());
                            }
                            return targetDefinitionNames;
                        }
                    });
                }
                return this.propertyDescriptors;
            }
        };
    }

    public static Command createCreateChildComposedTargetCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, final Object value, int index, Collection<?> collection, CreateChildCommand.Helper helper) {
        return new CreateChildCommand(domain, owner, feature, value, index, collection, helper){

            public String getText() {
                return ComposedTargetItemLabelProvider.getTargetPlatformText(value);
            }

            public Object getImage() {
                return ComposedTargetItemLabelProvider.getTargetPlatformImage();
            }
        };
    }

    public static void collectNewChildComposedTargetDescriptors(Collection<Object> newChildDescriptors, Object object, EAttribute feature) {
        Set<String> choices = TargletContainerItemProvider.getTargetDefinitionNames((EObject)object, (EStructuralFeature)feature);
        if (choices != null && !choices.isEmpty()) {
            for (Object e : choices) {
                newChildDescriptors.add(new ModelElementItemProvider.GroupingChildCommandParameter(TargletEditPlugin.INSTANCE.getString("_UI_TargletContainer_composedTarget_label"), (Object)feature, e));
            }
        } else {
            newChildDescriptors.add(new CommandParameter(null, (Object)feature, (Object)""));
        }
    }

    public static class ComposedTargetItemLabelProvider
    implements IItemLabelProvider {
        public String getText(Object object) {
            return ComposedTargetItemLabelProvider.getTargetPlatformText(object);
        }

        public static String getTargetPlatformText(Object object) {
            if (object instanceof List) {
                return ((List)object).stream().map(ComposedTargetItemLabelProvider::getTargetPlatformText).collect(Collectors.joining(""));
            }
            if (object instanceof String) {
                return ComposedTargetItemLabelProvider.getResolvedText(object.toString());
            }
            if (object instanceof IWrapperItemProvider) {
                return ComposedTargetItemLabelProvider.getTargetPlatformText(((IWrapperItemProvider)object).getValue());
            }
            return "";
        }

        private static String getResolvedText(String result) {
            Map<String, String> targetDefinitions = TargletContainerItemProvider.getTargetDefinitions();
            if (targetDefinitions != null) {
                String resolution = targetDefinitions.get(result);
                result = (String)result + TargletContainerItemProvider.SEPARATOR + (resolution == null ? TargletEditPlugin.INSTANCE.getString("_UI_TargletContainer_unresolved_label") : URI.decode((String)resolution));
            }
            return result;
        }

        public Object getImage(Object object) {
            return ComposedTargetItemLabelProvider.getTargetPlatformImage();
        }

        public static Object getTargetPlatformImage() {
            return TargletEditPlugin.INSTANCE.getImage("full/obj16/TargetPlatform");
        }
    }
}

